package com.transsin.networkmonitor;

import static com.transsin.networkmonitor.Consts.NORMAL;
import static com.transsin.networkmonitor.Utils.GLOBAL_TAG;

import okhttp3.Call;
import okhttp3.EventListener;

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-25 19:51
 * @Description:
 */
public class MonitorFactory implements EventListener.Factory {

    private EventListener.Factory factory;

    private int usage = NORMAL;

    private boolean isTest = false;

    public MonitorFactory() {
    }

    public MonitorFactory(EventListener.Factory factory) {
        this.factory = factory;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean isTest) {
        this.factory = factory;
        this.usage = usage;
        this.isTest = isTest;
    }

    @Override
    public EventListener create(Call call) {
        EventListener eventListener = null;
        if (factory != null) {
            eventListener = factory.create(call);
        }
        String host = call.request().url().host();
        if (HostMatcher.noHosts() || HostMatcher.match(host)) {
            Utils.LOG.d(GLOBAL_TAG, "==== MonitorFactory host : ${host} matches ====");
            return new MonitorEventListener(eventListener, usage, isTest);
        } else {
            Utils.LOG.d(GLOBAL_TAG, "==== MonitorFactory host : ${host} does not matche ====");
            return eventListener == null ? EventListener.NONE : eventListener;
        }
    }
}
