package com.transsin.networkmonitor

import android.app.Application
import android.content.Context
import android.net.ConnectivityManager
import android.net.ConnectivityManager.NetworkCallback
import android.net.Network
import android.net.NetworkCapabilities
import android.net.NetworkRequest
import android.os.Build
import com.transsin.networkmonitor.Consts.APP_ID
import com.transsin.networkmonitor.Consts.CHANNEL
import com.transsin.networkmonitor.Consts.NORMAL
import com.transsion.ga.AthenaAnalytics

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-17 10:46
 * @Description:
 */
object NetworkMonitor {


    internal var isTest:Boolean = false
    internal var isNetworkValid: Boolean = false

    /**
     * NetworkMonitor初始化方法
     * @param application
     * @param hosts 需要监控的域名
     * @param isTest 是否测试
     */
    @JvmStatic
    fun init(application: Application, hosts: Array<String> = arrayOf(), isTest: Boolean = false) {
        this.isTest = isTest
        AthenaAnalytics.init(application, CHANNEL, APP_ID, isTest, false)
        AthenaAnalytics.setTest(isTest)
        HostMatcher.setHosts(hosts)
        registerNetworkCallback(application)
    }

    @JvmStatic
    fun init(application: Application, isTest: Boolean = false) {
        this.init(application, arrayOf(), isTest)
    }

    private fun registerNetworkCallback(context: Context) {
        val connectivityManager =
            context.getSystemService(Context.CONNECTIVITY_SERVICE) as? ConnectivityManager ?: return
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val request = NetworkRequest.Builder().build()
            connectivityManager.registerNetworkCallback(request, object : NetworkCallback() {
                override fun onCapabilitiesChanged(
                    network: Network,
                    networkCapabilities: NetworkCapabilities
                ) {
                    super.onCapabilitiesChanged(network, networkCapabilities)
                    isNetworkValid =
                        networkCapabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_VALIDATED)
                    Utils.LOG.d(Utils.GLOBAL_TAG, "isNetworkValid : ${isNetworkValid}")
                }

                override fun onAvailable(network: Network) {
                    super.onAvailable(network)
                    Utils.LOG.d(Utils.GLOBAL_TAG, "onAvailable : ${network}")
                }
            })
        }
    }

}