package com.transsin.networkmonitor;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;

import com.transsion.core.log.ObjectLogUtils;

import java.lang.reflect.Method;
import java.util.Locale;

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-17 10:23
 * @Description:
 */
public class Utils {
    public static final String GLOBAL_TAG = "NetworkMonitor";
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag(GLOBAL_TAG)
            .setLogHeadSwitch(true)
            .setBorderSwitch(false)
            .create();

    /**
     * 获取国家
     */
    public static String getCountry() {
        String country = "";
        try {
            @SuppressLint("PrivateApi")
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class, String.class);
            country = (String) get.invoke(systemProperties, "persist.sys.oobe_country", "unknown");
        } catch (Exception e) {
            Utils.LOG.d(Log.getStackTraceString(e));
        }

        if (TextUtils.isEmpty(country) || "unknown".equals(country)) {
            country = getLocale().getCountry();
        }
        return country;
    }

    private static Locale getLocale() {
        Locale locale;
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                locale = LocaleList.getDefault().get(0);
            } else {
                locale = Locale.getDefault();
            }
        } catch (Exception e) {
            locale = Locale.getDefault();
            Utils.LOG.d(Log.getStackTraceString(e));
        }

        return locale;
    }
}