package com.transsin.networkmonitor

import android.os.SystemClock
import androidx.core.os.bundleOf
import com.transsion.athenacust.AthenaCust
import java.lang.Integer.min
import kotlin.math.max

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-23 14:06
 * @Description:extensions
 */

fun String.printEvent() {
    Utils.LOG.d(Utils.GLOBAL_TAG, "=======/ $this /=======")
}

fun String.printErrEvent() {
    Utils.LOG.e(Utils.GLOBAL_TAG, "=======/ $this /=======")
}

fun MonitorData.asBundle() = bundleOf(
    "usage" to usage,
    "call_id" to callId,
    "call_result_code" to callResultCode,
    "error_code" to errorCode,
    "error_msg" to errorMsg,
    "server_api" to serverApi,
    "ip_address" to ipAddr,
    "req_time" to reqTime,
    "dns_time" to dnsTime,
    "tcp_time" to tcpTime,
    "ssl_time" to sslTime,
    "send_time" to sendTime,
    "wait_time" to waitTime,
    "rec_time" to recTime,
    "req_body_size" to reqBodySize,
    "res_body_size" to resBodySize,
    "cdn_req_time" to cdnReqTime,
    "cdn_down_time" to cdnDownTime,
    "cdn_speed" to cdnSpeed,
    "cdn_provider" to cdnProvider,
    "country" to country,
    "host" to host
)

fun MonitorData.track() {
    Utils.LOG.d(Utils.GLOBAL_TAG, this.toString())
    AthenaCust(Consts.EVENT, Consts.APP_ID)
        .trackCommon(this.asBundle(), null)
        .submit()
}

fun Exception.shortMsg(): String {
    this.message ?: return ""
    val endIndex = min(this.message!!.length, 200)
    return this.message!!.substring(0, endIndex)
}

fun realtime(): Long {
    return SystemClock.elapsedRealtime()
}

fun realtimeDiff(time: Long): Long {
    return realtime() - time
}