/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.account;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import org.json.JSONObject;
import tech.palm.lib.account.ProviderConfig;
import tech.palm.lib.account.data.Token;

public class XNManager {
    private XNManager() {
    }

    public static XNManager getInstance() {
        return XNManagerInner.instance;
    }

    public boolean isLogged(Context context) {
        Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_IS_LOGGED, null, null, null, null, null);
        return cursor != null && cursor.getCount() > 0;
    }

    @SuppressLint(value={"all"})
    public Token getToken(Context context) {
        Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_TOKEN, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            Token token = new Token();
            cursor.moveToNext();
            token.token = cursor.getString(cursor.getColumnIndex("token"));
            token.refreshToken = cursor.getString(cursor.getColumnIndex("refresh_token"));
            cursor.close();
            return token;
        }
        return null;
    }

    @SuppressLint(value={"all"})
    public boolean havePwd(Context context) {
        Log.d((String)"com.palm.id.log", (String)"start havePwd");
        Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_ACCOUNT, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToNext();
            String havePwd = cursor.getString(cursor.getColumnIndex("have_pwd"));
            Log.d((String)"com.palm.id.log", (String)("havePwd" + havePwd));
            cursor.close();
            return "true".equals(havePwd);
        }
        return false;
    }

    @SuppressLint(value={"all"})
    public String getUserId(Context context) {
        Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_ACCOUNT, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToNext();
            String userId = cursor.getString(cursor.getColumnIndex("user_id"));
            cursor.close();
            return userId;
        }
        return null;
    }

    public void saveToken(Context context, String token, String refreshToken) {
        Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_SAVE_TOKEN, new String[]{token, refreshToken}, null, null, null, null);
        if (cursor != null) {
            cursor.close();
        }
    }

    public void notifyUpdatePrivacy(Context context, String msg) {
        try {
            Cursor cursor;
            JSONObject jsonObject = new JSONObject(msg);
            String privacyVersion = "";
            if (jsonObject.has("privacyVersion")) {
                privacyVersion = jsonObject.getString("privacyVersion");
            }
            String userAgreement = "";
            if (jsonObject.has("userAgreement")) {
                userAgreement = jsonObject.getString("userAgreement");
            }
            if ((cursor = context.getContentResolver().query(ProviderConfig.URI_UPDATE_PRIVACY, new String[]{privacyVersion, userAgreement}, null, null, null, null)) != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout(Context context) {
        try {
            Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_LOGOUT, null, null, null, null, null);
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"all"})
    public String infoStatus(Context context) {
        Cursor cursor = context.getContentResolver().query(ProviderConfig.URI_INFO_STATUS, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToNext();
            String infoStatus = cursor.getString(cursor.getColumnIndex("info_status"));
            cursor.close();
            return infoStatus;
        }
        return "";
    }

    static class XNManagerInner {
        static XNManager instance = new XNManager();

        XNManagerInner() {
        }
    }
}

