/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.app;

import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.util.Log;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.app.TranAospActivityManager;
import com.transsion.hubsdk.app.audio.ITranAudioVolumeListener;
import com.transsion.hubsdk.app.clipboard.ITranClipboardEventListener;
import com.transsion.hubsdk.app.sun.ITranInterceptApkListener;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.app.TranThubActivityManager;
import com.transsion.hubsdk.interfaces.app.ITranActivityManagerAdapter;
import com.transsion.hubsdk.util.TranLog;

public class TranActivityManager {
    private static final String TAG = TranActivityManager.class.getSimpleName();
    private ITranActivityManagerAdapter mService;
    private TranContext mTranContext;

    public TranActivityManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubActivityManager();
            TranSdkLog.i((String)TAG, (String)"TranThubActivityManager");
        } else {
            this.mService = new TranAospActivityManager(tranContext);
            TranSdkLog.i((String)TAG, (String)"TranAospActivityManager");
        }
    }

    public ActivityManager.RunningTaskInfo getTopRunningTaskInfo(String packageName) {
        if (this.mService == null) {
            return null;
        }
        ActivityManager.RunningTaskInfo taskInfo = this.mService.getTopRunningTaskInfo(packageName);
        TranLog.i((String)TAG, (String)("getTopRunningTaskInfo: taskInfo = " + taskInfo + ", packageName = " + packageName));
        return taskInfo;
    }

    public void startTNE(String tag, long type, int pid, String externinfo) {
        if (this.mService != null) {
            Log.i((String)TAG, (String)"tran startTNE");
            this.mService.startTNE(tag, type, pid, externinfo);
        }
    }

    public void forceStopPackage(String pkg) {
        if (this.mService != null) {
            this.mService.forceStopPackage(pkg);
        }
    }

    public Configuration getConfiguration() {
        return this.mService.getConfiguration();
    }

    public void closeSystemDialogs(String reason) {
        this.mService.closeSystemDialogs(reason);
    }

    public void resumeAppSwitches() {
        this.mService.resumeAppSwitches();
    }

    public boolean isInLockTaskMode() {
        if (this.mService != null) {
            return this.mService.isInLockTaskMode();
        }
        return false;
    }

    public String getCpuId(int type) {
        return "";
    }

    public boolean registerAudioVolumeListener(ITranAudioVolumeListener listener) {
        return false;
    }

    public boolean unregisterAudioVolumeListener(ITranAudioVolumeListener listener) {
        return false;
    }

    public boolean registerClipboardEventListener(ITranClipboardEventListener listener) {
        return false;
    }

    public boolean unregisterClipboardEventListener(ITranClipboardEventListener listener) {
        return false;
    }

    public boolean registerInterceptApkListener(ITranInterceptApkListener listener) {
        return false;
    }

    public boolean unregisterInterceptApkListener(ITranInterceptApkListener listener) {
        return false;
    }

    public ActivityInfo getTopActivityInfo() {
        return this.mService.getTopActivityInfo();
    }

    public int getCurrentUser() {
        return this.mService.getCurrentUser();
    }
}

