/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.content.pm;

import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.content.pm.TranAospPackageManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.content.pm.TranParceledListSlice;
import com.transsion.hubsdk.core.content.pm.TranThubPackageManager;
import com.transsion.hubsdk.interfaces.content.pm.ITranPackageManagerAdapter;
import java.util.List;

public class TranPackageManager {
    private static final String TAG = TranPackageManager.class.getSimpleName();
    private ITranPackageManagerAdapter mService;
    private TranContext mTranContext;

    public TranPackageManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33111")) {
            this.mService = new TranThubPackageManager();
            TranSdkLog.i((String)TAG, (String)"TranThubPackageManager");
        } else {
            this.mService = new TranAospPackageManager();
            TranSdkLog.i((String)TAG, (String)"TranAospPackageManager");
        }
    }

    public void setApplicationEnabledSetting(String packageName, int newState, int flags, int userId, String callingPackage) {
        this.mService.setApplicationEnabledSetting(packageName, newState, flags, userId, callingPackage);
    }

    public void setHomeActivity(ComponentName className, int userId) {
        this.mService.setHomeActivity(className, userId);
    }

    public String[] getAppOpPermissionPackages(String permissionName) {
        return this.mService.getAppOpPermissionPackages(permissionName);
    }

    public PackageInfo getPackageInfo(String packageName, int flags, int userId) {
        return this.mService.getPackageInfo(packageName, flags, userId);
    }

    public TranParceledListSlice getInstalledApplications(int flags, int userId) {
        return this.mService.getInstalledApplications(flags, userId);
    }

    public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) {
        return this.mService.getApplicationInfo(packageName, flags, userId);
    }

    public String getNameForUid(int uid) {
        return this.mService.getNameForUid(uid);
    }

    public ComponentName getHomeActivities(List<ResolveInfo> outHomeCandidates) {
        return this.mService.getHomeActivities(outHomeCandidates);
    }

    public String[] getAllHiddenApps() {
        return this.mService.getAllHiddenApps();
    }
}

