/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.os.storage;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.os.storage.TranAospStorageManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.os.storage.TranThubStorageManager;
import com.transsion.hubsdk.interfaces.os.storage.ITranStorageManagerAdapter;
import com.transsion.hubsdk.os.storage.TranVolumeInfo;
import com.transsion.hubsdk.util.TranLog;
import java.util.List;

public class TranStorageManager {
    private static final String TAG = TranStorageManager.class.getSimpleName();
    private static ITranStorageManagerAdapter mService;
    private TranContext mTranContext;

    public TranStorageManager(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public List<TranVolumeInfo> getVolumes() {
        if (mService == null) {
            return null;
        }
        try {
            List<TranVolumeInfo> tranVolumeInfo = mService.getVolumes();
            TranLog.i((String)TAG, (String)("tranVolumeInfo = " + tranVolumeInfo));
            return tranVolumeInfo;
        }
        catch (Exception e) {
            TranLog.e((String)TAG, (String)("getMethod:" + e));
            return null;
        }
    }

    static {
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            mService = new TranThubStorageManager();
            TranSdkLog.i((String)TAG, (String)"TranThubStorageManager");
        } else {
            mService = new TranAospStorageManager();
            TranSdkLog.i((String)TAG, (String)"TranAospStorageManager");
        }
    }
}

