/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.telecom;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.telecom.TranAospTelecomManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.telecom.TranHubTelecomManager;
import com.transsion.hubsdk.interfaces.telecom.ITranTelecomManagerAdapter;

public class TranTelecomManager {
    private static final String TAG = TranTelecomManager.class.getSimpleName();
    private ITranTelecomManagerAdapter mService;
    private TranContext mTranContext;

    public TranTelecomManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33111")) {
            this.mService = new TranHubTelecomManager();
        } else {
            this.mService = new TranAospTelecomManager();
            TranSdkLog.i((String)TAG, (String)"TranAospTelecomManager");
        }
    }

    public boolean isRinging() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isRinging();
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("isRinging:" + e));
            return false;
        }
    }
}

