/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.bp;

import android.os.RemoteException;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.bp.TranThubBpManager;
import com.transsion.hubsdk.common.util.TranSdkLog;

public class TranTimeOutOrExceptionExecute<T> {
    private static final String TAG = TranTimeOutOrExceptionExecute.class.getSimpleName();
    private TranContext mTranContext;
    private static final long TIMEOUT = 200L;

    public TranTimeOutOrExceptionExecute() {
    }

    public TranTimeOutOrExceptionExecute(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public T timeOutRun(TimeOutRunnable runnable, String key) {
        long startTime = System.currentTimeMillis();
        T result = null;
        try {
            result = runnable.run();
        }
        catch (RemoteException e) {
            TranSdkLog.e((String)TAG, (String)("TimeOutException : " + (Object)((Object)e)));
        }
        this.recordTimeout(key, System.currentTimeMillis() - startTime);
        return result;
    }

    public T exceptionRun(ExceptionRunnable runnable, String key) {
        T result = null;
        try {
            result = runnable.run();
        }
        catch (RemoteException e) {
            if (this.mTranContext != null) {
                TranThubBpManager.recordException(this.mTranContext, key, e);
            }
            TranThubBpManager.recordException(key, e);
        }
        return result;
    }

    public T timeOutAndExceptionRun(TimeOutAndExceptionRunnable runnable, String key) {
        long startTime = System.currentTimeMillis();
        T result = null;
        try {
            result = runnable.run();
        }
        catch (RemoteException e) {
            if (this.mTranContext != null) {
                TranThubBpManager.recordException(this.mTranContext, key, e);
            }
            TranThubBpManager.recordException(key, e);
        }
        this.recordTimeout(key, System.currentTimeMillis() - startTime);
        return result;
    }

    public void recordTimeout(String key, long runtime) {
        if (runtime >= 200L) {
            if (this.mTranContext != null) {
                TranThubBpManager.recordTimeout(this.mTranContext, key, runtime);
            } else {
                TranThubBpManager.recordTimeout(key, runtime);
            }
        }
    }

    public static interface TimeOutAndExceptionRunnable<T> {
        public T run() throws RemoteException;
    }

    public static interface ExceptionRunnable<T> {
        public T run() throws RemoteException;
    }

    public static interface TimeOutRunnable<T> {
        public T run() throws RemoteException;
    }
}

