/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.core.app;

import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.app.ITranActivityManager;
import com.transsion.hubsdk.app.audio.ITranAudioVolumeListener;
import com.transsion.hubsdk.app.clipboard.ITranClipboardEventListener;
import com.transsion.hubsdk.app.sun.ITranInterceptApkListener;
import com.transsion.hubsdk.bp.TranTimeOutOrExceptionExecute;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.interfaces.app.ITranActivityManagerAdapter;

public class TranThubActivityManager
implements ITranActivityManagerAdapter {
    private static final String TAG = TranThubActivityManager.class.getSimpleName();
    private static ITranActivityManager mService;

    public TranThubActivityManager() {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"activity");
        mService = ITranActivityManager.Stub.asInterface((IBinder)serviceIBinder);
    }

    @Override
    public ActivityManager.RunningTaskInfo getTopRunningTaskInfo(String packageName) {
        if (mService == null) {
            return null;
        }
        try {
            ActivityManager.RunningTaskInfo taskInfo = mService.getTopRunningTaskInfo(packageName);
            return taskInfo;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void startTNE(String tag, long type, int pid, String externinfo) {
        if (mService != null) {
            try {
                mService.startTNE(tag, type, pid, externinfo);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void forceStopPackage(String pkg) {
        if (mService != null) {
            try {
                mService.forceStopPackage(pkg);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Configuration getConfiguration() {
        try {
            return mService.getConfiguration();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void closeSystemDialogs(String reason) {
        try {
            mService.closeSystemDialogs(reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void resumeAppSwitches() {
        try {
            mService.resumeAppSwitches();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isInLockTaskMode() {
        if (mService != null) {
            try {
                return mService.isInLockTaskMode();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public String getCpuId(int type) {
        return "";
    }

    @Override
    public boolean registerAudioVolumeListener(ITranAudioVolumeListener listener) {
        return false;
    }

    @Override
    public boolean unregisterAudioVolumeListener(ITranAudioVolumeListener listener) {
        return false;
    }

    @Override
    public boolean registerClipboardEventListener(ITranClipboardEventListener listener) {
        return false;
    }

    @Override
    public boolean unregisterClipboardEventListener(ITranClipboardEventListener listener) {
        return false;
    }

    @Override
    public boolean registerInterceptApkListener(ITranInterceptApkListener listener) {
        return false;
    }

    @Override
    public boolean unregisterInterceptApkListener(ITranInterceptApkListener listener) {
        return false;
    }

    @Override
    public ActivityInfo getTopActivityInfo() {
        ActivityInfo mActivityInfo = (ActivityInfo)new TranTimeOutOrExceptionExecute().timeOutAndExceptionRun(() -> {
            if (mService != null) {
                return mService.getTopActivityInfo();
            }
            return null;
        }, "activity");
        TranSdkLog.i((String)TAG, (String)("getTopActivityInfo mActivityInfo:" + mActivityInfo));
        return mActivityInfo;
    }

    @Override
    public int getCurrentUser() {
        try {
            return mService.getCurrentUser();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

