/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.core.app;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.content.ComponentName;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.app.ITranNotificationManager;
import com.transsion.hubsdk.content.pm.TranParceledListSlice;
import com.transsion.hubsdk.interfaces.app.ITranNotificationManagerAdapter;

public class TranThubNotificationManager
implements ITranNotificationManagerAdapter {
    private static final String TAG = TranThubNotificationManager.class.getSimpleName();
    private static ITranNotificationManager mService;

    public TranThubNotificationManager() {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"notification");
        mService = ITranNotificationManager.Stub.asInterface((IBinder)serviceIBinder);
    }

    @Override
    public void setNotificationListenerAccessGranted(ComponentName listener, boolean granted, boolean userSet) {
        if (mService != null) {
            try {
                mService.setNotificationListenerAccessGranted(listener, granted, userSet);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateNotificationChannel(String pkg, int uid, NotificationChannel channel) {
        if (mService != null) {
            try {
                mService.updateNotificationChannelForPackage(pkg, uid, channel);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean areNotificationsEnabledForPackage(String pkg, int uid) {
        if (mService != null) {
            try {
                return mService.areNotificationsEnabledForPackage(pkg, uid);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public NotificationChannel getNotificationChannelForPackage(String pkg, int uid, String channelId, String conversationId, boolean includeDeleted) {
        if (mService != null) {
            try {
                return mService.getNotificationChannelForPackage(pkg, uid, channelId, conversationId, includeDeleted);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean onlyHasDefaultChannel(String pkg, int uid) {
        if (mService != null) {
            try {
                return mService.onlyHasDefaultChannel(pkg, uid);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) {
        if (mService != null) {
            try {
                mService.setNotificationsEnabledForPackage(pkg, uid, enabled);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setShowBadge(String pkg, int uid, boolean showBadge) {
        if (mService != null) {
            try {
                mService.setShowBadge(pkg, uid, showBadge);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean canShowBadge(String pkg, int uid) {
        if (mService != null) {
            try {
                return mService.canShowBadge(pkg, uid);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public TranParceledListSlice<NotificationChannelGroup> getNotificationChannelGroupsForPackage(String pkg, int uid, boolean includeDeleted) {
        if (mService != null) {
            try {
                return mService.getNotificationChannelGroupsForPackage(pkg, uid, includeDeleted);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

