/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.core.telephony;

import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.bp.TranTimeOutOrExceptionExecute;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.interfaces.telephony.ITranTelephonyManagerAdapter;
import com.transsion.hubsdk.telephony.ITranTelephony;
import com.transsion.hubsdk.telephony.TranServiceState;

public class TranThubTelephonyManager
implements ITranTelephonyManagerAdapter {
    private static final String TAG = TranThubTelephonyManager.class.getSimpleName();
    private static ITranTelephony mService;

    public TranThubTelephonyManager() {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"telephony");
        mService = ITranTelephony.Stub.asInterface((IBinder)serviceIBinder);
    }

    @Override
    public boolean setAllowedNetworkTypesForReason(int subId, int reason, long allowedNetworkTypes) {
        if (mService == null) {
            return false;
        }
        try {
            return mService.setAllowedNetworkTypesForReason(subId, reason, allowedNetworkTypes);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setPreferredNetworkType(int phoneId, long networkType) {
        if (mService == null) {
            return;
        }
        try {
            mService.setPreferredNetworkType(phoneId, networkType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setRadioForSubscriber(int subId, boolean turnOn) {
        if (mService == null) {
            return false;
        }
        try {
            boolean res = mService.setRadioForSubscriber(subId, turnOn);
            return res;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isRadioOnForSubscriber(int subId, String callingPackage) {
        if (mService == null) {
            return false;
        }
        try {
            return mService.isRadioOnForSubscriber(subId, callingPackage);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public TranServiceState getServiceState() {
        if (mService == null) {
            return null;
        }
        try {
            return mService.getServiceState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setDataEnabled(boolean enable) {
        if (mService == null) {
            return;
        }
        try {
            mService.setDataEnabled(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getDataEnabled() {
        if (mService == null) {
            return false;
        }
        try {
            return mService.getDataEnabled();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int getRadioPowerState() {
        int state = (Integer)new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (mService != null) {
                return mService.getRadioPowerState();
            }
            return 0;
        }, "telephony");
        TranSdkLog.i((String)TAG, (String)("getRadioPowerState state:" + state));
        return state;
    }

    @Override
    public int getSimCount() {
        int simCount = (Integer)new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (mService != null) {
                return mService.getSimCount();
            }
            return 0;
        }, "telephony");
        TranSdkLog.i((String)TAG, (String)("getSimCount simCount:" + simCount));
        return simCount;
    }

    @Override
    public int getSimState() {
        int simState = (Integer)new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (mService != null) {
                return mService.getSimState();
            }
            return 0;
        }, "telephony");
        TranSdkLog.i((String)TAG, (String)("getSimState simState:" + simState));
        return simState;
    }

    @Override
    public int getSimStateSlotIndex(int slotIndex) {
        int simStateSlot = (Integer)new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (mService != null) {
                return mService.getSimStateSlotIndex(slotIndex);
            }
            return 0;
        }, "telephony");
        TranSdkLog.i((String)TAG, (String)("getSimStateSlotIndex simStateSlot:" + simStateSlot));
        return simStateSlot;
    }
}

