/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.internal.app;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.internal.app.ITranLocalePicker;
import com.transsion.hubsdk.internal.app.TranLocale;
import com.transsion.hubsdk.internal.app.TranLocaleInfo;
import com.transsion.hubsdk.provider.TranDeviceConfigManager;
import java.util.ArrayList;
import java.util.List;

public class TranLocalePickerManager {
    private static final String TAG = TranDeviceConfigManager.class.getSimpleName();
    private static ITranLocalePicker mService;
    private TranContext mTranContext;

    public TranLocalePickerManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"locale_picker");
        Log.d((String)TAG, (String)("TranLocalePickerManager: " + serviceIBinder));
        mService = ITranLocalePicker.Stub.asInterface((IBinder)serviceIBinder);
    }

    public void updateLocale(TranLocale locale) {
        if (mService == null) {
            return;
        }
        try {
            mService.updateLocale(locale);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public List<TranLocaleInfo> getAllAssetLocales(boolean isInDeveloperMode) {
        ArrayList<TranLocaleInfo> tranLocaleArr = new ArrayList<TranLocaleInfo>();
        if (mService == null) {
            return tranLocaleArr;
        }
        try {
            return mService.getAllAssetLocales(isInDeveloperMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return tranLocaleArr;
        }
    }
}

