/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.internal.logging;

import android.content.Context;
import android.os.IBinder;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.internal.logging.ITranMetricsLogger;
import com.transsion.hubsdk.util.TranLog;

public class TranMetricsLogger {
    private static final String TAG = TranMetricsLogger.class.getSimpleName();
    private static ITranMetricsLogger mService;
    private TranContext mTranContext;

    public TranMetricsLogger(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public static void action(Context context, int category) {
        try {
            mService.action(category, 0, null);
        }
        catch (Exception e) {
            TranLog.e((String)TAG, (String)("getMethod:" + e));
        }
    }

    public static void action(Context context, int category, int value) {
        try {
            mService.action(category, value, null);
        }
        catch (Exception e) {
            TranLog.e((String)TAG, (String)("getMethod:" + e));
        }
    }

    public static void histogram(Context context, String name, int bucket) {
        try {
            mService.histogram(name, bucket);
        }
        catch (Exception e) {
            TranLog.e((String)TAG, (String)("getMethod:" + e));
        }
    }

    public static void visible(Context context, int category) throws IllegalArgumentException {
        try {
            mService.visible(category);
        }
        catch (Exception e) {
            TranLog.e((String)TAG, (String)("getMethod:" + e));
        }
    }

    static {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"metrics_logger");
        mService = ITranMetricsLogger.Stub.asInterface((IBinder)serviceIBinder);
    }
}

