/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.common.reflect;

import android.util.ArrayMap;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiFunction;

public final class TranDoorMan {
    private static final String TAG = "os.FrameworkDoorMan";
    private static final boolean DEBUG = true;

    public static Class getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)("access class " + className + " failed!"), (Throwable)t);
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Throwable err = null;
        try {
            while (clazz != Object.class) {
                try {
                    Field res = clazz.getDeclaredField(fieldName);
                    res.setAccessible(true);
                    return res;
                }
                catch (Throwable t) {
                    err = t;
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Log.w((String)TAG, (String)("access filed " + fieldName + " of " + clazz + " failed!"), (Throwable)err);
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] params) {
        Throwable err = null;
        try {
            while (clazz != Object.class) {
                try {
                    Method res = clazz.getDeclaredMethod(methodName, params);
                    res.setAccessible(true);
                    return res;
                }
                catch (Throwable t) {
                    err = t;
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Class<?> param : params) {
                sb.append(param == null ? "null," : param.getSimpleName()).append(",");
            }
        }
        Log.w((String)TAG, (String)("access method " + methodName + " " + sb.toString() + " of " + clazz + " failed!"), (Throwable)err);
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] params) {
        try {
            Constructor<T> res = clazz.getDeclaredConstructor(params);
            res.setAccessible(true);
            return res;
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            if (params != null) {
                for (Class<?> param : params) {
                    sb.append(param == null ? "null," : param.getSimpleName()).append(",");
                }
            }
            Log.w((String)TAG, (String)("access constructor " + sb.toString() + " of " + clazz + " failed!"), (Throwable)t);
            return null;
        }
    }

    public static int getStaticFinalInt(Class<?> clazz, String name, int defaultValue) {
        Field field = TranDoorMan.getField(clazz, name);
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.getInt(null);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static boolean getStaticFinalBoolean(Class<?> clazz, String name, boolean defaultValue) {
        Field field = TranDoorMan.getField(clazz, name);
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.getBoolean(null);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static String getFieldString(String className, String fieldName, String defaultValue) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = TranDoorMan.getField(clazz, fieldName);
            if (field == null) {
                return defaultValue;
            }
            Object obj = clazz.newInstance();
            String strVer = (String)field.get(obj);
            return strVer;
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static class AdditionalField<T, M> {
        protected final Field mRealField;
        protected final Object mLockMock;
        protected final WeakHashMap<T, M> mMockField;
        private static final ArrayMap<String, AdditionalField<?, ?>> ADDITIONAL_FIELDS = new ArrayMap();

        public AdditionalField(Class<T> clazz, String fieldName) {
            this(clazz, fieldName, false);
        }

        public AdditionalField(Class<T> clazz, String fieldName, boolean lock) {
            this.mRealField = TranDoorMan.getField(clazz, fieldName);
            this.mLockMock = lock && this.mRealField == null ? new Object() : null;
            this.mMockField = this.mRealField != null ? null : new WeakHashMap();
            Log.d((String)TranDoorMan.TAG, (String)("add field " + fieldName + " to " + clazz + (this.mRealField == null ? " by mock  lock:" + lock : " by source-modified.")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T, M> AdditionalField<T, M> get(Class<T> clazz, String fieldName) {
            if (clazz == null || fieldName == null || fieldName.isEmpty()) {
                return null;
            }
            String key = clazz.getName() + "." + fieldName;
            ArrayMap<String, AdditionalField<?, ?>> arrayMap = ADDITIONAL_FIELDS;
            synchronized (arrayMap) {
                AdditionalField<T, M> res = (AdditionalField<T, M>)ADDITIONAL_FIELDS.get((Object)key);
                if (res == null) {
                    res = new AdditionalField<T, M>(clazz, fieldName);
                    ADDITIONAL_FIELDS.put((Object)key, res);
                }
                return res;
            }
        }

        public M get(T instance) throws IllegalArgumentException, IllegalAccessException {
            if (instance == null) {
                return null;
            }
            if (this.mRealField != null) {
                return (M)this.mRealField.get(instance);
            }
            return this.getMock(instance);
        }

        public boolean set(T instance, M member) throws IllegalArgumentException, IllegalAccessException {
            if (instance == null) {
                return false;
            }
            if (this.mRealField != null) {
                this.mRealField.set(instance, member);
                return true;
            }
            return this.setMock(instance, member);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected M getMock(T instance) {
            if (this.mLockMock != null) {
                Object object = this.mLockMock;
                synchronized (object) {
                    return this.mMockField.get(instance);
                }
            }
            return this.mMockField.get(instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean setMock(T instance, M member) {
            if (this.mLockMock != null) {
                Object object = this.mLockMock;
                synchronized (object) {
                    return this.mMockField.put(instance, member) != null;
                }
            }
            return this.mMockField.put(instance, member) != null;
        }
    }

    public static class AdditionalFieldStaticFinalInt {
        private static final ArrayMap<Class<?>, ArrayMap<String, Integer>> ADDITIONAL_FIELDS = new ArrayMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Integer walkField(Class<?> clazz, BiFunction<String, Integer, Integer> func, ArrayMap<String, Integer> additional) {
            Field[] fields = clazz.getDeclaredFields();
            Integer max = null;
            for (Field field : fields) {
                if (field.getType() != Integer.TYPE || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                boolean inAccess = false;
                try {
                    Integer res;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                        inAccess = true;
                    }
                    if ((res = func.apply(field.getName(), field.getInt(null))) == null) continue;
                    if (max == null) {
                        max = res;
                        continue;
                    }
                    max = Math.max(res, max);
                }
                catch (Throwable t) {
                    Log.e((String)TranDoorMan.TAG, (String)("add field walk static final int field of " + clazz + " failed! " + ""), (Throwable)t);
                }
                finally {
                    if (inAccess) {
                        field.setAccessible(false);
                    }
                }
            }
            for (Map.Entry item : additional.entrySet()) {
                Integer res = func.apply((String)item.getKey(), (Integer)item.getValue());
                if (res == null) continue;
                if (max == null) {
                    max = res;
                    continue;
                }
                max = Math.max(res, max);
            }
            return max;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> int get(Class<T> clazz, String fieldName, BiFunction<String, Integer, Integer> func, int defaultValue) {
            if (clazz == null || fieldName == null || fieldName.isEmpty()) {
                return defaultValue;
            }
            Field realField = TranDoorMan.getField(clazz, fieldName);
            Integer res = null;
            if (realField != null) {
                try {
                    res = realField.getInt(null);
                    Log.d((String)TranDoorMan.TAG, (String)("add field static-final-int " + fieldName + " to " + clazz + " by source-modified set " + res));
                    return res;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ArrayMap<Class<?>, ArrayMap<String, Integer>> arrayMap = ADDITIONAL_FIELDS;
            synchronized (arrayMap) {
                ArrayMap members = (ArrayMap)ADDITIONAL_FIELDS.get(clazz);
                if (members != null) {
                    res = (Integer)members.get((Object)fieldName);
                    if (res != null) {
                        return res;
                    }
                } else {
                    members = new ArrayMap();
                    ADDITIONAL_FIELDS.put(clazz, (Object)members);
                }
                if (func != null) {
                    res = AdditionalFieldStaticFinalInt.walkField(clazz, func, (ArrayMap<String, Integer>)members);
                    Log.d((String)TranDoorMan.TAG, (String)("add field static-final-int " + fieldName + " to " + clazz + " by policy set " + res));
                }
                if (res == null) {
                    res = defaultValue;
                    Log.d((String)TranDoorMan.TAG, (String)("add field static-final-int " + fieldName + " to " + clazz + " by default set " + defaultValue));
                }
                members.put((Object)fieldName, (Object)res);
                return res;
            }
        }
    }
}

