/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.common.version;

import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.os.TranBuild;

public class TranVersion {
    private static final String TAG = TranVersion.class.getSimpleName();
    public static int THUBCORE_VERSION = 0;
    private static final int STACK_COUNT = 3;

    public static boolean isIntegratedThubCore(String methodVersion) {
        try {
            if (THUBCORE_VERSION >= Integer.valueOf(methodVersion) && Integer.valueOf(methodVersion) >= Integer.valueOf("33101")) {
                return true;
            }
        }
        catch (Exception e) {
            TranSdkLog.e(TAG, "supportThubCore: e = " + e);
        }
        TranSdkLog.w(TAG, "THUBCore No support Call!!! method version = " + methodVersion + ", ThubCore vserion = " + THUBCORE_VERSION + "\n" + TranVersion.getStackTrace(new Throwable(), 3));
        return false;
    }

    private static String getStackTrace(Throwable throwable, int stackCount) {
        try {
            StackTraceElement[] ste = throwable.getStackTrace();
            StringBuilder message = new StringBuilder(throwable.toString());
            int i = 0;
            for (StackTraceElement element : ste) {
                message.append("\n#" + element.getClassName()).append(".").append(element.getMethodName()).append("[" + element.getLineNumber() + "]");
                if (++i >= stackCount) break;
            }
            return message.toString();
        }
        catch (Exception ex) {
            TranSdkLog.w(TAG, "getStackTrace Exception" + ex);
            return "";
        }
    }

    static {
        try {
            String version = TranBuild.THUBCORE_VERSION;
            THUBCORE_VERSION = Integer.valueOf(version.replace(".", ""));
            TranSdkLog.i(TAG, "initializer: version = " + version + ", THUBCORE_VERSION = " + THUBCORE_VERSION);
        }
        catch (Exception e) {
            TranSdkLog.e(TAG, "static initializer: e = " + e.getMessage());
        }
    }

    public static class Core {
        public static final String PLATFORM_VERSION = "33";
        public static final String VERSION_33101 = "33101";
        public static final String VERSION_33111 = "33111";
    }
}

