/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.http;

import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HttpsConfigUtil {
    public static final String CONFIG_TAN_CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIDqTCCApGgAwIBAgIJAJ0NJH7zEvQVMA0GCSqGSIb3DQEBCwUAMGoxCzAJBgNV\nBAYTAklSMQ8wDQYDVQQIDAZEdWJsaW4xDzANBgNVBAcMBkR1YmxpbjESMBAGA1UE\nCgwJbW9iYWR2ZW50MQswCQYDVQQLDAJNSTEYMBYGA1UEAwwPKi5tb2JhZHZlbnQu\nY29tMCAXDTE3MDkyOTAzMDIwMloYDzIxMTcwOTA1MDMwMjAyWjBqMQswCQYDVQQG\nEwJJUjEPMA0GA1UECAwGRHVibGluMQ8wDQYDVQQHDAZEdWJsaW4xEjAQBgNVBAoM\nCW1vYmFkdmVudDELMAkGA1UECwwCTUkxGDAWBgNVBAMMDyoubW9iYWR2ZW50LmNv\nbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAORRW0xU1ORADBfFxVn4\nFlkUQrmqhYHlteE913+V1qEJHXNOlPlQ58JRhBxN+srm+/RcL8wV0IL00L3nGwix\nL6QHN06sUNaS5VeBap7v9TPXfXcdsI6ZdiCl0StCg2HJ6GFT2+wtYulanKXn1F2L\nzLMoz0CNFjDhRpXNRrQJb0rP5/YrosXNVBKGbtvjhuTNN4/BkhYnlJlBSC/XCH4x\ntxHSSta91+1pPasbAyOFN99cN5Q0R4jRdK1//lU9Q7DXbmHLT1l4xoHE+bhXhPge\n7BhgIM7WDLqg2LcMuvy1MIYUVxavIF0yQJwgCV+URmnMOpP2CtSAghrUn+2iuJ23\ncUMCAwEAAaNQME4wHQYDVR0OBBYEFBezBDUYJb9S9WqQNAQnPN7YxUv+MB8GA1Ud\nIwQYMBaAFBezBDUYJb9S9WqQNAQnPN7YxUv+MAwGA1UdEwQFMAMBAf8wDQYJKoZI\nhvcNAQELBQADggEBAEsUHUkpt8r0rIv61Uoqgax93AtpctGdZOtGLC9gOxmCB57Z\nHCq7CCwiQvgUm2yJ9bI+yYm4QLXyY6CVU6TBxgnczKEn6N50X46t/sN99HHDyjDP\nGGkSUvYVxcltykrIXplVl20MkdScP+1zE+xbAYvP/0/SfnEkb2baOZ3pEQX70Z0u\nKntk/GzMIW2TuEZM8Uh/f65djzo6xuGls9EEchEbxThcqHTSK20szv73+vXvchVs\n2c2VPHM0BZKIChLBcI15aBo6HnR0I0CFdq/pT2fllVspY5TD/evHKX+0HR9e29dN\nwF879UmmL0kAyObWEiHn98+wIlW29/T0eGaBtB4=\n-----END CERTIFICATE-----";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("cert", certificate);
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }
}

