/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.util;

import com.zero.ta.common.util.AdLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File ab;
    private final File ac;
    private final File ad;
    private final int ae;
    private final long af;
    private final int ag;
    private long ah = 0L;
    private Writer ai;
    private final LinkedHashMap<String, a> aj = new LinkedHashMap(0, 0.75f, true);
    private int ak;
    private long al = 0L;
    private final ExecutorService am = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> an = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void k() throws Exception {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.ai == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.h()) {
                    DiskLruCache.this.g();
                    DiskLruCache.this.ak = 0;
                }
            }
            return null;
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.k();
        }
    };

    private static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        int n3 = TArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n, objectArray, 0, n5);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String readAsciiLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n == 10) break;
            stringBuilder.append((char)n);
        }
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\r') {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteContents(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            AdLogUtil.LOG.d((Object)("not a directory: " + file));
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                DiskLruCache.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    private DiskLruCache(File file, int n, int n2, long l) {
        this.ab = file;
        this.ae = n;
        this.ac = new File(file, "journal");
        this.ad = new File(file, "journal.tmp");
        this.ag = n2;
        this.af = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) throws IOException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        DiskLruCache diskLruCache = new DiskLruCache(file, n, n2, l);
        if (diskLruCache.ac.exists()) {
            try {
                diskLruCache.e();
                diskLruCache.f();
                diskLruCache.ai = new BufferedWriter(new FileWriter(diskLruCache.ac, true), 8192);
                return diskLruCache;
            }
            catch (IOException iOException) {
                diskLruCache.delete();
            }
        }
        file.mkdirs();
        diskLruCache = new DiskLruCache(file, n, n2, l);
        diskLruCache.g();
        return diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.ac), 8192);
        try {
            String string = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string2 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string3 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string4 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string5 = DiskLruCache.readAsciiLine(bufferedInputStream);
            if (!("libcore.io.DiskLruCache".equals(string) && "1".equals(string2) && Integer.toString(this.ae).equals(string3) && Integer.toString(this.ag).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            try {
                while (true) {
                    this.b(DiskLruCache.readAsciiLine(bufferedInputStream));
                }
            }
            catch (EOFException eOFException) {
                DiskLruCache.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            DiskLruCache.closeQuietly(bufferedInputStream);
            throw throwable;
        }
    }

    private void b(String string) throws IOException {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            throw new IOException("unexpected journal line: " + string);
        }
        String string2 = stringArray[1];
        if (stringArray[0].equals("REMOVE") && stringArray.length == 2) {
            this.aj.remove(string2);
            return;
        }
        a a2 = this.aj.get(string2);
        if (a2 == null) {
            a2 = new a(string2);
            this.aj.put(string2, a2);
        }
        if (stringArray[0].equals("CLEAN") && stringArray.length == 2 + this.ag) {
            a2.au = true;
            a2.av = null;
            a2.a(DiskLruCache.copyOfRange(stringArray, 2, stringArray.length));
        } else if (stringArray[0].equals("DIRTY") && stringArray.length == 2) {
            a2.av = new Editor(a2);
        } else if (!stringArray[0].equals("READ") || stringArray.length != 2) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private void f() throws IOException {
        DiskLruCache.a(this.ad);
        Iterator<a> iterator = this.aj.values().iterator();
        while (iterator.hasNext()) {
            int n;
            a a2 = iterator.next();
            if (a2.av == null) {
                for (n = 0; n < this.ag; ++n) {
                    this.ah += a2.at[n];
                }
                continue;
            }
            a2.av = null;
            for (n = 0; n < this.ag; ++n) {
                DiskLruCache.a(a2.a(n));
                DiskLruCache.a(a2.b(n));
            }
            iterator.remove();
        }
    }

    private synchronized void g() throws IOException {
        if (this.ai != null) {
            this.ai.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.ad), 8192);
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.ae));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.ag));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (a a2 : this.aj.values()) {
            if (a2.av != null) {
                bufferedWriter.write("DIRTY " + a2.as + '\n');
                continue;
            }
            bufferedWriter.write("CLEAN " + a2.as + a2.l() + '\n');
        }
        ((Writer)bufferedWriter).close();
        this.ad.renameTo(this.ac);
        this.ai = new BufferedWriter(new FileWriter(this.ac, true), 8192);
    }

    private static void a(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string) throws IOException {
        this.i();
        this.c(string);
        a a2 = this.aj.get(string);
        if (a2 == null) {
            return null;
        }
        if (!a2.au) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.ag];
        try {
            for (int i = 0; i < this.ag; ++i) {
                inputStreamArray[i] = new FileInputStream(a2.a(i));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        ++this.ak;
        this.ai.append("READ " + string + '\n');
        if (this.h()) {
            this.am.submit(this.an);
        }
        return new Snapshot(string, a2.aw, inputStreamArray);
    }

    public Editor edit(String string) throws IOException {
        return this.a(string, -1L);
    }

    private synchronized Editor a(String string, long l) throws IOException {
        this.i();
        this.c(string);
        a a2 = this.aj.get(string);
        if (l != -1L && (a2 == null || a2.aw != l)) {
            return null;
        }
        if (a2 == null) {
            a2 = new a(string);
            this.aj.put(string, a2);
        } else if (a2.av != null) {
            return null;
        }
        Editor editor = new Editor(a2);
        a2.av = editor;
        this.ai.write("DIRTY " + string + '\n');
        this.ai.flush();
        return editor;
    }

    public File getDirectory() {
        return this.ab;
    }

    public long maxSize() {
        return this.af;
    }

    public synchronized long size() {
        return this.ah;
    }

    private synchronized void a(Editor editor, boolean bl) throws IOException {
        int n;
        a a2 = editor.ap;
        if (a2.av != editor) {
            throw new IllegalStateException();
        }
        if (bl && !a2.au) {
            for (n = 0; n < this.ag; ++n) {
                if (a2.b(n).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n = 0; n < this.ag; ++n) {
            File file = a2.b(n);
            if (bl) {
                long l;
                if (!file.exists()) continue;
                File file2 = a2.a(n);
                file.renameTo(file2);
                long l2 = a2.at[n];
                ((a)a2).at[n] = l = file2.length();
                this.ah = this.ah - l2 + l;
                continue;
            }
            DiskLruCache.a(file);
        }
        ++this.ak;
        a2.av = null;
        if (a2.au | bl) {
            a2.au = true;
            this.ai.write("CLEAN " + a2.as + a2.l() + '\n');
            if (bl) {
                a2.aw = this.al++;
            }
        } else {
            this.aj.remove(a2.as);
            this.ai.write("REMOVE " + a2.as + '\n');
        }
        if (this.ah > this.af || this.h()) {
            this.am.submit(this.an);
        }
    }

    private boolean h() {
        int n = 2000;
        return this.ak >= 2000 && this.ak >= this.aj.size();
    }

    public synchronized boolean remove(String string) throws IOException {
        this.i();
        this.c(string);
        a a2 = this.aj.get(string);
        if (a2 == null || a2.av != null) {
            return false;
        }
        for (int i = 0; i < this.ag; ++i) {
            File file = a2.a(i);
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.ah -= a2.at[i];
            ((a)a2).at[i] = 0L;
        }
        ++this.ak;
        this.ai.append("REMOVE " + string + '\n');
        this.aj.remove(string);
        if (this.h()) {
            this.am.submit(this.an);
        }
        return true;
    }

    public boolean isClosed() {
        return this.ai == null;
    }

    private void i() {
        if (this.ai == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.i();
        this.trimToSize();
        this.ai.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.ai == null) {
            return;
        }
        for (a a2 : new ArrayList<a>(this.aj.values())) {
            if (a2.av == null) continue;
            a2.av.abort();
        }
        this.trimToSize();
        this.ai.close();
        this.ai = null;
    }

    private void trimToSize() throws IOException {
        while (this.ah > this.af) {
            Map.Entry<String, a> entry = this.aj.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() throws IOException {
        this.close();
        DiskLruCache.deleteContents(this.ab);
    }

    private void c(String string) {
        if (string.contains(" ") || string.contains("\n") || string.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + string + "\"");
        }
    }

    private static String a(InputStream inputStream) throws IOException {
        return DiskLruCache.readFully(new InputStreamReader(inputStream, UTF_8));
    }

    private final class a {
        private final String as;
        private final long[] at;
        private boolean au;
        private Editor av;
        private long aw;

        private a(String string) {
            this.as = string;
            this.at = new long[DiskLruCache.this.ag];
        }

        public String l() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.at) {
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void a(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.ag) {
                throw this.b(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.at[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.b(stringArray);
            }
        }

        private IOException b(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File a(int n) {
            return new File(DiskLruCache.this.ab, this.as + "." + n);
        }

        public File b(int n) {
            return new File(DiskLruCache.this.ab, this.as + "." + n + ".tmp");
        }
    }

    public final class Editor {
        private final com.zero.ta.common.util.DiskLruCache$a ap;
        private boolean aq;

        private Editor(com.zero.ta.common.util.DiskLruCache$a a2) {
            this.ap = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.ap.av != this) {
                    throw new IllegalStateException();
                }
                if (!this.ap.au) {
                    return null;
                }
                return new FileInputStream(this.ap.a(n));
            }
        }

        public String getString(int n) throws IOException {
            InputStream inputStream = this.newInputStream(n);
            return inputStream != null ? DiskLruCache.a(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.ap.av != this) {
                    throw new IllegalStateException();
                }
                return new a(new FileOutputStream(this.ap.b(n)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n, String string) throws IOException {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), UTF_8);
                outputStreamWriter.write(string);
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCache.closeQuietly(outputStreamWriter);
        }

        public void commit() throws IOException {
            if (this.aq) {
                DiskLruCache.this.a(this, false);
                DiskLruCache.this.remove(this.ap.as);
            } else {
                DiskLruCache.this.a(this, true);
            }
        }

        public void abort() throws IOException {
            DiskLruCache.this.a(this, false);
        }

        private class a
        extends FilterOutputStream {
            private a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (IOException iOException) {
                    Editor.this.aq = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    Editor.this.aq = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.this.aq = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.this.aq = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String as;
        private final long aw;
        private final InputStream[] ax;

        private Snapshot(String string, long l, InputStream[] inputStreamArray) {
            this.as = string;
            this.aw = l;
            this.ax = inputStreamArray;
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.a(this.as, this.aw);
        }

        public InputStream getInputStream(int n) {
            return this.ax[n];
        }

        public String getString(int n) throws IOException {
            return DiskLruCache.a(this.getInputStream(n));
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.ax) {
                DiskLruCache.closeQuietly(inputStream);
            }
        }
    }
}

