/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.http.listener;

import android.os.Looper;
import com.transsion.json.Tson;
import com.zero.ta.common.constant.TaErrorCode;
import com.zero.ta.common.http.listener.ResponseBaseListener;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class CommonResponseListener<E>
extends ResponseBaseListener {
    protected CommonResponseListener() {
    }

    protected CommonResponseListener(Looper looper) {
        super(looper);
    }

    protected abstract void onRequestSuccess(int var1, E var2);

    @Override
    public void onServerRequestSuccess(int n, String string) {
        this.parseResponse(n, string);
    }

    @Override
    public void onServerRequestSuccess(int n, byte[] byArray) {
        String string = null;
        try {
            string = this.getResponseString(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.onRequestError(TaErrorCode.PARSE_DATA_ERROR);
            unsupportedEncodingException.printStackTrace();
        }
        this.parseResponse(n, string);
    }

    public void parseResponse(final int n, String string) {
        try {
            Type type = this.getClass().getGenericSuperclass();
            if (!(type instanceof ParameterizedType)) {
                throw new RuntimeException("Missing type parameter.");
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getActualTypeArguments()[0];
            Object object = null;
            if ("class java.lang.String".equals(type2.toString())) {
                object = string;
            } else if (type2 instanceof Class) {
                object = Tson.fromJson((String)string, (Class)((Class)type2));
            }
            final String string2 = object;
            if (this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        CommonResponseListener.this.onRequestSuccess(n, string2);
                    }
                });
            } else {
                this.onRequestSuccess(n, string2);
            }
        }
        catch (Exception exception) {
            this.onRequestError(TaErrorCode.PARSE_DATA_ERROR);
            exception.printStackTrace();
        }
    }

    private String getResponseString(byte[] byArray, String string) throws UnsupportedEncodingException {
        String string2;
        String string3 = string2 = byArray == null ? null : new String(byArray, string);
        if (string2 != null && string2.startsWith("\ufeff")) {
            return string2.substring(1);
        }
        return string2;
    }
}

