/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.http.listener;

import android.os.Handler;
import android.os.Looper;
import com.zero.ta.common.constant.TaErrorCode;

public abstract class ResponseBaseListener {
    protected Handler handler = null;

    public ResponseBaseListener() {
        this(null);
    }

    protected ResponseBaseListener(boolean bl) {
        this(bl ? null : Looper.myLooper(), bl);
    }

    protected ResponseBaseListener(Looper looper) {
        this(looper == null ? Looper.myLooper() : looper, false);
    }

    private ResponseBaseListener(Looper looper, boolean bl) {
        this.handler = !bl ? new a(looper) : null;
    }

    protected abstract void onRequestError(TaErrorCode var1);

    public void onServerRequestFailure(int n, String string, Throwable throwable) {
        this.onServerRequestFailure(new TaErrorCode(n, "erro msg = " + string));
    }

    public void onServerRequestFailure(int n, byte[] byArray, Throwable throwable) {
        this.onServerRequestFailure(new TaErrorCode(n, "erro msg = " + byArray));
    }

    public void onServerRequestFailure(final TaErrorCode taErrorCode) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestError(taErrorCode);
                }
            });
        } else {
            this.onRequestError(taErrorCode);
        }
    }

    public void onServerRequestSuccess(int n, String string) {
    }

    public abstract void onServerRequestSuccess(int var1, byte[] var2);

    public void onRequestStart(int n) {
    }

    public void onServerRequestStart(final int n) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestStart(n);
                }
            });
        } else {
            this.onRequestStart(n);
        }
    }

    private class a
    extends Handler {
        a(Looper looper) {
            super(looper);
        }
    }
}

