/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.util;

import com.zero.ta.common.util.AdLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File ad;
    private final File ae;
    private final File af;
    private final int ag;
    private final long ah;
    private final int ai;
    private long aj = 0L;
    private Writer ak;
    private final LinkedHashMap<String, a> al = new LinkedHashMap(0, 0.75f, true);
    private int am;
    private long an = 0L;
    private final ExecutorService ao = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> ap = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void l() throws Exception {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.ak == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.i()) {
                    DiskLruCache.this.h();
                    DiskLruCache.this.am = 0;
                }
            }
            return null;
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.l();
        }
    };

    private static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        int n3 = TArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n, objectArray, 0, n5);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String readAsciiLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n == 10) break;
            stringBuilder.append((char)n);
        }
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\r') {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteContents(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            AdLogUtil.LOG.d((Object)("not a directory: " + file));
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                DiskLruCache.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    private DiskLruCache(File file, int n, int n2, long l) {
        this.ad = file;
        this.ag = n;
        this.ae = new File(file, "journal");
        this.af = new File(file, "journal.tmp");
        this.ai = n2;
        this.ah = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) throws IOException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        DiskLruCache diskLruCache = new DiskLruCache(file, n, n2, l);
        if (diskLruCache.ae.exists()) {
            try {
                diskLruCache.f();
                diskLruCache.g();
                diskLruCache.ak = new BufferedWriter(new FileWriter(diskLruCache.ae, true), 8192);
                return diskLruCache;
            }
            catch (IOException iOException) {
                diskLruCache.delete();
            }
        }
        file.mkdirs();
        diskLruCache = new DiskLruCache(file, n, n2, l);
        diskLruCache.h();
        return diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.ae), 8192);
        try {
            String string = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string2 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string3 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string4 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string5 = DiskLruCache.readAsciiLine(bufferedInputStream);
            if (!("libcore.io.DiskLruCache".equals(string) && "1".equals(string2) && Integer.toString(this.ag).equals(string3) && Integer.toString(this.ai).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            try {
                while (true) {
                    this.b(DiskLruCache.readAsciiLine(bufferedInputStream));
                }
            }
            catch (EOFException eOFException) {
                DiskLruCache.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            DiskLruCache.closeQuietly(bufferedInputStream);
            throw throwable;
        }
    }

    private void b(String string) throws IOException {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            throw new IOException("unexpected journal line: " + string);
        }
        String string2 = stringArray[1];
        if (stringArray[0].equals("REMOVE") && stringArray.length == 2) {
            this.al.remove(string2);
            return;
        }
        a a2 = this.al.get(string2);
        if (a2 == null) {
            a2 = new a(string2);
            this.al.put(string2, a2);
        }
        if (stringArray[0].equals("CLEAN") && stringArray.length == 2 + this.ai) {
            a2.aw = true;
            a2.ax = null;
            a2.a(DiskLruCache.copyOfRange(stringArray, 2, stringArray.length));
        } else if (stringArray[0].equals("DIRTY") && stringArray.length == 2) {
            a2.ax = new Editor(a2);
        } else if (!stringArray[0].equals("READ") || stringArray.length != 2) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private void g() throws IOException {
        DiskLruCache.a(this.af);
        Iterator<a> iterator = this.al.values().iterator();
        while (iterator.hasNext()) {
            int n;
            a a2 = iterator.next();
            if (a2.ax == null) {
                for (n = 0; n < this.ai; ++n) {
                    this.aj += a2.av[n];
                }
                continue;
            }
            a2.ax = null;
            for (n = 0; n < this.ai; ++n) {
                DiskLruCache.a(a2.a(n));
                DiskLruCache.a(a2.b(n));
            }
            iterator.remove();
        }
    }

    private synchronized void h() throws IOException {
        if (this.ak != null) {
            this.ak.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.af), 8192);
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.ag));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.ai));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (a a2 : this.al.values()) {
            if (a2.ax != null) {
                bufferedWriter.write("DIRTY " + a2.au + '\n');
                continue;
            }
            bufferedWriter.write("CLEAN " + a2.au + a2.m() + '\n');
        }
        ((Writer)bufferedWriter).close();
        this.af.renameTo(this.ae);
        this.ak = new BufferedWriter(new FileWriter(this.ae, true), 8192);
    }

    private static void a(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string) throws IOException {
        this.j();
        this.c(string);
        a a2 = this.al.get(string);
        if (a2 == null) {
            return null;
        }
        if (!a2.aw) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.ai];
        try {
            for (int i = 0; i < this.ai; ++i) {
                inputStreamArray[i] = new FileInputStream(a2.a(i));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        ++this.am;
        this.ak.append("READ " + string + '\n');
        if (this.i()) {
            this.ao.submit(this.ap);
        }
        return new Snapshot(string, a2.ay, inputStreamArray);
    }

    public Editor edit(String string) throws IOException {
        return this.a(string, -1L);
    }

    private synchronized Editor a(String string, long l) throws IOException {
        this.j();
        this.c(string);
        a a2 = this.al.get(string);
        if (l != -1L && (a2 == null || a2.ay != l)) {
            return null;
        }
        if (a2 == null) {
            a2 = new a(string);
            this.al.put(string, a2);
        } else if (a2.ax != null) {
            return null;
        }
        Editor editor = new Editor(a2);
        a2.ax = editor;
        this.ak.write("DIRTY " + string + '\n');
        this.ak.flush();
        return editor;
    }

    public File getDirectory() {
        return this.ad;
    }

    public long maxSize() {
        return this.ah;
    }

    public synchronized long size() {
        return this.aj;
    }

    private synchronized void a(Editor editor, boolean bl) throws IOException {
        int n;
        a a2 = editor.ar;
        if (a2.ax != editor) {
            throw new IllegalStateException();
        }
        if (bl && !a2.aw) {
            for (n = 0; n < this.ai; ++n) {
                if (a2.b(n).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n = 0; n < this.ai; ++n) {
            File file = a2.b(n);
            if (bl) {
                long l;
                if (!file.exists()) continue;
                File file2 = a2.a(n);
                file.renameTo(file2);
                long l2 = a2.av[n];
                ((a)a2).av[n] = l = file2.length();
                this.aj = this.aj - l2 + l;
                continue;
            }
            DiskLruCache.a(file);
        }
        ++this.am;
        a2.ax = null;
        if (a2.aw | bl) {
            a2.aw = true;
            this.ak.write("CLEAN " + a2.au + a2.m() + '\n');
            if (bl) {
                a2.ay = this.an++;
            }
        } else {
            this.al.remove(a2.au);
            this.ak.write("REMOVE " + a2.au + '\n');
        }
        if (this.aj > this.ah || this.i()) {
            this.ao.submit(this.ap);
        }
    }

    private boolean i() {
        int n = 2000;
        return this.am >= 2000 && this.am >= this.al.size();
    }

    public synchronized boolean remove(String string) throws IOException {
        this.j();
        this.c(string);
        a a2 = this.al.get(string);
        if (a2 == null || a2.ax != null) {
            return false;
        }
        for (int i = 0; i < this.ai; ++i) {
            File file = a2.a(i);
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.aj -= a2.av[i];
            ((a)a2).av[i] = 0L;
        }
        ++this.am;
        this.ak.append("REMOVE " + string + '\n');
        this.al.remove(string);
        if (this.i()) {
            this.ao.submit(this.ap);
        }
        return true;
    }

    public boolean isClosed() {
        return this.ak == null;
    }

    private void j() {
        if (this.ak == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.j();
        this.trimToSize();
        this.ak.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.ak == null) {
            return;
        }
        for (a a2 : new ArrayList<a>(this.al.values())) {
            if (a2.ax == null) continue;
            a2.ax.abort();
        }
        this.trimToSize();
        this.ak.close();
        this.ak = null;
    }

    private void trimToSize() throws IOException {
        while (this.aj > this.ah) {
            Map.Entry<String, a> entry = this.al.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() throws IOException {
        this.close();
        DiskLruCache.deleteContents(this.ad);
    }

    private void c(String string) {
        if (string.contains(" ") || string.contains("\n") || string.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + string + "\"");
        }
    }

    private static String a(InputStream inputStream) throws IOException {
        return DiskLruCache.readFully(new InputStreamReader(inputStream, UTF_8));
    }

    private final class a {
        private final String au;
        private final long[] av;
        private boolean aw;
        private Editor ax;
        private long ay;

        private a(String string) {
            this.au = string;
            this.av = new long[DiskLruCache.this.ai];
        }

        public String m() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.av) {
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void a(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.ai) {
                throw this.b(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.av[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.b(stringArray);
            }
        }

        private IOException b(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File a(int n) {
            return new File(DiskLruCache.this.ad, this.au + "." + n);
        }

        public File b(int n) {
            return new File(DiskLruCache.this.ad, this.au + "." + n + ".tmp");
        }
    }

    public final class Editor {
        private final com.zero.ta.common.util.DiskLruCache$a ar;
        private boolean as;

        private Editor(com.zero.ta.common.util.DiskLruCache$a a2) {
            this.ar = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.ar.ax != this) {
                    throw new IllegalStateException();
                }
                if (!this.ar.aw) {
                    return null;
                }
                return new FileInputStream(this.ar.a(n));
            }
        }

        public String getString(int n) throws IOException {
            InputStream inputStream = this.newInputStream(n);
            return inputStream != null ? DiskLruCache.a(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.ar.ax != this) {
                    throw new IllegalStateException();
                }
                return new a(new FileOutputStream(this.ar.b(n)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n, String string) throws IOException {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), UTF_8);
                outputStreamWriter.write(string);
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCache.closeQuietly(outputStreamWriter);
        }

        public void commit() throws IOException {
            if (this.as) {
                DiskLruCache.this.a(this, false);
                DiskLruCache.this.remove(this.ar.au);
            } else {
                DiskLruCache.this.a(this, true);
            }
        }

        public void abort() throws IOException {
            DiskLruCache.this.a(this, false);
        }

        private class a
        extends FilterOutputStream {
            private a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (IOException iOException) {
                    Editor.this.as = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    Editor.this.as = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.this.as = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.this.as = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String au;
        private final long ay;
        private final InputStream[] az;

        private Snapshot(String string, long l, InputStream[] inputStreamArray) {
            this.au = string;
            this.ay = l;
            this.az = inputStreamArray;
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.a(this.au, this.ay);
        }

        public InputStream getInputStream(int n) {
            return this.az[n];
        }

        public String getString(int n) throws IOException {
            return DiskLruCache.a(this.getInputStream(n));
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.az) {
                DiskLruCache.closeQuietly(inputStream);
            }
        }
    }
}

