/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.zero.ta.common.R;
import com.zero.ta.common.widget.CountDownTimer;

public class CountTimeView
extends View
implements View.OnClickListener {
    private Paint aN;
    private Paint aO;
    private long aP = 6L;
    private CountDownTimer aQ;
    private int aR;
    private String aS = "5s";
    private CountDownTimerListener aT;
    private Bitmap aU;
    private Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CountTimeView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setOnClickListener(this);
        this.aR = context.getResources().getDimensionPixelSize(R.dimen.skip_text_size);
        this.q();
    }

    private void q() {
        this.aN = new Paint();
        this.aN.setAntiAlias(true);
        this.aN.setDither(true);
        this.aN.setStyle(Paint.Style.FILL);
        this.aO = new Paint();
        this.aO.setAntiAlias(true);
        this.aO.setColor(-1);
        this.aO.setTextSize((float)this.aR);
        this.aO.setStrokeWidth(8.0f);
        this.aO.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int n) {
        this.aP = (long)(n * 1000) + 400L;
        this.r();
    }

    public void setCountDownTimerListener(CountDownTimerListener countDownTimerListener) {
        this.aT = countDownTimerListener;
    }

    private void r() {
        this.aQ = new CountDownTimer(this.aP, 1000L){

            @Override
            public void onTick(long l) {
                CountTimeView.this.aS = "SKIP " + l / 1000L;
                CountTimeView.this.invalidate();
            }

            @Override
            public void onFinish() {
                if (CountTimeView.this.aT != null) {
                    CountTimeView.this.aT.onFinish();
                }
            }
        };
    }

    public void start() {
        this.aQ.start();
        if (this.aT != null) {
            this.aT.onStart();
        }
    }

    public void cancel() {
        if (this.aQ != null) {
            this.aQ.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.aS)) {
            if (this.aU == null) {
                this.aU = this.getBg();
            }
            Rect rect = new Rect(0, 0, this.aU.getWidth(), this.aU.getHeight());
            canvas.drawBitmap(this.aU, rect, rect, this.aN);
            Paint.FontMetrics fontMetrics = this.aO.getFontMetrics();
            int n = (int)((float)(this.rect.bottom + this.rect.top) - fontMetrics.bottom - fontMetrics.top) / 2;
            canvas.drawText(this.aS, (float)this.rect.centerX(), (float)n, this.aO);
        }
    }

    private Bitmap getBg() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.skip_button);
        if (drawable2 instanceof BitmapDrawable) {
            this.aU = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            this.aU = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.aU);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.aU;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.rect.set(0, 0, this.getWidth(), this.getHeight());
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void onClick(View view) {
        if (this.aT != null) {
            this.aT.onClick();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.aQ.start();
        if (this.aT != null) {
            this.aT.onStart();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.aQ != null) {
            this.aQ.cancel();
        }
    }

    public static interface CountDownTimerListener {
        public void onStart();

        public void onFinish();

        public void onClick();
    }
}

