/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.bean;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.zero.ta.common.constant.ComConstant;
import com.zero.ta.common.util.AdLogUtil;

public class AdImage {
    public Drawable drawable;
    public byte[] gifBytes;
    public String filePath;

    public AdImage(Drawable drawable2, byte[] byArray, String string2) {
        this.drawable = drawable2;
        this.gifBytes = byArray;
        this.filePath = string2;
    }

    public int getImei() {
        return this.gifBytes != null ? 2 : 1;
    }

    public boolean isRecycled() {
        return (this.drawable == null || this.getBitmap() != null && this.getBitmap().isRecycled()) && this.gifBytes == null;
    }

    public boolean isGif() {
        return this.gifBytes != null;
    }

    public boolean isDrawable() {
        return this.drawable != null;
    }

    public boolean attachView(ImageView imageView) {
        if (imageView == null) {
            return false;
        }
        if (this.drawable != null) {
            imageView.setImageDrawable(this.drawable);
            return true;
        }
        if (this.gifBytes != null) {
            boolean bl = true;
            try {
                AdLogUtil.LOG.d((Object)"bind gif through glide");
                Glide.with((Context)imageView.getContext()).load(this.gifBytes).into(imageView);
            }
            catch (Throwable throwable) {
                bl = false;
                ComConstant.isGlideExisted = false;
                AdLogUtil.LOG.e((Object)Log.getStackTraceString((Throwable)throwable));
            }
            return bl;
        }
        return false;
    }

    private Bitmap getBitmap() {
        if (this.drawable == null) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)this.drawable;
            bitmap = bitmapDrawable.getBitmap();
        }
        catch (Throwable throwable) {
            AdLogUtil.LOG.e((Object)Log.getStackTraceString((Throwable)throwable));
        }
        return bitmap;
    }

    public int getByteSize() {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            return bitmap.getByteCount();
        }
        if (this.gifBytes != null) {
            return this.gifBytes.length;
        }
        return 0;
    }
}

