/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.gif;

import android.support.annotation.NonNull;
import android.util.Log;
import com.zero.ta.common.gif.ArrayPool;
import com.zero.ta.common.gif.ImageHeaderParser;
import com.zero.ta.common.gif.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class DefaultImageHeaderParser
implements ImageHeaderParser {
    static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = "Exif\u0000\u0000".getBytes(Charset.forName("UTF-8"));
    private static final int[] D = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    @Override
    @NonNull
    public ImageHeaderParser.ImageType getType(@NonNull InputStream inputStream) throws IOException {
        return this.a(new d(Preconditions.checkNotNull(inputStream)));
    }

    @Override
    @NonNull
    public ImageHeaderParser.ImageType getType(@NonNull ByteBuffer byteBuffer) throws IOException {
        return this.a(new a(Preconditions.checkNotNull(byteBuffer)));
    }

    @Override
    public int getOrientation(@NonNull InputStream inputStream, @NonNull ArrayPool arrayPool) throws IOException {
        return this.a(new d(Preconditions.checkNotNull(inputStream)), Preconditions.checkNotNull(arrayPool));
    }

    @Override
    public int getOrientation(@NonNull ByteBuffer byteBuffer, @NonNull ArrayPool arrayPool) throws IOException {
        return this.a(new a(Preconditions.checkNotNull(byteBuffer)), Preconditions.checkNotNull(arrayPool));
    }

    @NonNull
    private ImageHeaderParser.ImageType a(c c2) throws IOException {
        int n = c2.getUInt16();
        if (n == 65496) {
            return ImageHeaderParser.ImageType.JPEG;
        }
        int n2 = n << 16 & 0xFFFF0000 | c2.getUInt16() & 0xFFFF;
        if (n2 == -1991225785) {
            c2.skip(21L);
            int n3 = c2.getByte();
            return n3 >= 3 ? ImageHeaderParser.ImageType.PNG_A : ImageHeaderParser.ImageType.PNG;
        }
        if (n2 >> 8 == 4671814) {
            return ImageHeaderParser.ImageType.GIF;
        }
        if (n2 != 1380533830) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        c2.skip(4L);
        int n4 = c2.getUInt16() << 16 & 0xFFFF0000 | c2.getUInt16() & 0xFFFF;
        if (n4 != 1464156752) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        int n5 = c2.getUInt16() << 16 & 0xFFFF0000 | c2.getUInt16() & 0xFFFF;
        if ((n5 & 0xFFFFFF00) != 1448097792) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        if ((n5 & 0xFF) == 88) {
            c2.skip(4L);
            return (c2.getByte() & 0x10) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
        }
        if ((n5 & 0xFF) == 76) {
            c2.skip(4L);
            return (c2.getByte() & 8) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
        }
        return ImageHeaderParser.ImageType.WEBP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(c c2, ArrayPool arrayPool) throws IOException {
        int n = c2.getUInt16();
        if (!DefaultImageHeaderParser.a(n)) {
            if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                Log.d((String)"DfltImageHeaderParser", (String)("Parser doesn't handle magic number: " + n));
            }
            return -1;
        }
        int n2 = this.b(c2);
        if (n2 == -1) {
            if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                Log.d((String)"DfltImageHeaderParser", (String)"Failed to parse exif segment length, or exif segment not found");
            }
            return -1;
        }
        byte[] byArray = arrayPool.get(n2, byte[].class);
        try {
            int n3 = this.a(c2, byArray, n2);
            return n3;
        }
        finally {
            arrayPool.put(byArray);
        }
    }

    private int a(c c2, byte[] byArray, int n) throws IOException {
        int n2 = c2.read(byArray, n);
        if (n2 != n) {
            if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                Log.d((String)"DfltImageHeaderParser", (String)("Unable to read exif segment data, length: " + n + ", actually read: " + n2));
            }
            return -1;
        }
        boolean bl = this.a(byArray, n);
        if (bl) {
            return DefaultImageHeaderParser.a(new b(byArray, n));
        }
        if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
            Log.d((String)"DfltImageHeaderParser", (String)"Missing jpeg exif preamble");
        }
        return -1;
    }

    private boolean a(byte[] byArray, int n) {
        boolean bl;
        boolean bl2 = bl = byArray != null && n > JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length;
        if (bl) {
            for (int i = 0; i < JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length; ++i) {
                if (byArray[i] == JPEG_EXIF_SEGMENT_PREAMBLE_BYTES[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private int b(c c2) throws IOException {
        int n;
        block7: {
            short s;
            long l;
            do {
                short s2;
                if ((s2 = c2.getUInt8()) != 255) {
                    if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                        Log.d((String)"DfltImageHeaderParser", (String)("Unknown segmentId=" + s2));
                    }
                    return -1;
                }
                s = c2.getUInt8();
                if (s == 218) {
                    return -1;
                }
                if (s == 217) {
                    if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                        Log.d((String)"DfltImageHeaderParser", (String)"Found MARKER_EOI in exif segment");
                    }
                    return -1;
                }
                n = c2.getUInt16() - 2;
                if (s == 225) break block7;
            } while ((l = c2.skip(n)) == (long)n);
            if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                Log.d((String)"DfltImageHeaderParser", (String)("Unable to skip enough data, type: " + s + ", wanted to skip: " + n + ", but actually skipped: " + l));
            }
            return -1;
        }
        return n;
    }

    private static int a(b b2) {
        ByteOrder byteOrder;
        int n = "Exif\u0000\u0000".length();
        short s = b2.getInt16(n);
        switch (s) {
            case 19789: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            case 18761: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                    Log.d((String)"DfltImageHeaderParser", (String)("Unknown endianness = " + s));
                }
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
        }
        b2.order(byteOrder);
        int n2 = b2.getInt32(n + 4) + n;
        int n3 = b2.getInt16(n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = DefaultImageHeaderParser.a(n2, i);
            short s2 = b2.getInt16(n5);
            if (s2 != 274) continue;
            short s3 = b2.getInt16(n5 + 2);
            if (s3 < 1 || s3 > 12) {
                if (!Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) continue;
                Log.d((String)"DfltImageHeaderParser", (String)("Got invalid format code = " + s3));
                continue;
            }
            int n6 = b2.getInt32(n5 + 4);
            if (n6 < 0) {
                if (!Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) continue;
                Log.d((String)"DfltImageHeaderParser", (String)"Negative tiff component count");
                continue;
            }
            if (Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) {
                Log.d((String)"DfltImageHeaderParser", (String)("Got tagIndex=" + i + " tagType=" + s2 + " formatCode=" + s3 + " componentCount=" + n6));
            }
            if ((n4 = n6 + D[s3]) > 4) {
                if (!Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) continue;
                Log.d((String)"DfltImageHeaderParser", (String)("Got byte count > 4, not orientation, continuing, formatCode=" + s3));
                continue;
            }
            int n7 = n5 + 8;
            if (n7 < 0 || n7 > b2.length()) {
                if (!Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) continue;
                Log.d((String)"DfltImageHeaderParser", (String)("Illegal tagValueOffset=" + n7 + " tagType=" + s2));
                continue;
            }
            if (n4 < 0 || n7 + n4 > b2.length()) {
                if (!Log.isLoggable((String)"DfltImageHeaderParser", (int)3)) continue;
                Log.d((String)"DfltImageHeaderParser", (String)("Illegal number of bytes for TI tag data tagType=" + s2));
                continue;
            }
            return b2.getInt16(n7);
        }
        return -1;
    }

    private static int a(int n, int n2) {
        return n + 2 + 12 * n2;
    }

    private static boolean a(int n) {
        return (n & 0xFFD8) == 65496 || n == 19789 || n == 18761;
    }

    private static final class d
    implements c {
        private final InputStream G;

        d(InputStream inputStream) {
            this.G = inputStream;
        }

        @Override
        public int getUInt16() throws IOException {
            return this.G.read() << 8 & 0xFF00 | this.G.read() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.G.read() & 0xFF);
        }

        @Override
        public long skip(long l) throws IOException {
            if (l < 0L) {
                return 0L;
            }
            long l2 = l;
            while (l2 > 0L) {
                long l3 = this.G.skip(l2);
                if (l3 > 0L) {
                    l2 -= l3;
                    continue;
                }
                int n = this.G.read();
                if (n == -1) break;
                --l2;
            }
            return l - l2;
        }

        @Override
        public int read(byte[] byArray, int n) throws IOException {
            int n2;
            int n3;
            for (n2 = n; n2 > 0 && (n3 = this.G.read(byArray, n - n2, n2)) != -1; n2 -= n3) {
            }
            return n - n2;
        }

        @Override
        public int getByte() throws IOException {
            return this.G.read();
        }
    }

    private static final class a
    implements c {
        private final ByteBuffer E;

        a(ByteBuffer byteBuffer) {
            this.E = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int getUInt16() {
            return this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }

        @Override
        public short getUInt8() {
            return (short)(this.getByte() & 0xFF);
        }

        @Override
        public long skip(long l) {
            int n = (int)Math.min((long)this.E.remaining(), l);
            this.E.position(this.E.position() + n);
            return n;
        }

        @Override
        public int read(byte[] byArray, int n) {
            int n2 = Math.min(n, this.E.remaining());
            if (n2 == 0) {
                return -1;
            }
            this.E.get(byArray, 0, n2);
            return n2;
        }

        @Override
        public int getByte() {
            if (this.E.remaining() < 1) {
                return -1;
            }
            return this.E.get();
        }
    }

    private static interface c {
        public int getUInt16() throws IOException;

        public short getUInt8() throws IOException;

        public long skip(long var1) throws IOException;

        public int read(byte[] var1, int var2) throws IOException;

        public int getByte() throws IOException;
    }

    private static final class b {
        private final ByteBuffer F;

        b(byte[] byArray, int n) {
            this.F = (ByteBuffer)ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).limit(n);
        }

        void order(ByteOrder byteOrder) {
            this.F.order(byteOrder);
        }

        int length() {
            return this.F.remaining();
        }

        int getInt32(int n) {
            return this.b(n, 4) ? this.F.getInt(n) : -1;
        }

        short getInt16(int n) {
            return this.b(n, 2) ? this.F.getShort(n) : (short)-1;
        }

        private boolean b(int n, int n2) {
            return this.F.remaining() - n >= n2;
        }
    }
}

