/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.http.listener;

import android.os.Handler;
import android.os.Looper;
import com.zero.ta.common.constant.TaErrorCode;

public abstract class ResponseBaseListener {
    protected Handler handler = null;

    public ResponseBaseListener() {
        this(Looper.myLooper());
    }

    protected ResponseBaseListener(boolean bl) {
        this(bl ? null : Looper.myLooper());
    }

    private ResponseBaseListener(Looper looper) {
        this.handler = looper != null ? new a(looper) : null;
    }

    public void onServerRequestFailure(int n, String string2, Throwable throwable) {
        this.onServerRequestFailure(new TaErrorCode(n, "erro msg = " + string2));
    }

    public void onServerRequestFailure(int n, byte[] byArray, Throwable throwable) {
        this.onServerRequestFailure(new TaErrorCode(n, "erro msg = " + byArray));
    }

    public void onServerRequestFailure(final TaErrorCode taErrorCode) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestError(taErrorCode);
                }
            });
        } else {
            this.onRequestError(taErrorCode);
        }
    }

    public void onServerRequestStart(final int n) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestStart(n);
                }
            });
        } else {
            this.onRequestStart(n);
        }
    }

    protected abstract void onRequestError(TaErrorCode var1);

    public void onRequestStart(int n) {
    }

    private class a
    extends Handler {
        a(Looper looper) {
            super(looper);
        }
    }
}

