/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.util;

import android.support.annotation.Nullable;
import com.transsion.core.utils.AppUtil;
import com.zero.ta.common.util.AdLogUtil;
import com.zero.ta.common.util.DiskLruCache;
import com.zero.ta.common.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CacheUtil {
    private static CacheUtil af;
    private static DiskLruCache ag;

    private CacheUtil() {
        try {
            ag = DiskLruCache.open(this.getCacheDir(), AppUtil.getVersionCode(), 1, 0x6400000L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheUtil getInstance() {
        if (af != null) return af;
        Class<CacheUtil> clazz = CacheUtil.class;
        synchronized (CacheUtil.class) {
            if (af != null) return af;
            af = new CacheUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return af;
        }
    }

    @Nullable
    public synchronized String getString(String string) {
        if (ag == null || ag.isClosed()) {
            return null;
        }
        try {
            DiskLruCache.Snapshot snapshot = ag.get(string);
            if (snapshot != null) {
                String string2 = snapshot.getString(0);
                AdLogUtil.LOG.d((Object)("get content successful.key=" + string + ", value=" + string2));
                return string2;
            }
        }
        catch (Throwable throwable) {
            AdLogUtil.LOG.e((Object)("read cache error: " + throwable.toString()));
        }
        return null;
    }

    public synchronized void putString(String string, String string2) {
        block6: {
            if (ag == null || ag.isClosed()) {
                return;
            }
            DiskLruCache.Editor editor = null;
            try {
                editor = ag.edit(string);
                if (editor != null) {
                    editor.set(0, string2);
                    editor.commit();
                    ag.flush();
                    AdLogUtil.LOG.d((Object)("put content successful. key=" + string));
                }
            }
            catch (Throwable throwable) {
                if (editor == null) break block6;
                try {
                    editor.abort();
                }
                catch (Throwable throwable2) {
                    AdLogUtil.LOG.e((Object)("write cache error: " + throwable.toString()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSerializable(String string, Serializable serializable) {
        DiskLruCache.Editor editor = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            editor = ag.edit(string);
            if (editor == null) {
                return;
            }
            OutputStream outputStream = editor.newOutputStream(0);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            editor.commit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                editor.abort();
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAsSerializable(String string) {
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            DiskLruCache.Snapshot snapshot = ag.get(string);
            if (snapshot == null) {
                T t = null;
                return t;
            }
            InputStream inputStream = snapshot.getInputStream(0);
            if (inputStream == null) {
                T t = null;
                return t;
            }
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return (T)object;
    }

    public void diskRemove(String string) {
        if (ag == null || ag.isClosed()) {
            return;
        }
        try {
            ag.remove(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private File getCacheDir() {
        File file = new File(FileUtil.getAppDateCachePath(), "ZERO_AD_SDK_LRUCACHE");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

