/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.util;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.utils.EncoderUtil;
import com.transsion.core.utils.NetUtil;
import com.zero.ta.common.util.AdLogUtil;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class DeviceUtil {
    public static String getMCC() {
        String string = DeviceInfo.getIMSI();
        AdLogUtil.LOG.d((Object)("imsi is " + string));
        if (!TextUtils.isEmpty((CharSequence)string) && string.length() >= 4) {
            String string2 = string.substring(0, 3);
            AdLogUtil.LOG.d((Object)("mcc is " + string2));
            return string2;
        }
        return "";
    }

    public static String getMNC() {
        String string = DeviceInfo.getIMSI();
        AdLogUtil.LOG.d((Object)("imsi is " + string));
        if (!TextUtils.isEmpty((CharSequence)string) && string.length() >= 4) {
            String string2 = string.substring(3);
            AdLogUtil.LOG.d((Object)("mnc is " + string2));
            return string2;
        }
        return "";
    }

    public static String getCarrier() {
        return DeviceInfo.getIMSI();
    }

    public static String getUniqueID() {
        String string = DeviceUtil.c() + DeviceInfo.getBTMAC() + NetUtil.getWLANMAC() + DeviceInfo.getIMEI() + DeviceInfo.getAndroidID();
        return EncoderUtil.EncoderByAlgorithm((String)string, (String)"MD5");
    }

    private static String c() {
        return "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
    }

    public static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    public static String getLocaleString() {
        Context context = CoreUtil.getContext();
        if (context.getResources() != null && context.getResources().getConfiguration() != null) {
            Locale locale = context.getResources().getConfiguration().locale;
            String string = "";
            string = string + locale.getCountry() + "|";
            string = string + locale.getLanguage() + "|";
            string = string + locale.getDisplayCountry() + "|";
            string = string + locale.getDisplayLanguage() + "|";
            string = string + locale.getDisplayName() + "|";
            string = string + locale.getISO3Country() + "|";
            string = string + locale.getISO3Language();
            return string;
        }
        return "";
    }

    public static String getLocalMacAddress() {
        String string = "";
        if (Build.VERSION.SDK_INT >= 23) {
            string = DeviceUtil.d();
            AdLogUtil.LOG.d((Object)"get mac from M+");
        } else {
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                string = wifiInfo.getMacAddress();
            }
            AdLogUtil.LOG.d((Object)"normal get mac");
        }
        AdLogUtil.LOG.d((Object)("mac is " + string));
        return string;
    }

    private static String d() {
        try {
            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : arrayList) {
                if (!networkInterface.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null || byArray.length == 0) {
                    return "";
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02X:", by));
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                return stringBuilder.toString();
            }
        }
        catch (Throwable throwable) {
            AdLogUtil.LOG.d((Object)("get mac is error: " + throwable.getMessage()));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String a(String string, String string2) {
        String string3 = string2;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getDeclaredMethod("get", String.class);
            string3 = (String)method.invoke(null, string);
            return string3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            return string3;
        }
    }

    public static boolean isGoVersion() {
        try {
            return "1".equals(DeviceUtil.a("os.go.support", "")) || Build.DISPLAY.toUpperCase().contains("-GO-");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }
}

