/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.util;

import com.zero.ta.common.util.AdLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File ah;
    private final File ai;
    private final File aj;
    private final int ak;
    private final long al;
    private final int am;
    private long an = 0L;
    private Writer ao;
    private final LinkedHashMap<String, a> ap = new LinkedHashMap(0, 0.75f, true);
    private int aq;
    private long ar = 0L;
    private final ExecutorService as = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> at = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.ao == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.h()) {
                    DiskLruCache.this.g();
                    DiskLruCache.this.aq = 0;
                }
            }
            return null;
        }
    };

    private static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        int n3 = TArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n, objectArray, 0, n5);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String readAsciiLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n == 10) break;
            stringBuilder.append((char)n);
        }
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\r') {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteContents(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            AdLogUtil.LOG.d((Object)("not a directory: " + file));
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                DiskLruCache.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    private DiskLruCache(File file, int n, int n2, long l) {
        this.ah = file;
        this.ak = n;
        this.ai = new File(file, "journal");
        this.aj = new File(file, "journal.tmp");
        this.am = n2;
        this.al = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) throws IOException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        DiskLruCache diskLruCache = new DiskLruCache(file, n, n2, l);
        if (diskLruCache.ai.exists()) {
            try {
                diskLruCache.e();
                diskLruCache.f();
                diskLruCache.ao = new BufferedWriter(new FileWriter(diskLruCache.ai, true), 8192);
                return diskLruCache;
            }
            catch (IOException iOException) {
                diskLruCache.delete();
            }
        }
        file.mkdirs();
        diskLruCache = new DiskLruCache(file, n, n2, l);
        diskLruCache.g();
        return diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.ai), 8192);
        try {
            String string = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string2 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string3 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string4 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string5 = DiskLruCache.readAsciiLine(bufferedInputStream);
            if (!("libcore.io.DiskLruCache".equals(string) && "1".equals(string2) && Integer.toString(this.ak).equals(string3) && Integer.toString(this.am).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            try {
                while (true) {
                    this.b(DiskLruCache.readAsciiLine(bufferedInputStream));
                }
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            DiskLruCache.closeQuietly(bufferedInputStream);
            throw throwable;
        }
    }

    private void b(String string) throws IOException {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            throw new IOException("unexpected journal line: " + string);
        }
        String string2 = stringArray[1];
        if (stringArray[0].equals("REMOVE") && stringArray.length == 2) {
            this.ap.remove(string2);
            return;
        }
        a a2 = this.ap.get(string2);
        if (a2 == null) {
            a2 = new a(string2);
            this.ap.put(string2, a2);
        }
        if (stringArray[0].equals("CLEAN") && stringArray.length == 2 + this.am) {
            a2.aA = true;
            a2.aB = null;
            a2.a(DiskLruCache.copyOfRange(stringArray, 2, stringArray.length));
        } else if (stringArray[0].equals("DIRTY") && stringArray.length == 2) {
            a2.aB = new Editor(a2);
        } else if (!stringArray[0].equals("READ") || stringArray.length != 2) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private void f() throws IOException {
        DiskLruCache.a(this.aj);
        Iterator<a> iterator = this.ap.values().iterator();
        while (iterator.hasNext()) {
            int n;
            a a2 = iterator.next();
            if (a2.aB == null) {
                for (n = 0; n < this.am; ++n) {
                    this.an += a2.az[n];
                }
                continue;
            }
            a2.aB = null;
            for (n = 0; n < this.am; ++n) {
                DiskLruCache.a(a2.getCleanFile(n));
                DiskLruCache.a(a2.getDirtyFile(n));
            }
            iterator.remove();
        }
    }

    private synchronized void g() throws IOException {
        if (this.ao != null) {
            this.ao.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.aj), 8192);
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.ak));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.am));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (a a2 : this.ap.values()) {
            if (a2.aB != null) {
                bufferedWriter.write("DIRTY " + a2.ay + '\n');
                continue;
            }
            bufferedWriter.write("CLEAN " + a2.ay + a2.getLengths() + '\n');
        }
        ((Writer)bufferedWriter).close();
        this.aj.renameTo(this.ai);
        this.ao = new BufferedWriter(new FileWriter(this.ai, true), 8192);
    }

    private static void a(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string) throws IOException {
        this.i();
        this.c(string);
        a a2 = this.ap.get(string);
        if (a2 == null) {
            return null;
        }
        if (!a2.aA) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.am];
        try {
            for (int i = 0; i < this.am; ++i) {
                inputStreamArray[i] = new FileInputStream(a2.getCleanFile(i));
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        ++this.aq;
        this.ao.append("READ " + string + '\n');
        if (this.h()) {
            this.as.submit(this.at);
        }
        return new Snapshot(string, a2.aC, inputStreamArray);
    }

    public Editor edit(String string) throws IOException {
        return this.a(string, -1L);
    }

    private synchronized Editor a(String string, long l) throws IOException {
        this.i();
        this.c(string);
        a a2 = this.ap.get(string);
        if (l != -1L && (a2 == null || a2.aC != l)) {
            return null;
        }
        if (a2 == null) {
            a2 = new a(string);
            this.ap.put(string, a2);
        } else if (a2.aB != null) {
            return null;
        }
        Editor editor = new Editor(a2);
        a2.aB = editor;
        this.ao.write("DIRTY " + string + '\n');
        this.ao.flush();
        return editor;
    }

    public File getDirectory() {
        return this.ah;
    }

    public long maxSize() {
        return this.al;
    }

    public synchronized long size() {
        return this.an;
    }

    private synchronized void a(Editor editor, boolean bl) throws IOException {
        int n;
        a a2 = editor.av;
        if (a2.aB != editor) {
            throw new IllegalStateException();
        }
        if (bl && !a2.aA) {
            for (n = 0; n < this.am; ++n) {
                if (a2.getDirtyFile(n).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n = 0; n < this.am; ++n) {
            File file = a2.getDirtyFile(n);
            if (bl) {
                long l;
                if (!file.exists()) continue;
                File file2 = a2.getCleanFile(n);
                file.renameTo(file2);
                long l2 = a2.az[n];
                ((a)a2).az[n] = l = file2.length();
                this.an = this.an - l2 + l;
                continue;
            }
            DiskLruCache.a(file);
        }
        ++this.aq;
        a2.aB = null;
        if (a2.aA | bl) {
            a2.aA = true;
            this.ao.write("CLEAN " + a2.ay + a2.getLengths() + '\n');
            if (bl) {
                a2.aC = this.ar++;
            }
        } else {
            this.ap.remove(a2.ay);
            this.ao.write("REMOVE " + a2.ay + '\n');
        }
        if (this.an > this.al || this.h()) {
            this.as.submit(this.at);
        }
    }

    private boolean h() {
        int n = 2000;
        return this.aq >= 2000 && this.aq >= this.ap.size();
    }

    public synchronized boolean remove(String string) throws IOException {
        this.i();
        this.c(string);
        a a2 = this.ap.get(string);
        if (a2 == null || a2.aB != null) {
            return false;
        }
        for (int i = 0; i < this.am; ++i) {
            File file = a2.getCleanFile(i);
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.an -= a2.az[i];
            ((a)a2).az[i] = 0L;
        }
        ++this.aq;
        this.ao.append("REMOVE " + string + '\n');
        this.ap.remove(string);
        if (this.h()) {
            this.as.submit(this.at);
        }
        return true;
    }

    public boolean isClosed() {
        return this.ao == null;
    }

    private void i() {
        if (this.ao == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.i();
        this.trimToSize();
        this.ao.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.ao == null) {
            return;
        }
        for (a a2 : new ArrayList<a>(this.ap.values())) {
            if (a2.aB == null) continue;
            a2.aB.abort();
        }
        this.trimToSize();
        this.ao.close();
        this.ao = null;
    }

    private void trimToSize() throws IOException {
        while (this.an > this.al) {
            Map.Entry<String, a> entry = this.ap.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() throws IOException {
        this.close();
        DiskLruCache.deleteContents(this.ah);
    }

    private void c(String string) {
        if (string.contains(" ") || string.contains("\n") || string.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + string + "\"");
        }
    }

    private static String a(InputStream inputStream) throws IOException {
        return DiskLruCache.readFully(new InputStreamReader(inputStream, UTF_8));
    }

    private final class a {
        private final String ay;
        private final long[] az;
        private boolean aA;
        private Editor aB;
        private long aC;

        private a(String string) {
            this.ay = string;
            this.az = new long[DiskLruCache.this.am];
        }

        public String getLengths() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.az) {
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void a(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.am) {
                throw this.b(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.az[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.b(stringArray);
            }
        }

        private IOException b(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File getCleanFile(int n) {
            return new File(DiskLruCache.this.ah, this.ay + "." + n);
        }

        public File getDirtyFile(int n) {
            return new File(DiskLruCache.this.ah, this.ay + "." + n + ".tmp");
        }
    }

    public final class Editor {
        private final com.zero.ta.common.util.DiskLruCache$a av;
        private boolean aw;

        private Editor(com.zero.ta.common.util.DiskLruCache$a a2) {
            this.av = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.av.aB != this) {
                    throw new IllegalStateException();
                }
                if (!this.av.aA) {
                    return null;
                }
                return new FileInputStream(this.av.getCleanFile(n));
            }
        }

        public String getString(int n) throws IOException {
            InputStream inputStream = this.newInputStream(n);
            return inputStream != null ? DiskLruCache.a(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.av.aB != this) {
                    throw new IllegalStateException();
                }
                return new a(new FileOutputStream(this.av.getDirtyFile(n)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n, String string) throws IOException {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), UTF_8);
                outputStreamWriter.write(string);
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCache.closeQuietly(outputStreamWriter);
        }

        public void commit() throws IOException {
            if (this.aw) {
                DiskLruCache.this.a(this, false);
                DiskLruCache.this.remove(this.av.ay);
            } else {
                DiskLruCache.this.a(this, true);
            }
        }

        public void abort() throws IOException {
            DiskLruCache.this.a(this, false);
        }

        private class a
        extends FilterOutputStream {
            private a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (Throwable throwable) {
                    Editor.this.aw = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (Throwable throwable) {
                    Editor.this.aw = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (Throwable throwable) {
                    Editor.this.aw = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    Editor.this.aw = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String ay;
        private final long aC;
        private final InputStream[] aD;

        private Snapshot(String string, long l, InputStream[] inputStreamArray) {
            this.ay = string;
            this.aC = l;
            this.aD = inputStreamArray;
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.a(this.ay, this.aC);
        }

        public InputStream getInputStream(int n) {
            return this.aD[n];
        }

        public String getString(int n) throws IOException {
            return DiskLruCache.a(this.getInputStream(n));
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.aD) {
                DiskLruCache.closeQuietly(inputStream);
            }
        }
    }
}

