/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.transsion.athena.data.TrackData;
import com.transsion.core.CoreUtil;
import com.zero.ta.common.athena.AthenaTracker;
import com.zero.ta.common.bean.AdImage;
import com.zero.ta.common.bean.TaNativeInfo;
import com.zero.ta.common.constant.TaErrorCode;
import com.zero.ta.common.http.DownLoadRequest;
import com.zero.ta.common.http.listener.DrawableResponseListener;
import com.zero.ta.common.util.AdLogUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageDownloadHelper {
    public static void downloadImage(final AthenaParam athenaParam, final @NonNull String string, @NonNull int n, final ImageListener imageListener) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(n).setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, AdImage adImage) {
                AdLogUtil.LOG.d((Object)("image cache success:" + string));
                imageListener.onImagesCached();
                ImageDownloadHelper.a(athenaParam, string, 1, 0);
            }

            @Override
            protected void onRequestError(TaErrorCode taErrorCode) {
                AdLogUtil.LOG.e((Object)("image load fail,error code:" + taErrorCode.getErrorCode() + ",error message:" + taErrorCode.getErrorMessage()));
                imageListener.onImagesFailedToCache(taErrorCode);
                ImageDownloadHelper.a(athenaParam, string, 0, taErrorCode.getErrorCode());
            }
        }).setUrl(string);
        downLoadRequest.netRequestPreExecute();
    }

    public static void loadImageView(final AthenaParam athenaParam, final @NonNull String string, final @NonNull ImageView imageView) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, AdImage adImage) {
                AdLogUtil.LOG.d((Object)("image cache success " + string));
                if (adImage == null) {
                    return;
                }
                adImage.attachView(imageView);
                if (athenaParam != null) {
                    ImageDownloadHelper.a(athenaParam, string, 1, 0);
                }
            }

            @Override
            protected void onRequestError(TaErrorCode taErrorCode) {
                AdLogUtil.LOG.e((Object)("image load fail,code:" + taErrorCode.getErrorCode() + ",message:" + taErrorCode.getErrorMessage()));
                if (athenaParam != null) {
                    ImageDownloadHelper.a(athenaParam, string, 0, taErrorCode.getErrorCode());
                }
            }
        }).setUrl(string);
        downLoadRequest.netRequestPreExecute();
    }

    public static void preCacheImages(final AthenaParam athenaParam, @NonNull List<String> list, final @NonNull ImageListener imageListener) {
        final AtomicInteger atomicInteger = new AtomicInteger(list.size());
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        for (final String string : list) {
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            AdLogUtil.LOG.d((Object)("request url:" + string));
            DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(3).setListener(new DrawableResponseListener(){

                @Override
                public void onRequestSuccess(int n, AdImage adImage) {
                    AdLogUtil.LOG.d((Object)"image cache success");
                    int n2 = atomicInteger.decrementAndGet();
                    if (n2 == 0 && !atomicBoolean.get()) {
                        imageListener.onImagesCached();
                    }
                    ImageDownloadHelper.a(athenaParam, string, 1, 0);
                }

                @Override
                protected void onRequestError(TaErrorCode taErrorCode) {
                    AdLogUtil.LOG.e((Object)("image cache fail,code:" + taErrorCode.getErrorCode() + ",message:" + taErrorCode.getErrorMessage()));
                    boolean bl = atomicBoolean.getAndSet(true);
                    atomicInteger.decrementAndGet();
                    if (!bl) {
                        imageListener.onImagesFailedToCache(taErrorCode);
                    }
                    ImageDownloadHelper.a(athenaParam, string, 0, taErrorCode.getErrorCode());
                }
            });
            downLoadRequest.setUrl(string).netRequestPreExecute();
        }
    }

    public static void preCacheNativeImageList(AthenaParam athenaParam, @NonNull List<TaNativeInfo.Image> list, final @NonNull ImageListener imageListener) {
        final AtomicInteger atomicInteger = new AtomicInteger(list.size());
        for (TaNativeInfo.Image image : list) {
            ImageDownloadHelper.a(athenaParam, image, new ImageListener(){

                @Override
                public void onImagesCached() {
                    int n = atomicInteger.decrementAndGet();
                    if (n == 0) {
                        imageListener.onImagesCached();
                    }
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode taErrorCode) {
                    int n = atomicInteger.decrementAndGet();
                    if (n == 0) {
                        imageListener.onImagesCached();
                    }
                }
            });
        }
    }

    private static void a(final AthenaParam athenaParam, final @NonNull TaNativeInfo.Image image, final ImageListener imageListener) {
        if (image == null || image.getImgUrl() == null) {
            AdLogUtil.LOG.d((Object)"image url is null");
            return;
        }
        final String string = image.getImgUrl();
        AdLogUtil.LOG.d((Object)("\u5f00\u59cb\u7f13\u5b58\u56fe\u7247\uff0crequest url:" + string));
        DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(image.preCache).setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, AdImage adImage) {
                AdLogUtil.LOG.d((Object)"\u56fe\u7247\u7f13\u5b58\u6210\u529f\uff0cimage cache success");
                if (image.preCache == 2 && adImage != null && image.mime != 3) {
                    image.mime = adImage.getImei();
                }
                image.setCached(true);
                if (image.preCache == 1) {
                    if (adImage == null) {
                        return;
                    }
                    if (adImage.getImei() == 1) {
                        image.setDrawable(adImage.drawable);
                    } else if (adImage.getImei() == 2) {
                        try {
                            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])adImage.gifBytes, (int)0, (int)(adImage.gifBytes == null ? 0 : adImage.gifBytes.length));
                            BitmapDrawable bitmapDrawable = new BitmapDrawable(CoreUtil.getContext().getResources(), bitmap);
                            image.setDrawable((Drawable)bitmapDrawable);
                        }
                        catch (Throwable throwable) {
                            AdLogUtil.LOG.e((Object)Log.getStackTraceString((Throwable)throwable));
                        }
                    }
                }
                if (imageListener != null) {
                    imageListener.onImagesCached();
                }
                ImageDownloadHelper.a(athenaParam, string, 1, 0);
            }

            @Override
            protected void onRequestError(TaErrorCode taErrorCode) {
                AdLogUtil.LOG.e((Object)("\u56fe\u7247\u7f13\u5b58\u5931\u8d25\uff0curl:" + image.getImgUrl() + ", code:" + taErrorCode.getErrorCode() + ",message:" + taErrorCode.getErrorMessage()));
                if (imageListener != null) {
                    imageListener.onImagesFailedToCache(new TaErrorCode(taErrorCode.getErrorCode(), "cache image fail, url:" + image.getImgUrl() + ", " + taErrorCode.getErrorMessage()));
                }
                ImageDownloadHelper.a(athenaParam, string, 0, taErrorCode.getErrorCode());
            }
        }).setUrl(string);
        downLoadRequest.netRequestPreExecute();
    }

    private static void a(AthenaParam athenaParam, String string, int n, int n2) {
        if (athenaParam == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        TrackData trackData = AthenaTracker.getAthenaBaseKey(athenaParam.pid, athenaParam.rid, athenaParam.adType, athenaParam.sdkVersion, "img_down");
        trackData.add("url", string).add("reason", n2).add("result", n);
        AthenaTracker.track(athenaParam.apiType, "img_down", trackData);
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(TaErrorCode var1);
    }

    public static class AthenaParam {
        public int apiType;
        public String pid;
        public String rid;
        public int adType;
        public String sdkVersion;

        public AthenaParam(int n, String string, String string2, int n2, String string3) {
            this.apiType = n;
            this.pid = string;
            this.rid = string2;
            this.adType = n2;
            this.sdkVersion = string3;
        }
    }
}

