/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.transsion.api.gateway.GateWaySdk;
import com.transsion.api.gateway.config.WorkMode;
import com.transsion.api.gateway.utils.ContextUtils;
import com.transsion.api.gateway.utils.NetworkUtils;
import com.transsion.mi.infra.tango.config.TangoConfigManager;
import com.transsion.mi.infra.tango.log.TangoLogManager;
import com.transsion.mi.infra.tango.log.TangoLogReceiver;
import com.transsion.mi.infra.tango.utils.L;
import com.transsion.mi.infra.tango.utils.TangoActivityLifeCycleCallback;
import com.transsion.mi.infra.tango.utils.UiUtils;

public class TangoSdk {
    static TangoActivityLifeCycleCallback sLifecycleCallback;
    private static String mAppId;
    private static boolean isInited;
    private static boolean isRegisterted;

    public static void init(Context context, String appId, WorkMode mode) {
        if (context == null) {
            return;
        }
        ContextUtils.init((Context)context.getApplicationContext());
        GateWaySdk.init((Context)context, (String)"4U01pxRu278GqCZKY9", (WorkMode)mode);
        mAppId = appId;
        if (!isInited) {
            TangoSdk.startActivityLifecycle();
            TangoConfigManager.getInstance().syncConfig(false);
            TangoSdk.registerReceiver(context);
        }
        TangoLogManager.cleanUp();
        TangoLogManager.checkAutoUpload();
        isInited = true;
    }

    public static String getAppId() {
        return mAppId;
    }

    public static String getSessionId() {
        return UiUtils.getSessionId();
    }

    public static String getHost() {
        if (GateWaySdk.getWorkMode() == WorkMode.MODE_ONLINE) {
            return "datagateway.tmctool.com";
        }
        return "test-gateway.shalltry.com:8082";
    }

    private static void startActivityLifecycle() {
        if (sLifecycleCallback == null) {
            sLifecycleCallback = new TangoActivityLifeCycleCallback();
            ((Application)ContextUtils.getContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sLifecycleCallback);
        }
    }

    public static void uploadLog(boolean onlyWifi, UploadListener listener) {
        if (listener == null) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable()) {
            listener.onFail("no network");
            return;
        }
        if (onlyWifi && NetworkUtils.getNetworkType((Context)ContextUtils.getContext()) != NetworkUtils.NetworkType.NETWORK_WIFI) {
            listener.onFail("mobile network upload is not supported");
            return;
        }
        TangoLogManager.uploadAllLog(listener);
    }

    private static void registerReceiver(Context context) {
        if (context == null) {
            return;
        }
        if (isRegisterted) {
            return;
        }
        isRegisterted = true;
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            context.registerReceiver((BroadcastReceiver)new TangoLogReceiver(), filter);
        }
        catch (Exception e) {
            L.e("registerReceiver fail, e:" + e.getMessage());
        }
    }

    public static interface UploadListener {
        public void onSuccess();

        public void onFail(String var1);
    }
}

