/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.config;

import com.transsion.mi.infra.tango.bean.TangoRemoteConfig;

public class TangoConfig {
    final boolean functionOn;
    final boolean logConsoleOn;
    final long refreshInterval;
    final boolean onlyWifi;
    final boolean autoUpload;
    final long autoUploadInterval;
    final boolean uploadDebugLog;
    final int logMaxLength;
    final long logFileMaxSize;
    final long logCacheMaxSize;
    final int logCacheMaxDuration;
    final long uploadMaxSize;
    final int configVersion;

    public TangoConfig() {
        this(new Builder());
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    TangoConfig(Builder builder) {
        this.functionOn = builder.functionOn;
        this.logConsoleOn = builder.logConsoleOn;
        this.refreshInterval = builder.refreshInterval;
        this.onlyWifi = builder.onlyWifi;
        this.autoUpload = builder.autoUpload;
        this.autoUploadInterval = builder.autoUploadInterval;
        this.uploadDebugLog = builder.uploadDebugLog;
        this.logMaxLength = builder.logMaxLength;
        this.logFileMaxSize = builder.logFileMaxSize;
        this.logCacheMaxSize = builder.logCacheMaxSize;
        this.logCacheMaxDuration = builder.logCacheMaxDuration;
        this.uploadMaxSize = builder.uploadMaxSize;
        this.configVersion = builder.configVersion;
    }

    public boolean isFunctionOn() {
        return this.functionOn;
    }

    public boolean isLogConsoleOn() {
        return this.logConsoleOn;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public boolean isOnlyWifi() {
        return this.onlyWifi;
    }

    public boolean isAutoUpload() {
        return this.autoUpload;
    }

    public long getAutoUploadInterval() {
        return this.autoUploadInterval;
    }

    public boolean isUploadDebugLog() {
        return this.uploadDebugLog;
    }

    public int getLogMaxLength() {
        if (this.logMaxLength <= 128) {
            return 128;
        }
        if (this.logMaxLength >= 2048) {
            return 2048;
        }
        return this.logMaxLength;
    }

    public long getLogFileMaxSize() {
        if (this.logFileMaxSize <= 512L) {
            return 512L;
        }
        if (this.logFileMaxSize >= 2560L) {
            return 5120L;
        }
        return this.logFileMaxSize;
    }

    public long getLogCacheMaxSize() {
        return this.logCacheMaxSize;
    }

    public int getLogCacheMaxDuration() {
        if (this.logCacheMaxDuration <= 1) {
            return 1;
        }
        if (this.logCacheMaxDuration >= 7) {
            return 7;
        }
        return this.logCacheMaxDuration;
    }

    public long getUploadMaxSize() {
        if (this.uploadMaxSize <= 512L) {
            return 512L;
        }
        if (this.uploadMaxSize >= 4096L) {
            return 4096L;
        }
        return this.uploadMaxSize;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public String toString() {
        return "TangoConfig{functionOn=" + this.functionOn + ", logConsoleOn=" + this.logConsoleOn + ", refreshInterval=" + this.refreshInterval + ", onlyWifi=" + this.onlyWifi + ", autoUpload=" + this.autoUpload + ", autoUploadInterval=" + this.autoUploadInterval + ", uploadDebugLog=" + this.uploadDebugLog + ", logMaxLength=" + this.logMaxLength + ", logFileMaxSize=" + this.logFileMaxSize + ", logCacheMaxSize=" + this.logCacheMaxSize + ", logCacheMaxDuration=" + this.logCacheMaxDuration + ", uploadMaxSize=" + this.uploadMaxSize + ", configVersion=" + this.configVersion + '}';
    }

    public static final class Builder {
        boolean functionOn;
        boolean logConsoleOn;
        long refreshInterval;
        boolean onlyWifi;
        boolean autoUpload;
        long autoUploadInterval;
        boolean uploadDebugLog;
        int logMaxLength;
        long logFileMaxSize;
        long logCacheMaxSize;
        int logCacheMaxDuration;
        long uploadMaxSize;
        int configVersion;

        public void setConfigVersion(int configVersion) {
            this.configVersion = configVersion;
        }

        public void setFunctionOn(boolean functionOn) {
            this.functionOn = functionOn;
        }

        public void setLogConsoleOn(boolean logConsoleOn) {
            this.logConsoleOn = logConsoleOn;
        }

        public void setRefreshInterval(long refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public void setOnlyWifi(boolean onlyWifi) {
            this.onlyWifi = onlyWifi;
        }

        public void setAutoUpload(boolean autoUpload) {
            this.autoUpload = autoUpload;
        }

        public void setAutoUploadInterval(long autoUploadInterval) {
            this.autoUploadInterval = autoUploadInterval;
        }

        public void setUploadDebugLog(boolean uploadDebugLog) {
            this.uploadDebugLog = uploadDebugLog;
        }

        public void setLogMaxLength(int logMaxLength) {
            this.logMaxLength = logMaxLength;
        }

        public void setLogFileMaxSize(long logFileMaxSize) {
            this.logFileMaxSize = logFileMaxSize;
        }

        public void setLogCacheMaxSize(long logCacheMaxSize) {
            this.logCacheMaxSize = logCacheMaxSize;
        }

        public void setLogCacheMaxDuration(int logCacheMaxDuration) {
            this.logCacheMaxDuration = logCacheMaxDuration;
        }

        public void setUploadMaxSize(long uploadMaxSize) {
            this.uploadMaxSize = uploadMaxSize;
        }

        public Builder() {
            this.functionOn = true;
            this.logConsoleOn = true;
            this.refreshInterval = 2073600000L;
            this.onlyWifi = true;
            this.autoUpload = true;
            this.autoUploadInterval = 14400000L;
            this.uploadDebugLog = false;
            this.logMaxLength = 1024;
            this.logFileMaxSize = 1024L;
            this.logCacheMaxSize = 10240L;
            this.logCacheMaxDuration = 7;
            this.uploadMaxSize = 2048L;
            this.configVersion = 0;
        }

        Builder(TangoConfig config) {
            if (config == null) {
                return;
            }
            this.functionOn = config.functionOn;
            this.logConsoleOn = config.logConsoleOn;
            this.refreshInterval = config.refreshInterval;
            this.onlyWifi = config.onlyWifi;
            this.autoUpload = config.autoUpload;
            this.autoUploadInterval = config.autoUploadInterval;
            this.uploadDebugLog = config.uploadDebugLog;
            this.logMaxLength = config.logMaxLength;
            this.logCacheMaxSize = config.logCacheMaxSize;
            this.logCacheMaxDuration = config.logCacheMaxDuration;
            this.uploadMaxSize = config.uploadMaxSize;
            this.configVersion = config.configVersion;
        }

        public Builder setRemoteConfig(TangoRemoteConfig config) {
            if (config == null) {
                return this;
            }
            this.functionOn = config.functionOn;
            this.refreshInterval = config.refreshInterval;
            this.onlyWifi = config.onlyWifi;
            this.autoUpload = config.autoUpload;
            this.autoUploadInterval = config.autoUploadInterval;
            this.uploadDebugLog = config.uploadDebugLog;
            this.logMaxLength = config.logMaxLength;
            this.logFileMaxSize = config.logFileMaxSize;
            this.logCacheMaxSize = config.logCacheMaxSize;
            this.logCacheMaxDuration = config.logCacheMaxDuration;
            this.uploadMaxSize = config.uploadMaxSize;
            this.configVersion = config.configVersion;
            return this;
        }

        public TangoConfig build() {
            return new TangoConfig(this);
        }
    }
}

