/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.config;

import android.content.Context;
import android.text.TextUtils;
import com.transsion.api.gateway.GateWaySdk;
import com.transsion.api.gateway.GatewaySignManager;
import com.transsion.api.gateway.config.WorkMode;
import com.transsion.api.gateway.utils.ContextUtils;
import com.transsion.api.gateway.utils.DeviceUtils;
import com.transsion.api.gateway.utils.SafeStringUtils;
import com.transsion.api.gateway.utils.ThreadManager;
import com.transsion.api.gateway.utils.UrlconncetionUtils;
import com.transsion.json.Tson;
import com.transsion.mi.infra.tango.TangoSdk;
import com.transsion.mi.infra.tango.bean.TangoRemoteConfig;
import com.transsion.mi.infra.tango.config.TangoConfig;
import com.transsion.mi.infra.tango.utils.Crypto;
import com.transsion.mi.infra.tango.utils.L;
import com.transsion.mi.infra.tango.utils.TangoSpUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class TangoConfigManager {
    private static volatile TangoConfigManager INSTANCE;
    private AtomicBoolean isUploading = new AtomicBoolean(false);
    private long lastUploadTime = 0L;
    private TangoConfig mConfig;

    private TangoConfigManager() {
        this.loadConfig();
    }

    public static synchronized TangoConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TangoConfigManager();
        }
        return INSTANCE;
    }

    public void setConfig(TangoConfig config) {
        if (config != null) {
            this.mConfig = config;
        }
    }

    private void loadConfig() {
        if (this.mConfig != null) {
            return;
        }
        this.lastUploadTime = TangoSpUtils.getInstance().getLong("tango_sync_time");
        String configString = TangoSpUtils.getInstance().getString("tango_config");
        if (!TextUtils.isEmpty((CharSequence)configString)) {
            L.d(" load from cache");
            try {
                TangoRemoteConfig remoteConfig = (TangoRemoteConfig)Tson.fromJson((String)configString, TangoRemoteConfig.class);
                L.d(" load from cache success" + remoteConfig.toString());
                TangoConfig config = new TangoConfig().newBuilder().setRemoteConfig(remoteConfig).build();
                if (config.autoUploadInterval > 0L) {
                    this.mConfig = config;
                }
                if (this.mConfig != null) {
                    L.d(" load from cache success" + this.mConfig.toString());
                }
                return;
            }
            catch (Exception e) {
                L.e("loadConfig exception" + e.toString());
            }
        }
        L.d(" set config");
        this.mConfig = new TangoConfig().newBuilder().build();
    }

    public TangoConfig getConfig() {
        return this.mConfig;
    }

    public void syncConfig(boolean force) {
        L.d(" sync config");
        if (this.isUploading.get()) {
            return;
        }
        if (!force && System.currentTimeMillis() - this.lastUploadTime <= this.mConfig.getRefreshInterval()) {
            L.d(" sync config time is not enough");
            return;
        }
        ThreadManager.executeInBackground((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String configUrl = "";
                configUrl = GateWaySdk.getWorkMode() == WorkMode.MODE_ONLINE ? "https://" + TangoSdk.getHost() + "/tango/data/config?appId=" + TangoSdk.getAppId() + "&configVersion=" + TangoConfigManager.this.mConfig.getConfigVersion() : "http://" + TangoSdk.getHost() + "/tango/data/config?appId=" + TangoSdk.getAppId() + "&configVersion=" + TangoConfigManager.this.mConfig.getConfigVersion();
                L.d("get remoteConfig url" + configUrl);
                TangoConfigManager.this.isUploading.set(true);
                String signString = GatewaySignManager.doSign((String)"GET", (String)"", (String)"", (String)configUrl, (String)"");
                HttpURLConnection conn = null;
                L.d("sign" + signString);
                try {
                    conn = (HttpURLConnection)new URL(configUrl).openConnection();
                    conn.setRequestProperty("x-scenario-type", "android");
                    conn.setRequestProperty("x-tr-signature", signString);
                    conn.setRequestProperty("x-tr-meta-gaid", DeviceUtils.getGAId());
                    conn.setDoInput(true);
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(10000);
                    int code = conn.getResponseCode();
                    if (code >= 400) {
                        String result = new String(UrlconncetionUtils.toBytes((InputStream)conn.getErrorStream()));
                        L.d("result from server: " + code + result);
                        long now = System.currentTimeMillis();
                        long serverTime = Crypto.getTimeOffset(result);
                        if (serverTime > 0L) {
                            SafeStringUtils.getInstance((Context)ContextUtils.getContext()).saveLong("time_offset", serverTime - System.currentTimeMillis());
                            L.d("need retry for timeoffset duration\uff1a" + (System.currentTimeMillis() - now));
                        }
                        TangoConfigManager.this.isUploading.set(false);
                        conn.disconnect();
                        return;
                    }
                    if (code == 304) {
                        L.d("get config success, no change");
                        TangoSpUtils.getInstance().saveLong("tango_sync_time", System.currentTimeMillis());
                        TangoConfigManager.this.lastUploadTime = System.currentTimeMillis();
                        TangoConfigManager.this.isUploading.set(false);
                        conn.disconnect();
                        return;
                    }
                    if (code == 200) {
                        String result = new String(UrlconncetionUtils.toBytes((InputStream)conn.getInputStream()));
                        TangoRemoteConfig remoteConfig = (TangoRemoteConfig)Tson.fromJson((String)result, TangoRemoteConfig.class);
                        L.d("get remoteConfig" + remoteConfig.toString());
                        if (remoteConfig.autoUploadInterval > 0L) {
                            TangoConfigManager.this.mConfig = new TangoConfig().newBuilder().setRemoteConfig(remoteConfig).build();
                            TangoSpUtils.getInstance().saveString("tango_config", result);
                            TangoSpUtils.getInstance().saveLong("tango_sync_time", System.currentTimeMillis());
                            TangoConfigManager.this.lastUploadTime = System.currentTimeMillis();
                        }
                    }
                }
                catch (Exception e) {
                    L.e("get config exception" + e.toString());
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                    TangoConfigManager.this.isUploading.set(false);
                }
                TangoConfigManager.this.isUploading.set(false);
            }
        });
    }
}

