/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.log;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.api.gateway.GateWaySdk;
import com.transsion.api.gateway.GatewaySignManager;
import com.transsion.api.gateway.config.WorkMode;
import com.transsion.api.gateway.utils.ContextUtils;
import com.transsion.api.gateway.utils.DeviceUtils;
import com.transsion.api.gateway.utils.SafeStringUtils;
import com.transsion.api.gateway.utils.UrlconncetionUtils;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.json.Tson;
import com.transsion.mi.infra.tango.TangoSdk;
import com.transsion.mi.infra.tango.bean.LogBean;
import com.transsion.mi.infra.tango.bean.LogRequestBean;
import com.transsion.mi.infra.tango.bean.Resource;
import com.transsion.mi.infra.tango.utils.Crypto;
import com.transsion.mi.infra.tango.utils.L;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class LogUploader {
    private static boolean isVaidSupported() {
        try {
            Class.forName("com.transsion.ga.AthenaAnalytics");
            String vaid = AthenaAnalytics.getAppVAID((Context)ContextUtils.getContext());
            return !TextUtils.isEmpty((CharSequence)vaid);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadLogs(List<LogBean> logs) {
        if (ContextUtils.getContext() == null) {
            return false;
        }
        if (logs == null) {
            return false;
        }
        if (logs.size() == 0) {
            return false;
        }
        String vaid = "";
        String postUrl = "";
        LogRequestBean requestBean = new LogRequestBean();
        Resource resource = new Resource();
        resource.androidVersion = Build.VERSION.SDK_INT;
        resource.appId = TangoSdk.getAppId();
        resource.brand = Build.BRAND;
        resource.model = Build.MODEL;
        resource.appVersion = DeviceUtils.getVersionName();
        resource.gaid = DeviceUtils.getGAId();
        if (LogUploader.isVaidSupported()) {
            vaid = AthenaAnalytics.getAppVAID((Context)ContextUtils.getContext());
        }
        resource.vaid = vaid;
        resource.language = Locale.getDefault().getLanguage().toLowerCase();
        resource.mcc = DeviceUtils.getMcc();
        resource.pkg = ContextUtils.getContext().getPackageName();
        resource.osVersion = DeviceUtils.getOSVersion();
        resource.sdkVersion = "1.0.1.05";
        requestBean.resource = resource;
        requestBean.logBeans = logs;
        HttpURLConnection conn = null;
        String postString = Tson.toJson((Object)requestBean);
        boolean isOnline = GateWaySdk.getWorkMode() == WorkMode.MODE_ONLINE;
        postUrl = isOnline ? "https://" : "http://" + TangoSdk.getHost() + "/tango/data/logs";
        String signString = GatewaySignManager.doSign((String)"POST", (String)"application/json", (String)"application/json", (String)postUrl, (String)postString);
        byte[] gzipedBytes = LogUploader.gzip(postString.getBytes());
        L.d("post url  :" + postUrl);
        try {
            conn = (HttpURLConnection)new URL(postUrl).openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            boolean gziped = gzipedBytes != null && gzipedBytes.length > 0;
            conn.setRequestProperty("Content-Length", gziped ? "" + gzipedBytes.length : "" + postString.length());
            conn.setRequestProperty("x-scenario-type", "android");
            conn.setRequestProperty("content-type", "application/json");
            conn.setRequestProperty("accept", "application/json");
            conn.setRequestProperty("Content-Encoding", "gzip");
            conn.setRequestProperty("x-tr-signature", signString);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            OutputStream os = conn.getOutputStream();
            os.write(gziped ? gzipedBytes : postString.getBytes());
            os.flush();
            int code = conn.getResponseCode();
            L.d("upload log response code:" + code);
            if (code >= 400) {
                String result = new String(UrlconncetionUtils.toBytes((InputStream)conn.getErrorStream()));
                L.d("result from server: " + code + result);
                LogUploader.updateTime(Crypto.getTimeOffset(result));
                boolean bl = false;
                return bl;
            }
            L.d("upload log result from server: " + conn.getResponseMessage());
            if (code == 200) {
                conn.disconnect();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            L.e("response error:" + e.toString());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return false;
    }

    private static void updateTime(long serverTime) {
        if (serverTime > 0L) {
            SafeStringUtils.getInstance((Context)ContextUtils.getContext()).saveLong("time_offset", serverTime - System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] gzip(byte[] input) {
        if (input == null || input.length == 0) {
            return null;
        }
        DeflaterOutputStream gzipOS = null;
        try {
            ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
            gzipOS = new GZIPOutputStream(byteArrayOS);
            gzipOS.write(input);
            gzipOS.flush();
            gzipOS.close();
            gzipOS = null;
            byte[] byArray = byteArrayOS.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            L.e(e);
        }
        finally {
            if (gzipOS != null) {
                try {
                    gzipOS.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

