/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.log;

import com.transsion.api.gateway.utils.NetworkUtils;
import com.transsion.api.gateway.utils.ThreadManager;
import com.transsion.mi.infra.tango.TangoSdk;
import com.transsion.mi.infra.tango.bean.LogBean;
import com.transsion.mi.infra.tango.config.TangoConfig;
import com.transsion.mi.infra.tango.config.TangoConfigManager;
import com.transsion.mi.infra.tango.log.LogUploader;
import com.transsion.mi.infra.tango.utils.L;
import com.transsion.mi.infra.tango.utils.TangoLogUtils;
import com.transsion.mi.infra.tango.utils.TangoNetUtils;
import com.transsion.mi.infra.tango.utils.TangoSpUtils;
import java.util.ArrayList;
import java.util.List;

public class TangoLogManager {
    public static void uploadAllLog(final TangoSdk.UploadListener listener) {
        TangoLogUtils.getSingleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<String> cacheFiles = TangoLogUtils.getLogFiles();
                if (cacheFiles == null || cacheFiles.size() == 0) {
                    TangoLogManager.notifyUploadResult(false, "no cached logs", listener);
                    return;
                }
                ArrayList<LogBean> logBeanList = new ArrayList<LogBean>();
                long filesize = 0L;
                long uploadLimit = TangoConfigManager.getInstance().getConfig().getUploadMaxSize();
                L.d("uploadLimit: " + uploadLimit);
                for (String filePath : cacheFiles) {
                    L.d("file path: " + filePath);
                    List<LogBean> cacheList = TangoLogUtils.getLogsFromFile(filePath);
                    long size = TangoLogUtils.getFileSize(filePath);
                    L.d("file size: " + (filesize += size));
                    if (filesize > uploadLimit) break;
                    if (cacheList == null || cacheList.size() <= 0) continue;
                    L.d("add logs from file: " + filePath + "log count is " + cacheList.size());
                    logBeanList.addAll(cacheList);
                }
                if (logBeanList.size() > 0) {
                    if (LogUploader.uploadLogs(logBeanList)) {
                        TangoLogManager.notifyUploadResult(true, "", listener);
                        TangoSpUtils.getInstance().saveLong("tango_last_log_upload_time", System.currentTimeMillis());
                        TangoLogUtils.deleteLogs(cacheFiles);
                    } else {
                        TangoLogManager.notifyUploadResult(false, "upload logs http request failed", listener);
                    }
                } else {
                    TangoLogManager.notifyUploadResult(false, "no cached logs", listener);
                }
            }
        });
    }

    public static void cleanUpAll() {
        TangoLogUtils.getSingleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<String> cacheFiles = TangoLogUtils.getLogFiles();
                TangoLogUtils.deleteLogs(cacheFiles);
            }
        });
    }

    public static void cleanUpOutdate() {
        TangoLogUtils.getSingleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<String> cacheFiles = TangoLogUtils.getLogFiles();
                if (cacheFiles == null || cacheFiles.size() == 0) {
                    return;
                }
                long timeDiff = (long)(TangoConfigManager.getInstance().getConfig().getLogCacheMaxDuration() * 24) * 3600000L;
                long time = System.currentTimeMillis() - timeDiff;
                long day = time / 86400L;
                for (String filePath : cacheFiles) {
                    L.d("file path: " + filePath);
                    String dayString = filePath.replace(".txt", "");
                    try {
                        int dayNumber = Integer.parseInt(dayString);
                        L.d("dayNumber: " + dayNumber);
                        L.d("day: " + day);
                        if ((long)dayNumber > day) continue;
                        L.d("delete ");
                        TangoLogUtils.deleteLog(filePath);
                    }
                    catch (Exception e) {
                        L.e("cleanUpOutdate exception" + e.toString());
                    }
                }
            }
        });
    }

    public static void cleanUp() {
        TangoConfig config = TangoConfigManager.getInstance().getConfig();
        if (!config.isFunctionOn()) {
            L.d("clean up all");
            TangoLogManager.cleanUpAll();
            return;
        }
        TangoLogManager.cleanUpOutdate();
    }

    public static void checkAutoUpload() {
        TangoConfig config = TangoConfigManager.getInstance().getConfig();
        if (!config.isFunctionOn()) {
            L.d("log function closed");
            return;
        }
        if (!config.isAutoUpload()) {
            L.d("auto upload function closed");
            return;
        }
        if (!NetworkUtils.isNetworkAvailable()) {
            L.d("auto upload fail, no network");
            return;
        }
        long lastSyncTime = TangoSpUtils.getInstance().getLong("tango_last_log_upload_time");
        if (System.currentTimeMillis() - lastSyncTime < config.getAutoUploadInterval()) {
            L.d("auto upload fail, interval not satisfied");
            return;
        }
        if (config.isOnlyWifi() && !TangoNetUtils.isWifi()) {
            L.d("auto upload fail, no wifi");
            return;
        }
        TangoLogManager.uploadAllLog(null);
    }

    private static void notifyUploadResult(final boolean isSuccess, final String reason, final TangoSdk.UploadListener listener) {
        if (listener == null) {
            return;
        }
        ThreadManager.executeInBackground((Runnable)new Runnable(){

            @Override
            public void run() {
                if (isSuccess) {
                    listener.onSuccess();
                    return;
                }
                listener.onFail(reason);
            }
        });
    }
}

