/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.utils;

import android.app.Activity;
import android.app.Application;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import com.transsion.mi.infra.tango.utils.L;
import com.transsion.mi.infra.tango.utils.UiUtils;
import java.util.LinkedList;

public class TangoActivityLifeCycleCallback
implements Application.ActivityLifecycleCallbacks {
    private Handler handler = new Handler(Looper.getMainLooper());
    private int startActivityCount;
    private boolean isSessionTimeout = true;
    private Runnable sessionTimeout;
    private String callingSource = "";
    private String callingPackage = null;
    private long foregroundStartTime;
    private int pageNumber = 0;
    private LinkedList<PageInfo> pageStack = new LinkedList();
    private static final int MIN_WINDOW_WIDTH_HEIGHT = 1;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        if (this.isValidActivity(activity)) {
            try {
                UiUtils.setForegroud(true);
                String pageName = activity.getClass().getSimpleName();
                ++this.pageNumber;
                this.pageStack.addLast(new PageInfo(this.pageNumber, pageName, System.currentTimeMillis()));
                ++this.startActivityCount;
                if (this.startActivityCount <= 1) {
                    this.foregroundStartTime = SystemClock.elapsedRealtime();
                    if (this.isSessionTimeout) {
                        UiUtils.setSessionId(UiUtils.genSessionId());
                        try {
                            if (Build.VERSION.SDK_INT >= 22) {
                                Uri referrer = activity.getReferrer();
                                if (referrer != null) {
                                    this.callingPackage = referrer.getAuthority();
                                }
                            } else {
                                this.callingPackage = activity.getCallingPackage();
                            }
                        }
                        catch (Exception e) {
                            L.e(Log.getStackTraceString((Throwable)e));
                        }
                    }
                }
                this.isSessionTimeout = false;
                if (this.sessionTimeout != null) {
                    this.handler.removeCallbacks(this.sessionTimeout);
                    this.sessionTimeout = null;
                }
            }
            catch (Exception e) {
                L.e(Log.getStackTraceString((Throwable)e));
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (this.isValidActivity(activity)) {
            try {
                --this.startActivityCount;
                if (this.startActivityCount == 0) {
                    UiUtils.setForegroud(false);
                    if (this.sessionTimeout != null) {
                        this.handler.removeCallbacks(this.sessionTimeout);
                    }
                    this.sessionTimeout = new Runnable(){

                        @Override
                        public void run() {
                            TangoActivityLifeCycleCallback.this.pageStack.clear();
                            TangoActivityLifeCycleCallback.this.isSessionTimeout = true;
                            TangoActivityLifeCycleCallback.this.callingPackage = "";
                            TangoActivityLifeCycleCallback.this.callingSource = "";
                            UiUtils.setSessionId(UiUtils.genSessionId());
                        }
                    };
                    this.handler.postDelayed(this.sessionTimeout, 30000L);
                }
            }
            catch (Exception e) {
                L.e(Log.getStackTraceString((Throwable)e));
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private boolean isValidActivity(Activity activity) {
        if (activity == null) {
            return false;
        }
        Window window = activity.getWindow();
        if (window != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            return params.width <= 0 || params.width > 1 || params.height <= 0 || params.height > 1;
        }
        return false;
    }

    private class PageInfo {
        int pageNumber;
        String pageName;
        long pageStart;

        PageInfo(int pageNumber, String pageName, long pageStart) {
            this.pageNumber = pageNumber;
            this.pageName = pageName;
            this.pageStart = pageStart;
        }
    }
}

