/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.utils;

import android.text.TextUtils;
import com.transsion.mi.infra.tango.utils.L;
import java.io.File;
import java.io.FileInputStream;

public class TangoFileUtils {
    public static long getFileOrFilesSize(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return 0L;
        }
        long timeNow = System.currentTimeMillis();
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? TangoFileUtils.getFileSizes(file) : TangoFileUtils.getFileSize(file);
            L.d("get file size duration" + (System.currentTimeMillis() - timeNow));
            L.d("get" + filePath + "file size is: " + TangoFileUtils.FormetFileSize(blockSize) + "kb");
        }
        catch (Exception e) {
            L.e("getFileOrFilesSize exception" + e.toString());
        }
        return TangoFileUtils.FormetFileSize(blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getFileSize(File file) throws Exception {
        if (file == null) {
            return 0L;
        }
        long size = 0L;
        FileInputStream fis = null;
        if (!file.exists() && file.createNewFile()) {
            return 0L;
        }
        try {
            fis = new FileInputStream(file);
            size = fis.available();
        }
        catch (Exception e) {
            L.e("getFileSize exception" + e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return size;
    }

    private static long getFileSizes(File f) throws Exception {
        if (f == null) {
            return 0L;
        }
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += TangoFileUtils.getFileSizes(flist[i]);
                continue;
            }
            size += TangoFileUtils.getFileSize(flist[i]);
        }
        return size;
    }

    private static long FormetFileSize(long fileS) {
        double fileSizeLong = 0.0;
        return fileS / 1024L;
    }
}

