/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mi.infra.tango.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.api.gateway.utils.ContextUtils;
import com.transsion.json.Tson;
import com.transsion.mi.infra.tango.bean.LogBean;
import com.transsion.mi.infra.tango.config.TangoConfig;
import com.transsion.mi.infra.tango.config.TangoConfigManager;
import com.transsion.mi.infra.tango.log.LogUploader;
import com.transsion.mi.infra.tango.utils.L;
import com.transsion.mi.infra.tango.utils.TangoFileUtils;
import com.transsion.mi.infra.tango.utils.UiUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TangoLogUtils {
    private static final int MAX_LEN = 4000;
    private static final Format FORMAT = new SimpleDateFormat("MMdd HH:mm:ss.SSS ", Locale.getDefault());
    private static final String NULL_TIPS = "Log with null object.";
    private static final String NULL = "null";
    private static final String ARGS = "args";
    private static ExecutorService executor;
    private static final String FILE_SEP;
    private static final String LINE_SEP;
    private static int YEAR;

    public static void log(String type, String tag, Object ... contents) {
        try {
            if (contents == null) {
                L.d("content is null");
                return;
            }
            TangoConfig config = TangoConfigManager.getInstance().getConfig();
            if (!config.isFunctionOn()) {
                L.d("tango function is closed, do not log");
                return;
            }
            String checkTag = "";
            if (!TextUtils.isEmpty((CharSequence)tag)) {
                checkTag = tag.length() > 23 ? tag.substring(0, 23) : tag;
            }
            String body = TangoLogUtils.processBody(contents);
            if (config.isLogConsoleOn()) {
                Log.d((String)tag, (String)body);
            }
            if (TextUtils.isEmpty((CharSequence)type) || TangoLogUtils.isDebugLog(type) && !config.isUploadDebugLog()) {
                L.d("do not write debug log to file");
                return;
            }
            TangoLogUtils.print2File(type, checkTag, body);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isDebugLog(String type) {
        return "DEBUG".equals(type) || "VERBOSE".equals(type);
    }

    public static ExecutorService getSingleExecutor() {
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
        }
        return executor;
    }

    private static String processBody(Object ... contents) {
        String body = NULL_TIPS;
        try {
            if (contents != null) {
                if (contents.length == 1) {
                    Object object = contents[0];
                    body = object == null ? NULL : object.toString();
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Object content : contents) {
                        sb.append(content == null ? NULL : content.toString());
                    }
                    body = sb.toString();
                }
            }
            if (body.length() > TangoConfigManager.getInstance().getConfig().getLogMaxLength()) {
                body = body.substring(0, TangoConfigManager.getInstance().getConfig().getLogMaxLength());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return body;
    }

    private static void print2File(final String type, final String tag, final String msg) {
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
        }
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String defaultDir = "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
                String fullPath = defaultDir + System.currentTimeMillis() / 86400L + ".txt";
                long maxSingleFileSize = TangoConfigManager.getInstance().getConfig().getLogFileMaxSize();
                L.d("config maxSingleFileSize: " + maxSingleFileSize);
                for (int i = 0; i < 1000 && TangoFileUtils.getFileOrFilesSize(fullPath) > maxSingleFileSize; ++i) {
                    fullPath = defaultDir + (System.currentTimeMillis() / 86400L + (long)i) + ".txt";
                }
                if (!TangoLogUtils.createOrExistsFile(fullPath)) {
                    Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
                    return;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(tag).append(msg);
                LogBean log = new LogBean();
                log.timestamp = System.currentTimeMillis();
                log.level = type;
                log.sessionId = UiUtils.getSessionId();
                log.body = sb.toString();
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(fullPath, true));
                    bw.write("tango{}" + Tson.toJson((Object)log));
                    Log.d((String)tag, (String)("log to " + fullPath + " success!"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        L.e("print2File exception" + e.toString());
                    }
                }
            }
        });
    }

    public static List<String> getLogFiles() {
        String defaultDir = "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        ArrayList<String> fileList = new ArrayList<String>();
        File file = new File(defaultDir);
        File[] tempList = file.listFiles();
        if (tempList == null || tempList.length == 0) {
            return null;
        }
        for (int i = 0; i < tempList.length; ++i) {
            String fileName;
            if (!tempList[i].isFile() || !(fileName = tempList[i].getName()).endsWith(".txt")) continue;
            fileList.add(fileName);
        }
        return fileList;
    }

    public static long getFileSize(String fileName) {
        String defaultDir = "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        String fullPath = defaultDir + fileName;
        return TangoFileUtils.getFileOrFilesSize(fullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogBean> getLogsFromFile(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return new LinkedList<LogBean>();
        }
        String defaultDir = "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        String fullPath = defaultDir + fileName;
        if (!TangoLogUtils.isFileExists(fullPath)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fullPath));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception line) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException line) {}
            }
        }
        ArrayList<LogBean> logBeanList = new ArrayList<LogBean>();
        try {
            String[] logs = sb.toString().split("tango\\{\\}");
            for (int i = 0; i < logs.length; ++i) {
                try {
                    LogBean logBean = (LogBean)Tson.fromJson((String)logs[i], LogBean.class);
                    logBeanList.add(logBean);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (logBeanList.size() > 0) {
                L.d("file contains log count: " + logBeanList.size());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logBeanList;
    }

    private static boolean isExternalCacheDir() {
        return "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null;
    }

    public static void file2String() {
        if (ContextUtils.getContext() == null) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        Date now = new Date(timeNow);
        String format = FORMAT.format(now);
        String date = format.substring(0, 4);
        String defaultDir = TangoLogUtils.isExternalCacheDir() ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        final String fullPath = defaultDir + YEAR + date + ".txt";
        if (!TangoLogUtils.isFileExists(fullPath)) {
            return;
        }
        TangoLogUtils.getSingleExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(fullPath));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    L.e("file to string Exception" + e.toString());
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                        TangoLogUtils.uploadStringToServer(sb.toString(), fullPath);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    private static void uploadStringToServer(String logString, String filePath) {
        if (TextUtils.isEmpty((CharSequence)logString)) {
            return;
        }
        String[] logs = logString.split("tango\\{\\}");
        ArrayList<LogBean> logBeanList = new ArrayList<LogBean>();
        for (String log : logs) {
            try {
                LogBean logBean = (LogBean)Tson.fromJson((String)log, LogBean.class);
                logBeanList.add(logBean);
            }
            catch (Exception e) {
                L.e("logBeanList exception " + e.toString());
            }
        }
        if (LogUploader.uploadLogs(logBeanList)) {
            Log.d((String)"tango", (String)"upload logs success");
            TangoLogUtils.deleteFile(filePath);
        }
    }

    private static boolean createOrExistsFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!TangoLogUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isFileExists(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static void deleteLog(String fileName) {
        String defaultDir = "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        TangoLogUtils.deleteFile(defaultDir + fileName);
    }

    public static void deleteLogs(List<String> fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        String defaultDir = "mounted".equals(Environment.getExternalStorageState()) && TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) != null ? TangoLogUtils.getExternalCacheDir(ContextUtils.getContext()) + FILE_SEP + "log" + FILE_SEP : ContextUtils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        for (String file : fileName) {
            TangoLogUtils.deleteFile(defaultDir + file);
        }
    }

    public static boolean deleteFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static File getExternalCacheDir(Context context) {
        boolean isUserRequired;
        if (context == null) {
            return null;
        }
        File cacheDir = null;
        try {
            Field privateBoolField = Environment.class.getDeclaredField("sUserRequired");
            privateBoolField.setAccessible(true);
            Environment user = new Environment();
            isUserRequired = privateBoolField.getBoolean(user);
        }
        catch (Exception e) {
            isUserRequired = true;
        }
        try {
            if (!isUserRequired) {
                cacheDir = context.getExternalCacheDir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cacheDir;
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        LINE_SEP = System.getProperty("line.separator");
        YEAR = Calendar.getInstance().get(1);
    }
}

