/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.librarybase.extension;

import android.content.Context;
import androidx.annotation.Keep;
import com.smartlife.nebula.librarybase.constant.PidConsts;
import com.smartlife.nebula.librarybase.utils.LogUtil;
import com.smartlife.nebula.main.devicesmanager.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0007\u001a\f\u0010\u0004\u001a\u00020\u0003*\u00020\u0000H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0000H\u0007\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0000H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\u0000H\u0007\u001a\f\u0010\b\u001a\u00020\u0000*\u00020\u0000H\u0007\u001a\u0014\u0010\u000b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\n\u001a\u00020\tH\u0007\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0000H\u0007\u001a\f\u0010\r\u001a\u00020\u0000*\u00020\u0000H\u0007\u001a\f\u0010\u000e\u001a\u00020\u0000*\u00020\u0000H\u0007\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0000H\u0007\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0007\u001a\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0000H\u0007\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0000H\u0007\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0000H\u0007\u00a8\u0006\u0015"}, d2={"", "", "isValid", "", "getDeviceType", "getDeviceSubType", "getWirelessChannel", "getDeviceNameCode", "getDeviceNameCodeString", "Landroid/content/Context;", "context", "getDeviceTypeString", "isSynixTV", "getBluetoothBroadcastName", "getPidByBluetoothBroadcastName", "isNetUrl", "localIcon", "isLocalImageUrl", "getProtocolVersion", "isNeedLocationPermissionGoDetail", "isNeedScanPairedDevice", "commons_release"})
public final class StringExKt {
    @Keep
    public static final boolean isValid(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        return StringsKt.startsWith$default((String)string3, (String)"0x", (boolean)false, (int)2, null) && string2.length() == 20;
    }

    @Keep
    public static final int getDeviceType(@NotNull String string2) {
        int n;
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        try {
            n = Integer.parseInt(StringsKt.substring((String)string3, (IntRange)new IntRange(2, 3)), CharsKt.checkRadix((int)16)) & 0xFF;
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    @Keep
    public static final int getDeviceSubType(@NotNull String string2) {
        int n;
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        try {
            n = Integer.parseInt(StringsKt.substring((String)string3, (IntRange)new IntRange(4, 5)), CharsKt.checkRadix((int)16)) & 0xFF;
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    @Keep
    public static final int getWirelessChannel(@NotNull String string2) {
        int n;
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        try {
            n = Integer.parseInt(StringsKt.substring((String)string3, (IntRange)new IntRange(12, 13)), CharsKt.checkRadix((int)16)) & 0xFF;
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    @Keep
    public static final int getDeviceNameCode(@NotNull String string2) {
        int n;
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        try {
            n = string3.length();
        }
        catch (Exception exception) {
            return -1;
        }
        int n2 = Integer.parseInt(StringsKt.substring((String)string3, (IntRange)RangesKt.until((int)(n - 4), (int)string2.length())));
        LogUtil.INSTANCE.i("\u89e3\u6790pid\u4e2d\u7684\u8bbe\u5907\u540d\u79f0\u7f16\u7801 : " + n2);
        return n2;
    }

    @Keep
    @NotNull
    public static final String getDeviceNameCodeString(@NotNull String string2) {
        int n;
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        try {
            n = string3.length();
        }
        catch (Exception exception) {
            return "";
        }
        String string4 = StringsKt.substring((String)string3, (IntRange)RangesKt.until((int)(n - 4), (int)string2.length()));
        LogUtil.INSTANCE.i("\u89e3\u6790pid\u4e2d\u7684\u8bbe\u5907\u540d\u79f0\u7f16\u7801 : " + string4);
        return string4;
    }

    @Keep
    @NotNull
    public static final String getDeviceTypeString(@NotNull String string2, @NotNull Context context) {
        String string3;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int n = StringExKt.getDeviceType(string2);
        if (n != 0) {
            if (n != 1) {
                if (n != 5) {
                    string3 = "";
                } else {
                    string3 = context.getString(R.string.module_commons_gateway);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.module_commons_gateway)");
                }
            } else {
                string3 = context.getString(R.string.module_device_manger_type_tv);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.module_device_manger_type_tv)");
            }
        } else {
            string3 = context.getString(R.string.module_device_manger_type_wear);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.module_device_manger_type_wear)");
        }
        return string3;
    }

    @Keep
    public static final boolean isSynixTV(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        PidConsts pidConsts = PidConsts.INSTANCE;
        return Intrinsics.areEqual((Object)string3, (Object)pidConsts.getSYINIX_32A1S()) || Intrinsics.areEqual((Object)string2, (Object)pidConsts.getSYINIX_43A1S()) || Intrinsics.areEqual((Object)string2, (Object)pidConsts.getSYINIX_65F1S());
    }

    @Keep
    @NotNull
    public static final String getBluetoothBroadcastName(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        PidConsts pidConsts = PidConsts.INSTANCE;
        return Intrinsics.areEqual((Object)string3, (Object)pidConsts.getIFB_13()) ? "IFB-13" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getOFB_12()) ? "OFB-12" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getOFB_21()) ? "OFB-21" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getIFB_31()) ? "IFB-31" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getOSW_10()) ? "oraimo Tempo W" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getOSW_11()) ? "oraimo Tempo S" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getOSW_20()) ? "oraimo Tempo W2" : (Intrinsics.areEqual((Object)string2, (Object)pidConsts.getOSW_16()) ? "oraimo Watch" : "")))))));
    }

    @Keep
    @NotNull
    public static final String getPidByBluetoothBroadcastName(@NotNull String string2) {
        String string3;
        block10: {
            String string4 = string2;
            Intrinsics.checkNotNullParameter((Object)string4, (String)"<this>");
            switch (string4.hashCode()) {
                default: {
                    break;
                }
                case 2026941311: {
                    if (!string2.equals("oraimo Tempo W")) break;
                    string3 = PidConsts.INSTANCE.getOSW_10();
                    break block10;
                }
                case 2026941307: {
                    if (!string2.equals("oraimo Tempo S")) break;
                    string3 = PidConsts.INSTANCE.getOSW_11();
                    break block10;
                }
                case 1779066620: {
                    if (!string2.equals("oraimo Watch")) break;
                    string3 = PidConsts.INSTANCE.getOSW_16();
                    break block10;
                }
                case -1589328749: {
                    if (!string2.equals("oraimo Tempo W2")) break;
                    string3 = PidConsts.INSTANCE.getOSW_20();
                    break block10;
                }
                case -1966606847: {
                    if (!string2.equals("OFB-21")) break;
                    string3 = PidConsts.INSTANCE.getOFB_21();
                    break block10;
                }
                case -1966606877: {
                    if (!string2.equals("OFB-12")) break;
                    string3 = PidConsts.INSTANCE.getOFB_12();
                    break block10;
                }
                case -2138381722: {
                    if (!string2.equals("IFB-31")) break;
                    string3 = PidConsts.INSTANCE.getIFB_31();
                    break block10;
                }
                case -2138381782: {
                    if (!string2.equals("IFB-13")) break;
                    string3 = PidConsts.INSTANCE.getIFB_13();
                    break block10;
                }
            }
            string3 = "";
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    public static final boolean isNetUrl(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        if (string3.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (!StringsKt.startsWith$default((String)string2, (String)"http", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Keep
    public static final boolean isLocalImageUrl(@NotNull String string2, @NotNull String string3) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"localIcon");
        if (string2.length() == 0) {
            return false;
        }
        if (StringExKt.isNetUrl(string2) && !(string3.length() == 0)) {
            String string4 = string2;
            String string5 = string4.substring(StringsKt.lastIndexOf$default((CharSequence)string4, (String)"/", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            String string6 = string5.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase()");
            String string7 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase()");
            bl = StringsKt.contains$default((CharSequence)string6, (CharSequence)string7, (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    @Keep
    public static final int getProtocolVersion(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        int n = Integer.parseInt(StringsKt.substring((String)string3, (IntRange)new IntRange(14, 15)), CharsKt.checkRadix((int)16));
        return Integer.parseInt("" + ((n & 0xF0) >> 4) + (n & 0xF));
    }

    @Keep
    public static final boolean isNeedLocationPermissionGoDetail(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        return StringExKt.getDeviceSubType(string3) == 8;
    }

    @Keep
    public static final boolean isNeedScanPairedDevice(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<this>");
        return (StringExKt.getWirelessChannel(string3) == 18 || StringExKt.getWirelessChannel(string2) == 49) && StringExKt.getDeviceSubType(string2) != 11;
    }
}

