/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.librarybase.utils;

import android.app.Activity;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.text.Html;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.smartlife.nebula.librarybase.utils.LogUtil;
import com.smartlife.nebula.librarybase.utils.ScanProcessDialogHelper;
import com.smartlife.nebula.main.devicesmanager.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\"\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\"\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/smartlife/nebula/librarybase/utils/PermissionUtils;", "", "Landroid/content/Context;", "context", "", "isLocationEnable", "isNearbyDevicesPermissionAccpet", "Landroidx/fragment/app/Fragment;", "fragment", "Lkotlin/Function1;", "", "", "callback", "showNearbyDevicesOpenPermissionDialog", "Landroidx/appcompat/app/AppCompatActivity;", "activity", "isLocationPermissionAccpet", "", "TAG", "Ljava/lang/String;", "<init>", "()V", "commons_release"})
public final class PermissionUtils {
    @NotNull
    public static final PermissionUtils INSTANCE = new PermissionUtils();
    @NotNull
    private static final String TAG = "PermissionUtils";

    private PermissionUtils() {
    }

    public final boolean isLocationEnable(@NotNull Context context) {
        boolean bl;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PermissionUtils permissionUtils = (LocationManager)context2.getSystemService("location");
        if (permissionUtils == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            bl = permissionUtils.isLocationEnabled();
        } else {
            boolean bl2 = permissionUtils.isProviderEnabled("network");
            bl = permissionUtils.isProviderEnabled("gps") || bl2;
        }
        return bl;
    }

    public final boolean isNearbyDevicesPermissionAccpet(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 31) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.BLUETOOTH_SCAN") != 0) {
                LogUtil.INSTANCE.w("PermissionUtils,BLUETOOTH_SCAN permission deny");
                return false;
            }
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.BLUETOOTH_CONNECT") != 0) {
                LogUtil.INSTANCE.w("PermissionUtils,BLUETOOTH_CONNECT permission deny");
                return false;
            }
        }
        return true;
    }

    public final void showNearbyDevicesOpenPermissionDialog(@NotNull Fragment fragment, @NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(function1, (String)"callback");
        PermissionUtils permissionUtils = fragment.getActivity();
        if (permissionUtils != null) {
            String string2 = fragment.getString(R.string.module_device_manger_ask_for_nearby_devce_permission);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fragment.getString(R.string.module_device_manger_ask_for_nearby_devce_permission)");
            fragment = Html.fromHtml((String)string2, (int)0);
            new ScanProcessDialogHelper((Activity)permissionUtils).showManualOpenPermissionDialog(fragment.toString(), function1);
        }
    }

    public final void showNearbyDevicesOpenPermissionDialog(@NotNull AppCompatActivity appCompatActivity, @NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)appCompatActivity, (String)"activity");
        Intrinsics.checkNotNullParameter(function1, (String)"callback");
        String string2 = appCompatActivity.getString(R.string.module_device_manger_ask_for_nearby_devce_permission);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.string.module_device_manger_ask_for_nearby_devce_permission)");
        PermissionUtils permissionUtils = Html.fromHtml((String)string2, (int)0);
        new ScanProcessDialogHelper((Activity)appCompatActivity).showManualOpenPermissionDialog(permissionUtils.toString(), function1);
    }

    public final boolean isLocationPermissionAccpet(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (ContextCompat.checkSelfPermission((Context)context2, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            LogUtil.INSTANCE.w("PermissionUtils,android.permission.ACCESS_FINE_LOCATION permission deny");
            return false;
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            LogUtil.INSTANCE.w("PermissionUtils,android.permission.ACCESS_COARSE_LOCATION permission deny");
            return false;
        }
        return true;
    }
}

