/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.librarybase.widget;

import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010\u0003\u001a\u00020\u0002H\u0002J(\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/smartlife/nebula/librarybase/widget/GridSpacingItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "", "isRtl", "Landroid/graphics/Rect;", "outRect", "Landroid/view/View;", "view", "Landroidx/recyclerview/widget/RecyclerView;", "parent", "Landroidx/recyclerview/widget/RecyclerView$State;", "state", "", "getItemOffsets", "", "spanCount", "I", "spacing", "includeEdge", "Z", "<init>", "(IIZ)V", "commons_release"})
public final class GridSpacingItemDecoration
extends RecyclerView.ItemDecoration {
    private int spanCount;
    private int spacing;
    private boolean includeEdge;

    public GridSpacingItemDecoration(int n, int n2, boolean bl) {
        this.spanCount = n;
        this.spacing = n2;
        this.includeEdge = bl;
    }

    private final boolean isRtl() {
        return TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
    }

    public void getItemOffsets(@NotNull Rect rect, @NotNull View view, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int n = recyclerView.getChildAdapterPosition(view);
        int n2 = n % this.spanCount;
        if (this.includeEdge) {
            if (this.isRtl()) {
                int n3 = n2;
                int n4 = this.spacing;
                int n5 = n2 * n4;
                n2 = this.spanCount;
                rect.right = n4 - n5 / n2;
                rect.left = (n3 + 1) * n4 / n2;
            } else {
                int n6 = n2;
                int n7 = this.spacing;
                int n8 = n2 * n7;
                n2 = this.spanCount;
                rect.left = n7 - n8 / n2;
                rect.right = (n6 + 1) * n7 / n2;
            }
            if (n < this.spanCount) {
                rect.top = this.spacing;
            }
            rect.bottom = this.spacing;
        } else {
            if (this.isRtl()) {
                int n9 = this.spacing;
                int n10 = n2;
                int n11 = n2 * n9;
                n2 = this.spanCount;
                rect.right = n11 / n2;
                rect.left = n9 - (n10 + 1) * n9 / n2;
            } else {
                int n12 = this.spacing;
                int n13 = n2;
                int n14 = n2 * n12;
                n2 = this.spanCount;
                rect.left = n14 / n2;
                rect.right = n12 - (n13 + 1) * n12 / n2;
            }
            if (n >= this.spanCount) {
                rect.top = this.spacing;
            }
        }
    }
}

