/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.librarybase.utils.permission;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.os.Build;
import androidx.activity.result.ActivityResultLauncher;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.smartlife.nebula.librarybase.utils.LogUtil;
import com.smartlife.nebula.librarybase.utils.permission.PermissionBleHelper;
import com.smartlife.nebula.librarybase.utils.permission.PermissionDialog;
import com.smartlife.nebula.librarybase.utils.permission.PermissionType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u001c\u0010\u000b\u001a\u00020\n2\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0006J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010JY\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00072\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u00062\u001c\u0010\u0016\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\b8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lcom/smartlife/nebula/librarybase/utils/permission/PermissionBleHelper;", "", "Landroid/content/Context;", "context", "", "checkBleNearbyState", "Landroidx/activity/result/ActivityResultLauncher;", "", "", "mPermissionResultLauncher", "", "applyBluetoothScanPermission", "applyOpenBleSwitch", "checkBleSwitchIsOpen", "permission", "checkHasPermission", "Landroidx/fragment/app/Fragment;", "fragment", "checkBleScanDialogShow", "", "mPermissionArr", "Lkotlin/Function1;", "mResultCallback", "applyBleOpen", "(Landroid/content/Context;[Ljava/lang/Integer;Landroidx/activity/result/ActivityResultLauncher;Lkotlin/jvm/functions/Function1;)V", "state", "setBleAllPermissionState", "(I[Ljava/lang/Integer;)V", "SETTING_BLE_NEARBY", "Ljava/lang/String;", "<init>", "()V", "commons_release"})
public final class PermissionBleHelper {
    @NotNull
    public static final PermissionBleHelper INSTANCE = new PermissionBleHelper();
    @NotNull
    public static final String SETTING_BLE_NEARBY = "setting_ble_nearby";

    private PermissionBleHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkBleNearbyState(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 31) return true;
        boolean bl = this.checkHasPermission(context, "android.permission.BLUETOOTH_CONNECT");
        boolean bl2 = this.checkHasPermission(context, "android.permission.BLUETOOTH_SCAN");
        LogUtil.INSTANCE.i("\u68c0\u67e5\u84dd\u7259\u5f00\u5173\u662f\u5426\u6253\u5f00 checkHasBleConnectPermission:" + bl + "  ,checkHasBleScanPermission: " + bl2 + " ");
        if (!bl) return false;
        if (!bl2) return false;
        return true;
    }

    public final void applyBluetoothScanPermission(@Nullable ActivityResultLauncher<String[]> activityResultLauncher) {
        if (Build.VERSION.SDK_INT >= 31) {
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = "android.permission.BLUETOOTH_CONNECT";
            stringArray[1] = "android.permission.BLUETOOTH_SCAN";
            if (activityResultLauncher != null) {
                activityResultLauncher.launch((Object)stringArray2);
            }
        }
    }

    public final boolean applyOpenBleSwitch() {
        return BluetoothAdapter.getDefaultAdapter().enable();
    }

    public final boolean checkBleSwitchIsOpen() {
        return BluetoothAdapter.getDefaultAdapter().isEnabled();
    }

    public final boolean checkHasPermission(@NotNull Context context, @NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"permission");
        return ActivityCompat.checkSelfPermission((Context)context, (String)string3) == 0;
    }

    public final boolean checkBleScanDialogShow(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (Build.VERSION.SDK_INT >= 31) {
            return fragment.shouldShowRequestPermissionRationale("android.permission.BLUETOOTH_SCAN");
        }
        return true;
    }

    public final void applyBleOpen(@NotNull Context context, @NotNull Integer[] integerArray, @Nullable ActivityResultLauncher<String[]> activityResultLauncher, @Nullable Function1<? super Integer[], Unit> function1) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)integerArray, (String)"mPermissionArr");
        if (Build.VERSION.SDK_INT >= 31) {
            Integer n;
            LogUtil logUtil = LogUtil.INSTANCE;
            logUtil.i("applyBleOpen  over s");
            boolean bl = ((PermissionBleHelper)object).checkBleNearbyState(context);
            logUtil.i("applyBleOpen  over s  BleNearbyState: " + bl);
            int n2 = PermissionType.BLUETOOTH_CONNECT.ordinal();
            integerArray[n2] = n = Integer.valueOf(bl ? PermissionType.BLUETOOTH_SWITCH.getByteValue() : 0);
            n2 = PermissionType.BLUETOOTH_SCAN.ordinal();
            integerArray[n2] = n = Integer.valueOf(bl ? PermissionType.BLUETOOTH_SWITCH.getByteValue() : 0);
            if (bl) {
                boolean bl2 = ((PermissionBleHelper)object).checkBleSwitchIsOpen();
                logUtil.i("applyBleOpen  over s bleEnable : " + bl2);
                if (bl2) {
                    ((PermissionBleHelper)object).setBleAllPermissionState(1, integerArray);
                    if (function1 != null) {
                        function1.invoke((Object)integerArray);
                    }
                } else {
                    integerArray[PermissionType.BLUETOOTH_SWITCH.ordinal()] = 0;
                    PermissionDialog.INSTANCE.getBleDialog(context, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(integerArray, function1){
                        public final /* synthetic */ Integer[] $mPermissionArr;
                        public final /* synthetic */ Function1<Integer[], Unit> $mResultCallback;
                        {
                            this.$mPermissionArr = integerArray;
                            this.$mResultCallback = function1;
                            super(1);
                        }

                        public final void invoke(boolean bl) {
                            if (bl) {
                                Function1<Integer[], Unit> function1 = PermissionBleHelper.INSTANCE;
                                if (function1.applyOpenBleSwitch()) {
                                    function1.setBleAllPermissionState(1, this.$mPermissionArr);
                                    function1 = this.$mResultCallback;
                                    if (function1 != null) {
                                        function1.invoke((Object)this.$mPermissionArr);
                                    }
                                } else {
                                    applyBleOpen.1 v0 = this;
                                    v0.$mPermissionArr[PermissionType.BLUETOOTH_SWITCH.ordinal()] = 0;
                                    function1 = v0.$mResultCallback;
                                    if (function1 != null) {
                                        function1.invoke((Object)this.$mPermissionArr);
                                    }
                                }
                            } else {
                                applyBleOpen.1 v1 = this;
                                v1.$mPermissionArr[PermissionType.BLUETOOTH_SWITCH.ordinal()] = 0;
                                Function1<Integer[], Unit> function1 = v1.$mResultCallback;
                                if (function1 != null) {
                                    function1.invoke((Object)this.$mPermissionArr);
                                }
                            }
                        }
                    });
                }
            } else {
                ((PermissionBleHelper)object).applyBluetoothScanPermission(activityResultLauncher);
            }
        } else if (!((PermissionBleHelper)object).checkBleSwitchIsOpen()) {
            Function1<Boolean, Unit> function12;
            object = function12;
            function12 = new Function1<Boolean, Unit>(integerArray, function1){
                public final /* synthetic */ Integer[] $mPermissionArr;
                public final /* synthetic */ Function1<Integer[], Unit> $mResultCallback;
                {
                    this.$mPermissionArr = integerArray;
                    this.$mResultCallback = function1;
                    super(1);
                }

                public final void invoke(boolean bl) {
                    if (bl) {
                        Function1<Integer[], Unit> function1 = this.$mPermissionArr;
                        Object object = PermissionType.BLUETOOTH_SWITCH;
                        int n = object.ordinal();
                        object = PermissionBleHelper.INSTANCE.applyOpenBleSwitch() ? object.getByteValue() : 0;
                        function1[n] = object;
                        function1 = this.$mResultCallback;
                        if (function1 != null) {
                            function1.invoke((Object)this.$mPermissionArr);
                        }
                    } else {
                        applyBleOpen.2 v0 = this;
                        v0.$mPermissionArr[PermissionType.BLUETOOTH_SWITCH.ordinal()] = 0;
                        Function1<Integer[], Unit> function1 = v0.$mResultCallback;
                        if (function1 != null) {
                            function1.invoke((Object)this.$mPermissionArr);
                        }
                    }
                }
            };
            PermissionDialog.INSTANCE.getBleDialog(context, (Function1<? super Boolean, Unit>)object);
        } else {
            object = PermissionType.BLUETOOTH_SWITCH;
            integerArray[((Enum)object).ordinal()] = ((PermissionType)((Object)object)).getByteValue();
            if (function1 != null) {
                function1.invoke((Object)integerArray);
            }
        }
    }

    public final void setBleAllPermissionState(int n, @NotNull Integer[] integerArray) {
        Intrinsics.checkNotNullParameter((Object)integerArray, (String)"mPermissionArr");
        if (n == 0) {
            int n2 = PermissionType.BLUETOOTH_SCAN.ordinal();
            integerArray[n2] = n;
            n2 = PermissionType.BLUETOOTH_CONNECT.ordinal();
            integerArray[n2] = n;
            n2 = PermissionType.BLUETOOTH_SWITCH.ordinal();
            integerArray[n2] = n;
        } else {
            Integer[] integerArray2 = integerArray;
            Object object = PermissionType.BLUETOOTH_SCAN;
            integerArray2[((Enum)object).ordinal()] = ((PermissionType)((Object)object)).getByteValue();
            object = PermissionType.BLUETOOTH_CONNECT;
            integerArray2[((Enum)object).ordinal()] = ((PermissionType)((Object)object)).getByteValue();
            object = PermissionType.BLUETOOTH_SWITCH;
            integerArray[((Enum)object).ordinal()] = ((PermissionType)((Object)object)).getByteValue();
        }
    }
}

