/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.family.db;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.smartlife.nebula.family.db.WeLifeDatabase;
import com.smartlife.nebula.family.db.dao.FamilyDao;
import com.smartlife.nebula.family.db.dao.FamilyDao_Impl;
import com.smartlife.nebula.family.db.dao.FamilyDeviceDao;
import com.smartlife.nebula.family.db.dao.FamilyDeviceDao_Impl;
import com.smartlife.nebula.family.db.dao.FamilyMemberDao;
import com.smartlife.nebula.family.db.dao.FamilyMemberDao_Impl;
import com.smartlife.nebula.family.db.dao.MessageDao;
import com.smartlife.nebula.family.db.dao.MessageDao_Impl;
import com.smartlife.nebula.family.db.dao.RoomDao;
import com.smartlife.nebula.family.db.dao.RoomDao_Impl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class WeLifeDatabase_Impl
extends WeLifeDatabase {
    private volatile FamilyDao _familyDao;
    private volatile RoomDao _roomDao;
    private volatile FamilyMemberDao _familyMemberDao;
    private volatile FamilyDeviceDao _familyDeviceDao;
    private volatile MessageDao _messageDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(3){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `FamilyBean` (`familyId` INTEGER NOT NULL, `createUserId` INTEGER NOT NULL, `userId` INTEGER NOT NULL, `familyName` TEXT NOT NULL, `roomCount` INTEGER NOT NULL, `deviceCount` INTEGER NOT NULL, `defaultFamily` INTEGER NOT NULL, `createUserNick` TEXT, PRIMARY KEY(`familyId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `RoomBean` (`familyId` INTEGER NOT NULL, `roomName` TEXT NOT NULL, `roomDeviceCount` INTEGER NOT NULL, `insertTime` INTEGER NOT NULL, PRIMARY KEY(`familyId`, `roomName`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `FamilyMemberBean` (`memberId` INTEGER NOT NULL, `familyId` INTEGER NOT NULL, `memberName` TEXT, `memberRule` INTEGER NOT NULL, `memberIcon` TEXT, `memberJoinDate` INTEGER NOT NULL, `toBeGreed` INTEGER NOT NULL, `owner` INTEGER NOT NULL, PRIMARY KEY(`memberId`, `familyId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `FamilyDeviceBean` (`familyId` INTEGER NOT NULL, `pid` TEXT NOT NULL, `did` TEXT NOT NULL, `deviceName` TEXT NOT NULL, `remoteUrl` TEXT, `localRes` INTEGER, `deviceRoom` TEXT, `applianceId` INTEGER NOT NULL, `deviceJoinTime` INTEGER NOT NULL, `onlineStatus` INTEGER, `curDevConnectNum` INTEGER, `mac` TEXT, PRIMARY KEY(`familyId`, `applianceId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `MessageBean` (`messageId` INTEGER NOT NULL, `userId` INTEGER NOT NULL, `read` INTEGER NOT NULL, `createTime` INTEGER NOT NULL, `messageType` INTEGER NOT NULL, `operateType` INTEGER NOT NULL, `messageParams` TEXT, `messageSeparator` TEXT, `familyId` INTEGER, `invitationUserId` INTEGER, `createFamilyUserNick` TEXT, PRIMARY KEY(`messageId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'd638b5e139cba0464e599036809c5ce4')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `FamilyBean`");
                _db.execSQL("DROP TABLE IF EXISTS `RoomBean`");
                _db.execSQL("DROP TABLE IF EXISTS `FamilyMemberBean`");
                _db.execSQL("DROP TABLE IF EXISTS `FamilyDeviceBean`");
                _db.execSQL("DROP TABLE IF EXISTS `MessageBean`");
                if (WeLifeDatabase_Impl.this.mCallbacks != null) {
                    int _size = WeLifeDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)WeLifeDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (WeLifeDatabase_Impl.this.mCallbacks != null) {
                    int _size = WeLifeDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)WeLifeDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                WeLifeDatabase_Impl.this.mDatabase = _db;
                WeLifeDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (WeLifeDatabase_Impl.this.mCallbacks != null) {
                    int _size = WeLifeDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)WeLifeDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsFamilyBean = new HashMap<String, TableInfo.Column>(8);
                _columnsFamilyBean.put("familyId", new TableInfo.Column("familyId", "INTEGER", true, 1, null, 1));
                _columnsFamilyBean.put("createUserId", new TableInfo.Column("createUserId", "INTEGER", true, 0, null, 1));
                _columnsFamilyBean.put("userId", new TableInfo.Column("userId", "INTEGER", true, 0, null, 1));
                _columnsFamilyBean.put("familyName", new TableInfo.Column("familyName", "TEXT", true, 0, null, 1));
                _columnsFamilyBean.put("roomCount", new TableInfo.Column("roomCount", "INTEGER", true, 0, null, 1));
                _columnsFamilyBean.put("deviceCount", new TableInfo.Column("deviceCount", "INTEGER", true, 0, null, 1));
                _columnsFamilyBean.put("defaultFamily", new TableInfo.Column("defaultFamily", "INTEGER", true, 0, null, 1));
                _columnsFamilyBean.put("createUserNick", new TableInfo.Column("createUserNick", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysFamilyBean = new HashSet(0);
                HashSet _indicesFamilyBean = new HashSet(0);
                TableInfo _infoFamilyBean = new TableInfo("FamilyBean", _columnsFamilyBean, _foreignKeysFamilyBean, _indicesFamilyBean);
                TableInfo _existingFamilyBean = TableInfo.read((SupportSQLiteDatabase)_db, (String)"FamilyBean");
                if (!_infoFamilyBean.equals((Object)_existingFamilyBean)) {
                    return new RoomOpenHelper.ValidationResult(false, "FamilyBean(com.smartlife.nebula.family.bean.FamilyBean).\n Expected:\n" + _infoFamilyBean + "\n Found:\n" + _existingFamilyBean);
                }
                HashMap<String, TableInfo.Column> _columnsRoomBean = new HashMap<String, TableInfo.Column>(4);
                _columnsRoomBean.put("familyId", new TableInfo.Column("familyId", "INTEGER", true, 1, null, 1));
                _columnsRoomBean.put("roomName", new TableInfo.Column("roomName", "TEXT", true, 2, null, 1));
                _columnsRoomBean.put("roomDeviceCount", new TableInfo.Column("roomDeviceCount", "INTEGER", true, 0, null, 1));
                _columnsRoomBean.put("insertTime", new TableInfo.Column("insertTime", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysRoomBean = new HashSet(0);
                HashSet _indicesRoomBean = new HashSet(0);
                TableInfo _infoRoomBean = new TableInfo("RoomBean", _columnsRoomBean, _foreignKeysRoomBean, _indicesRoomBean);
                TableInfo _existingRoomBean = TableInfo.read((SupportSQLiteDatabase)_db, (String)"RoomBean");
                if (!_infoRoomBean.equals((Object)_existingRoomBean)) {
                    return new RoomOpenHelper.ValidationResult(false, "RoomBean(com.smartlife.nebula.family.bean.RoomBean).\n Expected:\n" + _infoRoomBean + "\n Found:\n" + _existingRoomBean);
                }
                HashMap<String, TableInfo.Column> _columnsFamilyMemberBean = new HashMap<String, TableInfo.Column>(8);
                _columnsFamilyMemberBean.put("memberId", new TableInfo.Column("memberId", "INTEGER", true, 1, null, 1));
                _columnsFamilyMemberBean.put("familyId", new TableInfo.Column("familyId", "INTEGER", true, 2, null, 1));
                _columnsFamilyMemberBean.put("memberName", new TableInfo.Column("memberName", "TEXT", false, 0, null, 1));
                _columnsFamilyMemberBean.put("memberRule", new TableInfo.Column("memberRule", "INTEGER", true, 0, null, 1));
                _columnsFamilyMemberBean.put("memberIcon", new TableInfo.Column("memberIcon", "TEXT", false, 0, null, 1));
                _columnsFamilyMemberBean.put("memberJoinDate", new TableInfo.Column("memberJoinDate", "INTEGER", true, 0, null, 1));
                _columnsFamilyMemberBean.put("toBeGreed", new TableInfo.Column("toBeGreed", "INTEGER", true, 0, null, 1));
                _columnsFamilyMemberBean.put("owner", new TableInfo.Column("owner", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysFamilyMemberBean = new HashSet(0);
                HashSet _indicesFamilyMemberBean = new HashSet(0);
                TableInfo _infoFamilyMemberBean = new TableInfo("FamilyMemberBean", _columnsFamilyMemberBean, _foreignKeysFamilyMemberBean, _indicesFamilyMemberBean);
                TableInfo _existingFamilyMemberBean = TableInfo.read((SupportSQLiteDatabase)_db, (String)"FamilyMemberBean");
                if (!_infoFamilyMemberBean.equals((Object)_existingFamilyMemberBean)) {
                    return new RoomOpenHelper.ValidationResult(false, "FamilyMemberBean(com.smartlife.nebula.family.bean.FamilyMemberBean).\n Expected:\n" + _infoFamilyMemberBean + "\n Found:\n" + _existingFamilyMemberBean);
                }
                HashMap<String, TableInfo.Column> _columnsFamilyDeviceBean = new HashMap<String, TableInfo.Column>(12);
                _columnsFamilyDeviceBean.put("familyId", new TableInfo.Column("familyId", "INTEGER", true, 1, null, 1));
                _columnsFamilyDeviceBean.put("pid", new TableInfo.Column("pid", "TEXT", true, 0, null, 1));
                _columnsFamilyDeviceBean.put("did", new TableInfo.Column("did", "TEXT", true, 0, null, 1));
                _columnsFamilyDeviceBean.put("deviceName", new TableInfo.Column("deviceName", "TEXT", true, 0, null, 1));
                _columnsFamilyDeviceBean.put("remoteUrl", new TableInfo.Column("remoteUrl", "TEXT", false, 0, null, 1));
                _columnsFamilyDeviceBean.put("localRes", new TableInfo.Column("localRes", "INTEGER", false, 0, null, 1));
                _columnsFamilyDeviceBean.put("deviceRoom", new TableInfo.Column("deviceRoom", "TEXT", false, 0, null, 1));
                _columnsFamilyDeviceBean.put("applianceId", new TableInfo.Column("applianceId", "INTEGER", true, 2, null, 1));
                _columnsFamilyDeviceBean.put("deviceJoinTime", new TableInfo.Column("deviceJoinTime", "INTEGER", true, 0, null, 1));
                _columnsFamilyDeviceBean.put("onlineStatus", new TableInfo.Column("onlineStatus", "INTEGER", false, 0, null, 1));
                _columnsFamilyDeviceBean.put("curDevConnectNum", new TableInfo.Column("curDevConnectNum", "INTEGER", false, 0, null, 1));
                _columnsFamilyDeviceBean.put("mac", new TableInfo.Column("mac", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysFamilyDeviceBean = new HashSet(0);
                HashSet _indicesFamilyDeviceBean = new HashSet(0);
                TableInfo _infoFamilyDeviceBean = new TableInfo("FamilyDeviceBean", _columnsFamilyDeviceBean, _foreignKeysFamilyDeviceBean, _indicesFamilyDeviceBean);
                TableInfo _existingFamilyDeviceBean = TableInfo.read((SupportSQLiteDatabase)_db, (String)"FamilyDeviceBean");
                if (!_infoFamilyDeviceBean.equals((Object)_existingFamilyDeviceBean)) {
                    return new RoomOpenHelper.ValidationResult(false, "FamilyDeviceBean(com.smartlife.nebula.family.bean.FamilyDeviceBean).\n Expected:\n" + _infoFamilyDeviceBean + "\n Found:\n" + _existingFamilyDeviceBean);
                }
                HashMap<String, TableInfo.Column> _columnsMessageBean = new HashMap<String, TableInfo.Column>(11);
                _columnsMessageBean.put("messageId", new TableInfo.Column("messageId", "INTEGER", true, 1, null, 1));
                _columnsMessageBean.put("userId", new TableInfo.Column("userId", "INTEGER", true, 0, null, 1));
                _columnsMessageBean.put("read", new TableInfo.Column("read", "INTEGER", true, 0, null, 1));
                _columnsMessageBean.put("createTime", new TableInfo.Column("createTime", "INTEGER", true, 0, null, 1));
                _columnsMessageBean.put("messageType", new TableInfo.Column("messageType", "INTEGER", true, 0, null, 1));
                _columnsMessageBean.put("operateType", new TableInfo.Column("operateType", "INTEGER", true, 0, null, 1));
                _columnsMessageBean.put("messageParams", new TableInfo.Column("messageParams", "TEXT", false, 0, null, 1));
                _columnsMessageBean.put("messageSeparator", new TableInfo.Column("messageSeparator", "TEXT", false, 0, null, 1));
                _columnsMessageBean.put("familyId", new TableInfo.Column("familyId", "INTEGER", false, 0, null, 1));
                _columnsMessageBean.put("invitationUserId", new TableInfo.Column("invitationUserId", "INTEGER", false, 0, null, 1));
                _columnsMessageBean.put("createFamilyUserNick", new TableInfo.Column("createFamilyUserNick", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysMessageBean = new HashSet(0);
                HashSet _indicesMessageBean = new HashSet(0);
                TableInfo _infoMessageBean = new TableInfo("MessageBean", _columnsMessageBean, _foreignKeysMessageBean, _indicesMessageBean);
                TableInfo _existingMessageBean = TableInfo.read((SupportSQLiteDatabase)_db, (String)"MessageBean");
                if (!_infoMessageBean.equals((Object)_existingMessageBean)) {
                    return new RoomOpenHelper.ValidationResult(false, "MessageBean(com.smartlife.nebula.family.bean.MessageBean).\n Expected:\n" + _infoMessageBean + "\n Found:\n" + _existingMessageBean);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "d638b5e139cba0464e599036809c5ce4", "1015514832b5599acf873bfeed7f66ee");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"FamilyBean", "RoomBean", "FamilyMemberBean", "FamilyDeviceBean", "MessageBean"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `FamilyBean`");
            _db.execSQL("DELETE FROM `RoomBean`");
            _db.execSQL("DELETE FROM `FamilyMemberBean`");
            _db.execSQL("DELETE FROM `FamilyDeviceBean`");
            _db.execSQL("DELETE FROM `MessageBean`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(FamilyDao.class, FamilyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(RoomDao.class, RoomDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(FamilyMemberDao.class, FamilyMemberDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(FamilyDeviceDao.class, FamilyDeviceDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(MessageDao.class, MessageDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyDao FamilyDao() {
        if (this._familyDao != null) {
            return this._familyDao;
        }
        WeLifeDatabase_Impl weLifeDatabase_Impl = this;
        synchronized (weLifeDatabase_Impl) {
            if (this._familyDao == null) {
                this._familyDao = new FamilyDao_Impl(this);
            }
            return this._familyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoomDao RoomDao() {
        if (this._roomDao != null) {
            return this._roomDao;
        }
        WeLifeDatabase_Impl weLifeDatabase_Impl = this;
        synchronized (weLifeDatabase_Impl) {
            if (this._roomDao == null) {
                this._roomDao = new RoomDao_Impl(this);
            }
            return this._roomDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyMemberDao FamilyMemberDao() {
        if (this._familyMemberDao != null) {
            return this._familyMemberDao;
        }
        WeLifeDatabase_Impl weLifeDatabase_Impl = this;
        synchronized (weLifeDatabase_Impl) {
            if (this._familyMemberDao == null) {
                this._familyMemberDao = new FamilyMemberDao_Impl(this);
            }
            return this._familyMemberDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyDeviceDao FamilyDeviceDao() {
        if (this._familyDeviceDao != null) {
            return this._familyDeviceDao;
        }
        WeLifeDatabase_Impl weLifeDatabase_Impl = this;
        synchronized (weLifeDatabase_Impl) {
            if (this._familyDeviceDao == null) {
                this._familyDeviceDao = new FamilyDeviceDao_Impl(this);
            }
            return this._familyDeviceDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDao MessageDao() {
        if (this._messageDao != null) {
            return this._messageDao;
        }
        WeLifeDatabase_Impl weLifeDatabase_Impl = this;
        synchronized (weLifeDatabase_Impl) {
            if (this._messageDao == null) {
                this._messageDao = new MessageDao_Impl(this);
            }
            return this._messageDao;
        }
    }
}

