/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.family.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.smartlife.nebula.family.bean.FamilyBean;
import com.smartlife.nebula.family.db.dao.FamilyDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class FamilyDao_Impl
implements FamilyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FamilyBean> __insertionAdapterOfFamilyBean;
    private final EntityDeletionOrUpdateAdapter<FamilyBean> __deletionAdapterOfFamilyBean;
    private final EntityDeletionOrUpdateAdapter<FamilyBean> __updateAdapterOfFamilyBean;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFamilyUserNick;

    public FamilyDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFamilyBean = new EntityInsertionAdapter<FamilyBean>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `FamilyBean` (`familyId`,`createUserId`,`userId`,`familyName`,`roomCount`,`deviceCount`,`defaultFamily`,`createUserNick`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyBean value) {
                stmt.bindLong(1, value.getFamilyId());
                stmt.bindLong(2, value.getCreateUserId());
                stmt.bindLong(3, value.getUserId());
                if (value.getFamilyName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFamilyName());
                }
                stmt.bindLong(5, (long)value.getRoomCount());
                stmt.bindLong(6, (long)value.getDeviceCount());
                int _tmp = value.getDefaultFamily() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp);
                if (value.getCreateUserNick() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCreateUserNick());
                }
            }
        };
        this.__deletionAdapterOfFamilyBean = new EntityDeletionOrUpdateAdapter<FamilyBean>(__db){

            public String createQuery() {
                return "DELETE FROM `FamilyBean` WHERE `familyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyBean value) {
                stmt.bindLong(1, value.getFamilyId());
            }
        };
        this.__updateAdapterOfFamilyBean = new EntityDeletionOrUpdateAdapter<FamilyBean>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `FamilyBean` SET `familyId` = ?,`createUserId` = ?,`userId` = ?,`familyName` = ?,`roomCount` = ?,`deviceCount` = ?,`defaultFamily` = ?,`createUserNick` = ? WHERE `familyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyBean value) {
                stmt.bindLong(1, value.getFamilyId());
                stmt.bindLong(2, value.getCreateUserId());
                stmt.bindLong(3, value.getUserId());
                if (value.getFamilyName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFamilyName());
                }
                stmt.bindLong(5, (long)value.getRoomCount());
                stmt.bindLong(6, (long)value.getDeviceCount());
                int _tmp = value.getDefaultFamily() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp);
                if (value.getCreateUserNick() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCreateUserNick());
                }
                stmt.bindLong(9, value.getFamilyId());
            }
        };
        this.__preparedStmtOfUpdateFamilyUserNick = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE familybean SET createUserNick = ? WHERE familyId = ?";
                return "UPDATE familybean SET createUserNick = ? WHERE familyId = ?";
            }
        };
    }

    @Override
    public void insertFamily(FamilyBean familyBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFamilyBean.insert((Object)familyBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteFamily(FamilyBean familyBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFamilyBean.handle((Object)familyBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteFamilyList(List<FamilyBean> familyBeanList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFamilyBean.handleMultiple(familyBeanList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateFamily(FamilyBean familyBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfFamilyBean.handle((Object)familyBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFamilyUserNick(String createUserNick, long familyId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFamilyUserNick.acquire();
        int _argIndex = 1;
        if (createUserNick == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, createUserNick);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, familyId);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFamilyUserNick.release(_stmt);
        }
    }

    @Override
    public LiveData<List<FamilyBean>> queryAllLD() {
        String _sql = "SELECT `familybean`.`familyId` AS `familyId`, `familybean`.`createUserId` AS `createUserId`, `familybean`.`userId` AS `userId`, `familybean`.`familyName` AS `familyName`, `familybean`.`roomCount` AS `roomCount`, `familybean`.`deviceCount` AS `deviceCount`, `familybean`.`defaultFamily` AS `defaultFamily`, `familybean`.`createUserNick` AS `createUserNick` FROM familybean";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT `familybean`.`familyId` AS `familyId`, `familybean`.`createUserId` AS `createUserId`, `familybean`.`userId` AS `userId`, `familybean`.`familyName` AS `familyName`, `familybean`.`roomCount` AS `roomCount`, `familybean`.`deviceCount` AS `deviceCount`, `familybean`.`defaultFamily` AS `defaultFamily`, `familybean`.`createUserNick` AS `createUserNick` FROM familybean", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"familybean"}, false, (Callable)new Callable<List<FamilyBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FamilyBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FamilyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfCreateUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFamilyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyName");
                    int _cursorIndexOfRoomCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomCount");
                    int _cursorIndexOfDeviceCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceCount");
                    int _cursorIndexOfDefaultFamily = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultFamily");
                    int _cursorIndexOfCreateUserNick = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserNick");
                    ArrayList<FamilyBean> _result = new ArrayList<FamilyBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        FamilyBean _item = new FamilyBean();
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        _item.setFamilyId(_tmpFamilyId);
                        long _tmpCreateUserId = _cursor.getLong(_cursorIndexOfCreateUserId);
                        _item.setCreateUserId(_tmpCreateUserId);
                        long _tmpUserId = _cursor.getLong(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpFamilyName = _cursor.isNull(_cursorIndexOfFamilyName) ? null : _cursor.getString(_cursorIndexOfFamilyName);
                        _item.setFamilyName(_tmpFamilyName);
                        int _tmpRoomCount = _cursor.getInt(_cursorIndexOfRoomCount);
                        _item.setRoomCount(_tmpRoomCount);
                        int _tmpDeviceCount = _cursor.getInt(_cursorIndexOfDeviceCount);
                        _item.setDeviceCount(_tmpDeviceCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfDefaultFamily);
                        boolean _tmpDefaultFamily = _tmp != 0;
                        _item.setDefaultFamily(_tmpDefaultFamily);
                        String _tmpCreateUserNick = _cursor.isNull(_cursorIndexOfCreateUserNick) ? null : _cursor.getString(_cursorIndexOfCreateUserNick);
                        _item.setCreateUserNick(_tmpCreateUserNick);
                        _result.add(_item);
                    }
                    ArrayList<FamilyBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<FamilyBean>> queryAllByUidLD(long userId) {
        String _sql = "SELECT * FROM familybean WHERE userId = ? ORDER BY defaultFamily desc,familyId";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familybean WHERE userId = ? ORDER BY defaultFamily desc,familyId", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, userId);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"familybean"}, false, (Callable)new Callable<List<FamilyBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FamilyBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FamilyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfCreateUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFamilyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyName");
                    int _cursorIndexOfRoomCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomCount");
                    int _cursorIndexOfDeviceCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceCount");
                    int _cursorIndexOfDefaultFamily = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultFamily");
                    int _cursorIndexOfCreateUserNick = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserNick");
                    ArrayList<FamilyBean> _result = new ArrayList<FamilyBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        FamilyBean _item = new FamilyBean();
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        _item.setFamilyId(_tmpFamilyId);
                        long _tmpCreateUserId = _cursor.getLong(_cursorIndexOfCreateUserId);
                        _item.setCreateUserId(_tmpCreateUserId);
                        long _tmpUserId = _cursor.getLong(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpFamilyName = _cursor.isNull(_cursorIndexOfFamilyName) ? null : _cursor.getString(_cursorIndexOfFamilyName);
                        _item.setFamilyName(_tmpFamilyName);
                        int _tmpRoomCount = _cursor.getInt(_cursorIndexOfRoomCount);
                        _item.setRoomCount(_tmpRoomCount);
                        int _tmpDeviceCount = _cursor.getInt(_cursorIndexOfDeviceCount);
                        _item.setDeviceCount(_tmpDeviceCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfDefaultFamily);
                        boolean _tmpDefaultFamily = _tmp != 0;
                        _item.setDefaultFamily(_tmpDefaultFamily);
                        String _tmpCreateUserNick = _cursor.isNull(_cursorIndexOfCreateUserNick) ? null : _cursor.getString(_cursorIndexOfCreateUserNick);
                        _item.setCreateUserNick(_tmpCreateUserNick);
                        _result.add(_item);
                    }
                    ArrayList<FamilyBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyBean querySingeFamily(long userId, long familyId) {
        String _sql = "SELECT * FROM familybean WHERE userId = ? and familyId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familybean WHERE userId = ? and familyId = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, userId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, familyId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FamilyBean _result;
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfCreateUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfFamilyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyName");
            int _cursorIndexOfRoomCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomCount");
            int _cursorIndexOfDeviceCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceCount");
            int _cursorIndexOfDefaultFamily = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultFamily");
            int _cursorIndexOfCreateUserNick = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserNick");
            if (_cursor.moveToFirst()) {
                _result = new FamilyBean();
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                _result.setFamilyId(_tmpFamilyId);
                long _tmpCreateUserId = _cursor.getLong(_cursorIndexOfCreateUserId);
                _result.setCreateUserId(_tmpCreateUserId);
                long _tmpUserId = _cursor.getLong(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpFamilyName = _cursor.isNull(_cursorIndexOfFamilyName) ? null : _cursor.getString(_cursorIndexOfFamilyName);
                _result.setFamilyName(_tmpFamilyName);
                int _tmpRoomCount = _cursor.getInt(_cursorIndexOfRoomCount);
                _result.setRoomCount(_tmpRoomCount);
                int _tmpDeviceCount = _cursor.getInt(_cursorIndexOfDeviceCount);
                _result.setDeviceCount(_tmpDeviceCount);
                int _tmp = _cursor.getInt(_cursorIndexOfDefaultFamily);
                boolean _tmpDefaultFamily = _tmp != 0;
                _result.setDefaultFamily(_tmpDefaultFamily);
                String _tmpCreateUserNick = _cursor.isNull(_cursorIndexOfCreateUserNick) ? null : _cursor.getString(_cursorIndexOfCreateUserNick);
                _result.setCreateUserNick(_tmpCreateUserNick);
            } else {
                _result = null;
            }
            FamilyBean familyBean = _result;
            return familyBean;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FamilyBean> queryAllById(long userId) {
        String _sql = "SELECT * FROM familybean WHERE userId = ? ORDER BY defaultFamily desc,familyId";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familybean WHERE userId = ? ORDER BY defaultFamily desc,familyId", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, userId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfCreateUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfFamilyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyName");
            int _cursorIndexOfRoomCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomCount");
            int _cursorIndexOfDeviceCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceCount");
            int _cursorIndexOfDefaultFamily = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultFamily");
            int _cursorIndexOfCreateUserNick = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createUserNick");
            ArrayList<FamilyBean> _result = new ArrayList<FamilyBean>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                FamilyBean _item = new FamilyBean();
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                _item.setFamilyId(_tmpFamilyId);
                long _tmpCreateUserId = _cursor.getLong(_cursorIndexOfCreateUserId);
                _item.setCreateUserId(_tmpCreateUserId);
                long _tmpUserId = _cursor.getLong(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpFamilyName = _cursor.isNull(_cursorIndexOfFamilyName) ? null : _cursor.getString(_cursorIndexOfFamilyName);
                _item.setFamilyName(_tmpFamilyName);
                int _tmpRoomCount = _cursor.getInt(_cursorIndexOfRoomCount);
                _item.setRoomCount(_tmpRoomCount);
                int _tmpDeviceCount = _cursor.getInt(_cursorIndexOfDeviceCount);
                _item.setDeviceCount(_tmpDeviceCount);
                int _tmp = _cursor.getInt(_cursorIndexOfDefaultFamily);
                boolean _tmpDefaultFamily = _tmp != 0;
                _item.setDefaultFamily(_tmpDefaultFamily);
                String _tmpCreateUserNick = _cursor.isNull(_cursorIndexOfCreateUserNick) ? null : _cursor.getString(_cursorIndexOfCreateUserNick);
                _item.setCreateUserNick(_tmpCreateUserNick);
                _result.add(_item);
            }
            ArrayList<FamilyBean> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

