/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.family.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.smartlife.nebula.family.bean.FamilyDeviceBean;
import com.smartlife.nebula.family.db.dao.FamilyDeviceDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class FamilyDeviceDao_Impl
implements FamilyDeviceDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FamilyDeviceBean> __insertionAdapterOfFamilyDeviceBean;
    private final EntityDeletionOrUpdateAdapter<FamilyDeviceBean> __deletionAdapterOfFamilyDeviceBean;
    private final EntityDeletionOrUpdateAdapter<FamilyDeviceBean> __updateAdapterOfFamilyDeviceBean;

    public FamilyDeviceDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFamilyDeviceBean = new EntityInsertionAdapter<FamilyDeviceBean>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `FamilyDeviceBean` (`familyId`,`pid`,`did`,`deviceName`,`remoteUrl`,`localRes`,`deviceRoom`,`applianceId`,`deviceJoinTime`,`onlineStatus`,`curDevConnectNum`,`mac`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyDeviceBean value) {
                Integer _tmp;
                stmt.bindLong(1, value.getFamilyId());
                if (value.getPid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPid());
                }
                if (value.getDid() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDid());
                }
                if (value.getDeviceName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDeviceName());
                }
                if (value.getRemoteUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getRemoteUrl());
                }
                if (value.getLocalRes() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)value.getLocalRes().intValue());
                }
                if (value.getDeviceRoom() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDeviceRoom());
                }
                stmt.bindLong(8, value.getApplianceId());
                stmt.bindLong(9, value.getDeviceJoinTime());
                Integer n = value.getOnlineStatus() == null ? null : (_tmp = Integer.valueOf(value.getOnlineStatus() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp.intValue());
                }
                if (value.getCurDevConnectNum() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)value.getCurDevConnectNum().intValue());
                }
                if (value.getMac() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getMac());
                }
            }
        };
        this.__deletionAdapterOfFamilyDeviceBean = new EntityDeletionOrUpdateAdapter<FamilyDeviceBean>(__db){

            public String createQuery() {
                return "DELETE FROM `FamilyDeviceBean` WHERE `familyId` = ? AND `applianceId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyDeviceBean value) {
                stmt.bindLong(1, value.getFamilyId());
                stmt.bindLong(2, value.getApplianceId());
            }
        };
        this.__updateAdapterOfFamilyDeviceBean = new EntityDeletionOrUpdateAdapter<FamilyDeviceBean>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `FamilyDeviceBean` SET `familyId` = ?,`pid` = ?,`did` = ?,`deviceName` = ?,`remoteUrl` = ?,`localRes` = ?,`deviceRoom` = ?,`applianceId` = ?,`deviceJoinTime` = ?,`onlineStatus` = ?,`curDevConnectNum` = ?,`mac` = ? WHERE `familyId` = ? AND `applianceId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyDeviceBean value) {
                Integer _tmp;
                stmt.bindLong(1, value.getFamilyId());
                if (value.getPid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPid());
                }
                if (value.getDid() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDid());
                }
                if (value.getDeviceName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDeviceName());
                }
                if (value.getRemoteUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getRemoteUrl());
                }
                if (value.getLocalRes() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)value.getLocalRes().intValue());
                }
                if (value.getDeviceRoom() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDeviceRoom());
                }
                stmt.bindLong(8, value.getApplianceId());
                stmt.bindLong(9, value.getDeviceJoinTime());
                Integer n = value.getOnlineStatus() == null ? null : (_tmp = Integer.valueOf(value.getOnlineStatus() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp.intValue());
                }
                if (value.getCurDevConnectNum() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)value.getCurDevConnectNum().intValue());
                }
                if (value.getMac() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getMac());
                }
                stmt.bindLong(13, value.getFamilyId());
                stmt.bindLong(14, value.getApplianceId());
            }
        };
    }

    @Override
    public void insertDevice(FamilyDeviceBean familyDeviceBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFamilyDeviceBean.insert((Object)familyDeviceBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteDevice(FamilyDeviceBean familyDeviceBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFamilyDeviceBean.handle((Object)familyDeviceBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteDevices(List<FamilyDeviceBean> deviceList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFamilyDeviceBean.handleMultiple(deviceList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateDevice(FamilyDeviceBean familyDeviceBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfFamilyDeviceBean.handle((Object)familyDeviceBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<FamilyDeviceBean>> queryAllByIdLD(long familyId) {
        String _sql = "SELECT * FROM familydevicebean WHERE familyId = ? ORDER BY deviceJoinTime";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familydevicebean WHERE familyId = ? ORDER BY deviceJoinTime", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"familydevicebean"}, false, (Callable)new Callable<List<FamilyDeviceBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FamilyDeviceBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FamilyDeviceDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfDid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"did");
                    int _cursorIndexOfDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceName");
                    int _cursorIndexOfRemoteUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteUrl");
                    int _cursorIndexOfLocalRes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localRes");
                    int _cursorIndexOfDeviceRoom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceRoom");
                    int _cursorIndexOfApplianceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applianceId");
                    int _cursorIndexOfDeviceJoinTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceJoinTime");
                    int _cursorIndexOfOnlineStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlineStatus");
                    int _cursorIndexOfCurDevConnectNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"curDevConnectNum");
                    int _cursorIndexOfMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mac");
                    ArrayList<FamilyDeviceBean> _result = new ArrayList<FamilyDeviceBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        FamilyDeviceBean _item = new FamilyDeviceBean();
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        _item.setFamilyId(_tmpFamilyId);
                        String _tmpPid = _cursor.isNull(_cursorIndexOfPid) ? null : _cursor.getString(_cursorIndexOfPid);
                        _item.setPid(_tmpPid);
                        String _tmpDid = _cursor.isNull(_cursorIndexOfDid) ? null : _cursor.getString(_cursorIndexOfDid);
                        _item.setDid(_tmpDid);
                        String _tmpDeviceName = _cursor.isNull(_cursorIndexOfDeviceName) ? null : _cursor.getString(_cursorIndexOfDeviceName);
                        _item.setDeviceName(_tmpDeviceName);
                        String _tmpRemoteUrl = _cursor.isNull(_cursorIndexOfRemoteUrl) ? null : _cursor.getString(_cursorIndexOfRemoteUrl);
                        _item.setRemoteUrl(_tmpRemoteUrl);
                        Integer _tmpLocalRes = _cursor.isNull(_cursorIndexOfLocalRes) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLocalRes));
                        _item.setLocalRes(_tmpLocalRes);
                        String _tmpDeviceRoom = _cursor.isNull(_cursorIndexOfDeviceRoom) ? null : _cursor.getString(_cursorIndexOfDeviceRoom);
                        _item.setDeviceRoom(_tmpDeviceRoom);
                        long _tmpApplianceId = _cursor.getLong(_cursorIndexOfApplianceId);
                        _item.setApplianceId(_tmpApplianceId);
                        long _tmpDeviceJoinTime = _cursor.getLong(_cursorIndexOfDeviceJoinTime);
                        _item.setDeviceJoinTime(_tmpDeviceJoinTime);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfOnlineStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlineStatus));
                        Boolean _tmpOnlineStatus = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        _item.setOnlineStatus(_tmpOnlineStatus);
                        Integer _tmpCurDevConnectNum = _cursor.isNull(_cursorIndexOfCurDevConnectNum) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCurDevConnectNum));
                        _item.setCurDevConnectNum(_tmpCurDevConnectNum);
                        String _tmpMac = _cursor.isNull(_cursorIndexOfMac) ? null : _cursor.getString(_cursorIndexOfMac);
                        _item.setMac(_tmpMac);
                        _result.add(_item);
                    }
                    ArrayList<FamilyDeviceBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyDeviceBean querySingleDevice(long familyId, String did) {
        String _sql = "SELECT * FROM familydevicebean WHERE familyId = ? And did = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familydevicebean WHERE familyId = ? And did = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        _argIndex = 2;
        if (did == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, did);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FamilyDeviceBean _result;
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfDid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"did");
            int _cursorIndexOfDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceName");
            int _cursorIndexOfRemoteUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteUrl");
            int _cursorIndexOfLocalRes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localRes");
            int _cursorIndexOfDeviceRoom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceRoom");
            int _cursorIndexOfApplianceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applianceId");
            int _cursorIndexOfDeviceJoinTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceJoinTime");
            int _cursorIndexOfOnlineStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlineStatus");
            int _cursorIndexOfCurDevConnectNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"curDevConnectNum");
            int _cursorIndexOfMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mac");
            if (_cursor.moveToFirst()) {
                _result = new FamilyDeviceBean();
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                _result.setFamilyId(_tmpFamilyId);
                String _tmpPid = _cursor.isNull(_cursorIndexOfPid) ? null : _cursor.getString(_cursorIndexOfPid);
                _result.setPid(_tmpPid);
                String _tmpDid = _cursor.isNull(_cursorIndexOfDid) ? null : _cursor.getString(_cursorIndexOfDid);
                _result.setDid(_tmpDid);
                String _tmpDeviceName = _cursor.isNull(_cursorIndexOfDeviceName) ? null : _cursor.getString(_cursorIndexOfDeviceName);
                _result.setDeviceName(_tmpDeviceName);
                String _tmpRemoteUrl = _cursor.isNull(_cursorIndexOfRemoteUrl) ? null : _cursor.getString(_cursorIndexOfRemoteUrl);
                _result.setRemoteUrl(_tmpRemoteUrl);
                Integer _tmpLocalRes = _cursor.isNull(_cursorIndexOfLocalRes) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLocalRes));
                _result.setLocalRes(_tmpLocalRes);
                String _tmpDeviceRoom = _cursor.isNull(_cursorIndexOfDeviceRoom) ? null : _cursor.getString(_cursorIndexOfDeviceRoom);
                _result.setDeviceRoom(_tmpDeviceRoom);
                long _tmpApplianceId = _cursor.getLong(_cursorIndexOfApplianceId);
                _result.setApplianceId(_tmpApplianceId);
                long _tmpDeviceJoinTime = _cursor.getLong(_cursorIndexOfDeviceJoinTime);
                _result.setDeviceJoinTime(_tmpDeviceJoinTime);
                Integer _tmp = _cursor.isNull(_cursorIndexOfOnlineStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlineStatus));
                Boolean _tmpOnlineStatus = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _result.setOnlineStatus(_tmpOnlineStatus);
                Integer _tmpCurDevConnectNum = _cursor.isNull(_cursorIndexOfCurDevConnectNum) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCurDevConnectNum));
                _result.setCurDevConnectNum(_tmpCurDevConnectNum);
                String _tmpMac = _cursor.isNull(_cursorIndexOfMac) ? null : _cursor.getString(_cursorIndexOfMac);
                _result.setMac(_tmpMac);
            } else {
                _result = null;
            }
            FamilyDeviceBean familyDeviceBean = _result;
            return familyDeviceBean;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<FamilyDeviceBean>> queryRoomDeviceLD(long familyId, String deviceRoom) {
        String _sql = "SELECT * FROM familydevicebean WHERE familyId = ? AND deviceRoom = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familydevicebean WHERE familyId = ? AND deviceRoom = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        _argIndex = 2;
        if (deviceRoom == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, deviceRoom);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"familydevicebean"}, false, (Callable)new Callable<List<FamilyDeviceBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FamilyDeviceBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FamilyDeviceDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfDid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"did");
                    int _cursorIndexOfDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceName");
                    int _cursorIndexOfRemoteUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteUrl");
                    int _cursorIndexOfLocalRes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localRes");
                    int _cursorIndexOfDeviceRoom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceRoom");
                    int _cursorIndexOfApplianceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applianceId");
                    int _cursorIndexOfDeviceJoinTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceJoinTime");
                    int _cursorIndexOfOnlineStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlineStatus");
                    int _cursorIndexOfCurDevConnectNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"curDevConnectNum");
                    int _cursorIndexOfMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mac");
                    ArrayList<FamilyDeviceBean> _result = new ArrayList<FamilyDeviceBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        FamilyDeviceBean _item = new FamilyDeviceBean();
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        _item.setFamilyId(_tmpFamilyId);
                        String _tmpPid = _cursor.isNull(_cursorIndexOfPid) ? null : _cursor.getString(_cursorIndexOfPid);
                        _item.setPid(_tmpPid);
                        String _tmpDid = _cursor.isNull(_cursorIndexOfDid) ? null : _cursor.getString(_cursorIndexOfDid);
                        _item.setDid(_tmpDid);
                        String _tmpDeviceName = _cursor.isNull(_cursorIndexOfDeviceName) ? null : _cursor.getString(_cursorIndexOfDeviceName);
                        _item.setDeviceName(_tmpDeviceName);
                        String _tmpRemoteUrl = _cursor.isNull(_cursorIndexOfRemoteUrl) ? null : _cursor.getString(_cursorIndexOfRemoteUrl);
                        _item.setRemoteUrl(_tmpRemoteUrl);
                        Integer _tmpLocalRes = _cursor.isNull(_cursorIndexOfLocalRes) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLocalRes));
                        _item.setLocalRes(_tmpLocalRes);
                        String _tmpDeviceRoom = _cursor.isNull(_cursorIndexOfDeviceRoom) ? null : _cursor.getString(_cursorIndexOfDeviceRoom);
                        _item.setDeviceRoom(_tmpDeviceRoom);
                        long _tmpApplianceId = _cursor.getLong(_cursorIndexOfApplianceId);
                        _item.setApplianceId(_tmpApplianceId);
                        long _tmpDeviceJoinTime = _cursor.getLong(_cursorIndexOfDeviceJoinTime);
                        _item.setDeviceJoinTime(_tmpDeviceJoinTime);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfOnlineStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlineStatus));
                        Boolean _tmpOnlineStatus = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        _item.setOnlineStatus(_tmpOnlineStatus);
                        Integer _tmpCurDevConnectNum = _cursor.isNull(_cursorIndexOfCurDevConnectNum) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCurDevConnectNum));
                        _item.setCurDevConnectNum(_tmpCurDevConnectNum);
                        String _tmpMac = _cursor.isNull(_cursorIndexOfMac) ? null : _cursor.getString(_cursorIndexOfMac);
                        _item.setMac(_tmpMac);
                        _result.add(_item);
                    }
                    ArrayList<FamilyDeviceBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FamilyDeviceBean> queryAllById(long familyId) {
        String _sql = "SELECT * FROM familydevicebean WHERE familyId = ? ORDER BY deviceJoinTime";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familydevicebean WHERE familyId = ? ORDER BY deviceJoinTime", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfDid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"did");
            int _cursorIndexOfDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceName");
            int _cursorIndexOfRemoteUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteUrl");
            int _cursorIndexOfLocalRes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localRes");
            int _cursorIndexOfDeviceRoom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceRoom");
            int _cursorIndexOfApplianceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applianceId");
            int _cursorIndexOfDeviceJoinTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceJoinTime");
            int _cursorIndexOfOnlineStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlineStatus");
            int _cursorIndexOfCurDevConnectNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"curDevConnectNum");
            int _cursorIndexOfMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mac");
            ArrayList<FamilyDeviceBean> _result = new ArrayList<FamilyDeviceBean>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                FamilyDeviceBean _item = new FamilyDeviceBean();
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                _item.setFamilyId(_tmpFamilyId);
                String _tmpPid = _cursor.isNull(_cursorIndexOfPid) ? null : _cursor.getString(_cursorIndexOfPid);
                _item.setPid(_tmpPid);
                String _tmpDid = _cursor.isNull(_cursorIndexOfDid) ? null : _cursor.getString(_cursorIndexOfDid);
                _item.setDid(_tmpDid);
                String _tmpDeviceName = _cursor.isNull(_cursorIndexOfDeviceName) ? null : _cursor.getString(_cursorIndexOfDeviceName);
                _item.setDeviceName(_tmpDeviceName);
                String _tmpRemoteUrl = _cursor.isNull(_cursorIndexOfRemoteUrl) ? null : _cursor.getString(_cursorIndexOfRemoteUrl);
                _item.setRemoteUrl(_tmpRemoteUrl);
                Integer _tmpLocalRes = _cursor.isNull(_cursorIndexOfLocalRes) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLocalRes));
                _item.setLocalRes(_tmpLocalRes);
                String _tmpDeviceRoom = _cursor.isNull(_cursorIndexOfDeviceRoom) ? null : _cursor.getString(_cursorIndexOfDeviceRoom);
                _item.setDeviceRoom(_tmpDeviceRoom);
                long _tmpApplianceId = _cursor.getLong(_cursorIndexOfApplianceId);
                _item.setApplianceId(_tmpApplianceId);
                long _tmpDeviceJoinTime = _cursor.getLong(_cursorIndexOfDeviceJoinTime);
                _item.setDeviceJoinTime(_tmpDeviceJoinTime);
                Integer _tmp = _cursor.isNull(_cursorIndexOfOnlineStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlineStatus));
                Boolean _tmpOnlineStatus = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _item.setOnlineStatus(_tmpOnlineStatus);
                Integer _tmpCurDevConnectNum = _cursor.isNull(_cursorIndexOfCurDevConnectNum) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCurDevConnectNum));
                _item.setCurDevConnectNum(_tmpCurDevConnectNum);
                String _tmpMac = _cursor.isNull(_cursorIndexOfMac) ? null : _cursor.getString(_cursorIndexOfMac);
                _item.setMac(_tmpMac);
                _result.add(_item);
            }
            ArrayList<FamilyDeviceBean> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyDeviceBean queryDeviceByDid(String did) {
        String _sql = "SELECT * FROM familydevicebean WHERE did = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM familydevicebean WHERE did = ?", (int)1);
        int _argIndex = 1;
        if (did == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, did);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FamilyDeviceBean _result;
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfDid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"did");
            int _cursorIndexOfDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceName");
            int _cursorIndexOfRemoteUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteUrl");
            int _cursorIndexOfLocalRes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localRes");
            int _cursorIndexOfDeviceRoom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceRoom");
            int _cursorIndexOfApplianceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applianceId");
            int _cursorIndexOfDeviceJoinTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceJoinTime");
            int _cursorIndexOfOnlineStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlineStatus");
            int _cursorIndexOfCurDevConnectNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"curDevConnectNum");
            int _cursorIndexOfMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mac");
            if (_cursor.moveToFirst()) {
                _result = new FamilyDeviceBean();
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                _result.setFamilyId(_tmpFamilyId);
                String _tmpPid = _cursor.isNull(_cursorIndexOfPid) ? null : _cursor.getString(_cursorIndexOfPid);
                _result.setPid(_tmpPid);
                String _tmpDid = _cursor.isNull(_cursorIndexOfDid) ? null : _cursor.getString(_cursorIndexOfDid);
                _result.setDid(_tmpDid);
                String _tmpDeviceName = _cursor.isNull(_cursorIndexOfDeviceName) ? null : _cursor.getString(_cursorIndexOfDeviceName);
                _result.setDeviceName(_tmpDeviceName);
                String _tmpRemoteUrl = _cursor.isNull(_cursorIndexOfRemoteUrl) ? null : _cursor.getString(_cursorIndexOfRemoteUrl);
                _result.setRemoteUrl(_tmpRemoteUrl);
                Integer _tmpLocalRes = _cursor.isNull(_cursorIndexOfLocalRes) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLocalRes));
                _result.setLocalRes(_tmpLocalRes);
                String _tmpDeviceRoom = _cursor.isNull(_cursorIndexOfDeviceRoom) ? null : _cursor.getString(_cursorIndexOfDeviceRoom);
                _result.setDeviceRoom(_tmpDeviceRoom);
                long _tmpApplianceId = _cursor.getLong(_cursorIndexOfApplianceId);
                _result.setApplianceId(_tmpApplianceId);
                long _tmpDeviceJoinTime = _cursor.getLong(_cursorIndexOfDeviceJoinTime);
                _result.setDeviceJoinTime(_tmpDeviceJoinTime);
                Integer _tmp = _cursor.isNull(_cursorIndexOfOnlineStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlineStatus));
                Boolean _tmpOnlineStatus = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _result.setOnlineStatus(_tmpOnlineStatus);
                Integer _tmpCurDevConnectNum = _cursor.isNull(_cursorIndexOfCurDevConnectNum) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCurDevConnectNum));
                _result.setCurDevConnectNum(_tmpCurDevConnectNum);
                String _tmpMac = _cursor.isNull(_cursorIndexOfMac) ? null : _cursor.getString(_cursorIndexOfMac);
                _result.setMac(_tmpMac);
            } else {
                _result = null;
            }
            FamilyDeviceBean familyDeviceBean = _result;
            return familyDeviceBean;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

