/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.family.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.smartlife.nebula.family.bean.FamilyMemberBean;
import com.smartlife.nebula.family.db.dao.FamilyMemberDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class FamilyMemberDao_Impl
implements FamilyMemberDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FamilyMemberBean> __insertionAdapterOfFamilyMemberBean;
    private final EntityDeletionOrUpdateAdapter<FamilyMemberBean> __deletionAdapterOfFamilyMemberBean;
    private final EntityDeletionOrUpdateAdapter<FamilyMemberBean> __updateAdapterOfFamilyMemberBean;

    public FamilyMemberDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFamilyMemberBean = new EntityInsertionAdapter<FamilyMemberBean>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `FamilyMemberBean` (`memberId`,`familyId`,`memberName`,`memberRule`,`memberIcon`,`memberJoinDate`,`toBeGreed`,`owner`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyMemberBean value) {
                stmt.bindLong(1, value.getMemberId());
                stmt.bindLong(2, value.getFamilyId());
                if (value.getMemberName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getMemberName());
                }
                stmt.bindLong(4, (long)value.getMemberRule());
                if (value.getMemberIcon() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMemberIcon());
                }
                stmt.bindLong(6, value.getMemberJoinDate());
                int _tmp = value.getToBeGreed() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp);
                int _tmp_1 = value.getOwner() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_1);
            }
        };
        this.__deletionAdapterOfFamilyMemberBean = new EntityDeletionOrUpdateAdapter<FamilyMemberBean>(__db){

            public String createQuery() {
                return "DELETE FROM `FamilyMemberBean` WHERE `memberId` = ? AND `familyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyMemberBean value) {
                stmt.bindLong(1, value.getMemberId());
                stmt.bindLong(2, value.getFamilyId());
            }
        };
        this.__updateAdapterOfFamilyMemberBean = new EntityDeletionOrUpdateAdapter<FamilyMemberBean>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `FamilyMemberBean` SET `memberId` = ?,`familyId` = ?,`memberName` = ?,`memberRule` = ?,`memberIcon` = ?,`memberJoinDate` = ?,`toBeGreed` = ?,`owner` = ? WHERE `memberId` = ? AND `familyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FamilyMemberBean value) {
                stmt.bindLong(1, value.getMemberId());
                stmt.bindLong(2, value.getFamilyId());
                if (value.getMemberName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getMemberName());
                }
                stmt.bindLong(4, (long)value.getMemberRule());
                if (value.getMemberIcon() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMemberIcon());
                }
                stmt.bindLong(6, value.getMemberJoinDate());
                int _tmp = value.getToBeGreed() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp);
                int _tmp_1 = value.getOwner() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_1);
                stmt.bindLong(9, value.getMemberId());
                stmt.bindLong(10, value.getFamilyId());
            }
        };
    }

    @Override
    public void insertMember(FamilyMemberBean familyMemberBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFamilyMemberBean.insert((Object)familyMemberBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteMember(FamilyMemberBean familyMemberBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFamilyMemberBean.handle((Object)familyMemberBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteMembers(List<FamilyMemberBean> familyMembers) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFamilyMemberBean.handleMultiple(familyMembers);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateMember(FamilyMemberBean familyMemberBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfFamilyMemberBean.handle((Object)familyMemberBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<FamilyMemberBean>> queryAllByIdLD(long familyId) {
        String _sql = "SELECT * FROM FamilyMemberBean WHERE familyId=?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FamilyMemberBean WHERE familyId=?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"FamilyMemberBean"}, false, (Callable)new Callable<List<FamilyMemberBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FamilyMemberBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FamilyMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberId");
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfMemberName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberName");
                    int _cursorIndexOfMemberRule = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberRule");
                    int _cursorIndexOfMemberIcon = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberIcon");
                    int _cursorIndexOfMemberJoinDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberJoinDate");
                    int _cursorIndexOfToBeGreed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toBeGreed");
                    int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"owner");
                    ArrayList<FamilyMemberBean> _result = new ArrayList<FamilyMemberBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpMemberId = _cursor.getLong(_cursorIndexOfMemberId);
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        String _tmpMemberName = _cursor.isNull(_cursorIndexOfMemberName) ? null : _cursor.getString(_cursorIndexOfMemberName);
                        int _tmpMemberRule = _cursor.getInt(_cursorIndexOfMemberRule);
                        String _tmpMemberIcon = _cursor.isNull(_cursorIndexOfMemberIcon) ? null : _cursor.getString(_cursorIndexOfMemberIcon);
                        long _tmpMemberJoinDate = _cursor.getLong(_cursorIndexOfMemberJoinDate);
                        int _tmp = _cursor.getInt(_cursorIndexOfToBeGreed);
                        boolean _tmpToBeGreed = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfOwner);
                        boolean _tmpOwner = _tmp_1 != 0;
                        FamilyMemberBean _item = new FamilyMemberBean(_tmpMemberId, _tmpFamilyId, _tmpMemberName, _tmpMemberRule, _tmpMemberIcon, _tmpMemberJoinDate, _tmpToBeGreed, _tmpOwner);
                        _result.add(_item);
                    }
                    ArrayList<FamilyMemberBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FamilyMemberBean> queryAllById(long familyId) {
        String _sql = "SELECT * FROM FamilyMemberBean WHERE familyId=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FamilyMemberBean WHERE familyId=?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberId");
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfMemberName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberName");
            int _cursorIndexOfMemberRule = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberRule");
            int _cursorIndexOfMemberIcon = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberIcon");
            int _cursorIndexOfMemberJoinDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberJoinDate");
            int _cursorIndexOfToBeGreed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toBeGreed");
            int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"owner");
            ArrayList<FamilyMemberBean> _result = new ArrayList<FamilyMemberBean>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpMemberId = _cursor.getLong(_cursorIndexOfMemberId);
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                String _tmpMemberName = _cursor.isNull(_cursorIndexOfMemberName) ? null : _cursor.getString(_cursorIndexOfMemberName);
                int _tmpMemberRule = _cursor.getInt(_cursorIndexOfMemberRule);
                String _tmpMemberIcon = _cursor.isNull(_cursorIndexOfMemberIcon) ? null : _cursor.getString(_cursorIndexOfMemberIcon);
                long _tmpMemberJoinDate = _cursor.getLong(_cursorIndexOfMemberJoinDate);
                int _tmp = _cursor.getInt(_cursorIndexOfToBeGreed);
                boolean _tmpToBeGreed = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfOwner);
                boolean _tmpOwner = _tmp_1 != 0;
                FamilyMemberBean _item = new FamilyMemberBean(_tmpMemberId, _tmpFamilyId, _tmpMemberName, _tmpMemberRule, _tmpMemberIcon, _tmpMemberJoinDate, _tmpToBeGreed, _tmpOwner);
                _result.add(_item);
            }
            ArrayList<FamilyMemberBean> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FamilyMemberBean querySingleMember(long familyId, long userId) {
        String _sql = "SELECT * FROM FamilyMemberBean WHERE familyId = ? AND memberId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FamilyMemberBean WHERE familyId = ? AND memberId = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, userId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FamilyMemberBean _result;
            int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberId");
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfMemberName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberName");
            int _cursorIndexOfMemberRule = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberRule");
            int _cursorIndexOfMemberIcon = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberIcon");
            int _cursorIndexOfMemberJoinDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberJoinDate");
            int _cursorIndexOfToBeGreed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toBeGreed");
            int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"owner");
            if (_cursor.moveToFirst()) {
                long _tmpMemberId = _cursor.getLong(_cursorIndexOfMemberId);
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                String _tmpMemberName = _cursor.isNull(_cursorIndexOfMemberName) ? null : _cursor.getString(_cursorIndexOfMemberName);
                int _tmpMemberRule = _cursor.getInt(_cursorIndexOfMemberRule);
                String _tmpMemberIcon = _cursor.isNull(_cursorIndexOfMemberIcon) ? null : _cursor.getString(_cursorIndexOfMemberIcon);
                long _tmpMemberJoinDate = _cursor.getLong(_cursorIndexOfMemberJoinDate);
                int _tmp = _cursor.getInt(_cursorIndexOfToBeGreed);
                boolean _tmpToBeGreed = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfOwner);
                boolean _tmpOwner = _tmp_1 != 0;
                _result = new FamilyMemberBean(_tmpMemberId, _tmpFamilyId, _tmpMemberName, _tmpMemberRule, _tmpMemberIcon, _tmpMemberJoinDate, _tmpToBeGreed, _tmpOwner);
            } else {
                _result = null;
            }
            FamilyMemberBean familyMemberBean = _result;
            return familyMemberBean;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<FamilyMemberBean> querySingleMemberLD(long familyId, long userId) {
        String _sql = "SELECT * FROM FamilyMemberBean WHERE familyId = ? AND memberId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FamilyMemberBean WHERE familyId = ? AND memberId = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, userId);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"FamilyMemberBean"}, false, (Callable)new Callable<FamilyMemberBean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FamilyMemberBean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FamilyMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    FamilyMemberBean _result;
                    int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberId");
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfMemberName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberName");
                    int _cursorIndexOfMemberRule = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberRule");
                    int _cursorIndexOfMemberIcon = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberIcon");
                    int _cursorIndexOfMemberJoinDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberJoinDate");
                    int _cursorIndexOfToBeGreed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toBeGreed");
                    int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"owner");
                    if (_cursor.moveToFirst()) {
                        long _tmpMemberId = _cursor.getLong(_cursorIndexOfMemberId);
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        String _tmpMemberName = _cursor.isNull(_cursorIndexOfMemberName) ? null : _cursor.getString(_cursorIndexOfMemberName);
                        int _tmpMemberRule = _cursor.getInt(_cursorIndexOfMemberRule);
                        String _tmpMemberIcon = _cursor.isNull(_cursorIndexOfMemberIcon) ? null : _cursor.getString(_cursorIndexOfMemberIcon);
                        long _tmpMemberJoinDate = _cursor.getLong(_cursorIndexOfMemberJoinDate);
                        int _tmp = _cursor.getInt(_cursorIndexOfToBeGreed);
                        boolean _tmpToBeGreed = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfOwner);
                        boolean _tmpOwner = _tmp_1 != 0;
                        _result = new FamilyMemberBean(_tmpMemberId, _tmpFamilyId, _tmpMemberName, _tmpMemberRule, _tmpMemberIcon, _tmpMemberJoinDate, _tmpToBeGreed, _tmpOwner);
                    } else {
                        _result = null;
                    }
                    FamilyMemberBean familyMemberBean = _result;
                    return familyMemberBean;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

