/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.family.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.smartlife.nebula.family.bean.MessageBean;
import com.smartlife.nebula.family.db.dao.MessageDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class MessageDao_Impl
implements MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessageBean> __insertionAdapterOfMessageBean;
    private final EntityDeletionOrUpdateAdapter<MessageBean> __deletionAdapterOfMessageBean;
    private final EntityDeletionOrUpdateAdapter<MessageBean> __updateAdapterOfMessageBean;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessageBean = new EntityInsertionAdapter<MessageBean>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `MessageBean` (`messageId`,`userId`,`read`,`createTime`,`messageType`,`operateType`,`messageParams`,`messageSeparator`,`familyId`,`invitationUserId`,`createFamilyUserNick`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessageBean value) {
                stmt.bindLong(1, value.getMessageId());
                stmt.bindLong(2, value.getUserId());
                int _tmp = value.getRead() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                stmt.bindLong(4, value.getCreateTime());
                stmt.bindLong(5, (long)value.getMessageType());
                stmt.bindLong(6, (long)value.getOperateType());
                if (value.getMessageParams() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMessageParams());
                }
                if (value.getMessageSeparator() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMessageSeparator());
                }
                if (value.getFamilyId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, value.getFamilyId().longValue());
                }
                if (value.getInvitationUserId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, value.getInvitationUserId().longValue());
                }
                if (value.getCreateFamilyUserNick() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getCreateFamilyUserNick());
                }
            }
        };
        this.__deletionAdapterOfMessageBean = new EntityDeletionOrUpdateAdapter<MessageBean>(__db){

            public String createQuery() {
                return "DELETE FROM `MessageBean` WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessageBean value) {
                stmt.bindLong(1, value.getMessageId());
            }
        };
        this.__updateAdapterOfMessageBean = new EntityDeletionOrUpdateAdapter<MessageBean>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `MessageBean` SET `messageId` = ?,`userId` = ?,`read` = ?,`createTime` = ?,`messageType` = ?,`operateType` = ?,`messageParams` = ?,`messageSeparator` = ?,`familyId` = ?,`invitationUserId` = ?,`createFamilyUserNick` = ? WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessageBean value) {
                stmt.bindLong(1, value.getMessageId());
                stmt.bindLong(2, value.getUserId());
                int _tmp = value.getRead() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                stmt.bindLong(4, value.getCreateTime());
                stmt.bindLong(5, (long)value.getMessageType());
                stmt.bindLong(6, (long)value.getOperateType());
                if (value.getMessageParams() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMessageParams());
                }
                if (value.getMessageSeparator() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMessageSeparator());
                }
                if (value.getFamilyId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, value.getFamilyId().longValue());
                }
                if (value.getInvitationUserId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, value.getInvitationUserId().longValue());
                }
                if (value.getCreateFamilyUserNick() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getCreateFamilyUserNick());
                }
                stmt.bindLong(12, value.getMessageId());
            }
        };
    }

    @Override
    public void insertMessage(MessageBean messageBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessageBean.insert((Object)messageBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertAll(MessageBean ... messageBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessageBean.insert((Object[])messageBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteMessage(MessageBean messageBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessageBean.handle((Object)messageBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll(MessageBean ... messageBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessageBean.handleMultiple((Object[])messageBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateMessage(MessageBean messageBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMessageBean.handle((Object)messageBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateAll(MessageBean ... messageBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMessageBean.handleMultiple((Object[])messageBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateMessages(List<MessageBean> messages) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMessageBean.handleMultiple(messages);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<MessageBean>> queryAllByIdLD(long userId) {
        String _sql = "SELECT * FROM MessageBean WHERE userId = ? ORDER BY read, messageId desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM MessageBean WHERE userId = ? ORDER BY read, messageId desc", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, userId);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"MessageBean"}, false, (Callable)new Callable<List<MessageBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfRead = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"read");
                    int _cursorIndexOfCreateTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createTime");
                    int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                    int _cursorIndexOfOperateType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"operateType");
                    int _cursorIndexOfMessageParams = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageParams");
                    int _cursorIndexOfMessageSeparator = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageSeparator");
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfInvitationUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invitationUserId");
                    int _cursorIndexOfCreateFamilyUserNick = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createFamilyUserNick");
                    ArrayList<MessageBean> _result = new ArrayList<MessageBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        MessageBean _item = new MessageBean();
                        long _tmpMessageId = _cursor.getLong(_cursorIndexOfMessageId);
                        _item.setMessageId(_tmpMessageId);
                        long _tmpUserId = _cursor.getLong(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        int _tmp = _cursor.getInt(_cursorIndexOfRead);
                        boolean _tmpRead = _tmp != 0;
                        _item.setRead(_tmpRead);
                        long _tmpCreateTime = _cursor.getLong(_cursorIndexOfCreateTime);
                        _item.setCreateTime(_tmpCreateTime);
                        int _tmpMessageType = _cursor.getInt(_cursorIndexOfMessageType);
                        _item.setMessageType(_tmpMessageType);
                        int _tmpOperateType = _cursor.getInt(_cursorIndexOfOperateType);
                        _item.setOperateType(_tmpOperateType);
                        String _tmpMessageParams = _cursor.isNull(_cursorIndexOfMessageParams) ? null : _cursor.getString(_cursorIndexOfMessageParams);
                        _item.setMessageParams(_tmpMessageParams);
                        String _tmpMessageSeparator = _cursor.isNull(_cursorIndexOfMessageSeparator) ? null : _cursor.getString(_cursorIndexOfMessageSeparator);
                        _item.setMessageSeparator(_tmpMessageSeparator);
                        Long _tmpFamilyId = _cursor.isNull(_cursorIndexOfFamilyId) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfFamilyId));
                        _item.setFamilyId(_tmpFamilyId);
                        Long _tmpInvitationUserId = _cursor.isNull(_cursorIndexOfInvitationUserId) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfInvitationUserId));
                        _item.setInvitationUserId(_tmpInvitationUserId);
                        String _tmpCreateFamilyUserNick = _cursor.isNull(_cursorIndexOfCreateFamilyUserNick) ? null : _cursor.getString(_cursorIndexOfCreateFamilyUserNick);
                        _item.setCreateFamilyUserNick(_tmpCreateFamilyUserNick);
                        _result.add(_item);
                    }
                    ArrayList<MessageBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageBean> queryAllById(long userId) {
        String _sql = "SELECT * FROM MessageBean WHERE userId = ? ORDER BY read, messageId desc";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM MessageBean WHERE userId = ? ORDER BY read, messageId desc", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, userId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfRead = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"read");
            int _cursorIndexOfCreateTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createTime");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfOperateType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"operateType");
            int _cursorIndexOfMessageParams = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageParams");
            int _cursorIndexOfMessageSeparator = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageSeparator");
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfInvitationUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invitationUserId");
            int _cursorIndexOfCreateFamilyUserNick = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createFamilyUserNick");
            ArrayList<MessageBean> _result = new ArrayList<MessageBean>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                MessageBean _item = new MessageBean();
                long _tmpMessageId = _cursor.getLong(_cursorIndexOfMessageId);
                _item.setMessageId(_tmpMessageId);
                long _tmpUserId = _cursor.getLong(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                int _tmp = _cursor.getInt(_cursorIndexOfRead);
                boolean _tmpRead = _tmp != 0;
                _item.setRead(_tmpRead);
                long _tmpCreateTime = _cursor.getLong(_cursorIndexOfCreateTime);
                _item.setCreateTime(_tmpCreateTime);
                int _tmpMessageType = _cursor.getInt(_cursorIndexOfMessageType);
                _item.setMessageType(_tmpMessageType);
                int _tmpOperateType = _cursor.getInt(_cursorIndexOfOperateType);
                _item.setOperateType(_tmpOperateType);
                String _tmpMessageParams = _cursor.isNull(_cursorIndexOfMessageParams) ? null : _cursor.getString(_cursorIndexOfMessageParams);
                _item.setMessageParams(_tmpMessageParams);
                String _tmpMessageSeparator = _cursor.isNull(_cursorIndexOfMessageSeparator) ? null : _cursor.getString(_cursorIndexOfMessageSeparator);
                _item.setMessageSeparator(_tmpMessageSeparator);
                Long _tmpFamilyId = _cursor.isNull(_cursorIndexOfFamilyId) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfFamilyId));
                _item.setFamilyId(_tmpFamilyId);
                Long _tmpInvitationUserId = _cursor.isNull(_cursorIndexOfInvitationUserId) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfInvitationUserId));
                _item.setInvitationUserId(_tmpInvitationUserId);
                String _tmpCreateFamilyUserNick = _cursor.isNull(_cursorIndexOfCreateFamilyUserNick) ? null : _cursor.getString(_cursorIndexOfCreateFamilyUserNick);
                _item.setCreateFamilyUserNick(_tmpCreateFamilyUserNick);
                _result.add(_item);
            }
            ArrayList<MessageBean> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<Integer> getMessageCountLD(long userId, boolean read) {
        String _sql = "SELECT COUNT(*) FROM MessageBean WHERE userId = ? AND read = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM MessageBean WHERE userId = ? AND read = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, userId);
        _argIndex = 2;
        int _tmp = read ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"MessageBean"}, false, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp_1 = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp_1;
                    } else {
                        _result = null;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

