/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.family.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.smartlife.nebula.family.bean.RoomBean;
import com.smartlife.nebula.family.db.dao.RoomDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class RoomDao_Impl
implements RoomDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<RoomBean> __insertionAdapterOfRoomBean;
    private final EntityDeletionOrUpdateAdapter<RoomBean> __deletionAdapterOfRoomBean;
    private final EntityDeletionOrUpdateAdapter<RoomBean> __updateAdapterOfRoomBean;

    public RoomDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRoomBean = new EntityInsertionAdapter<RoomBean>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `RoomBean` (`familyId`,`roomName`,`roomDeviceCount`,`insertTime`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, RoomBean value) {
                stmt.bindLong(1, value.getFamilyId());
                if (value.getRoomName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getRoomName());
                }
                stmt.bindLong(3, (long)value.getRoomDeviceCount());
                stmt.bindLong(4, value.getInsertTime());
            }
        };
        this.__deletionAdapterOfRoomBean = new EntityDeletionOrUpdateAdapter<RoomBean>(__db){

            public String createQuery() {
                return "DELETE FROM `RoomBean` WHERE `familyId` = ? AND `roomName` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RoomBean value) {
                stmt.bindLong(1, value.getFamilyId());
                if (value.getRoomName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getRoomName());
                }
            }
        };
        this.__updateAdapterOfRoomBean = new EntityDeletionOrUpdateAdapter<RoomBean>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `RoomBean` SET `familyId` = ?,`roomName` = ?,`roomDeviceCount` = ?,`insertTime` = ? WHERE `familyId` = ? AND `roomName` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RoomBean value) {
                stmt.bindLong(1, value.getFamilyId());
                if (value.getRoomName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getRoomName());
                }
                stmt.bindLong(3, (long)value.getRoomDeviceCount());
                stmt.bindLong(4, value.getInsertTime());
                stmt.bindLong(5, value.getFamilyId());
                if (value.getRoomName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getRoomName());
                }
            }
        };
    }

    @Override
    public void insertRoom(RoomBean roomBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRoomBean.insert((Object)roomBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteRoom(RoomBean roomBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRoomBean.handle((Object)roomBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateRoom(RoomBean roomBean) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfRoomBean.handle((Object)roomBean);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<RoomBean>> queryAll(long familyId) {
        String _sql = "SELECT * FROM RoomBean where familyId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM RoomBean where familyId = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"RoomBean"}, false, (Callable)new Callable<List<RoomBean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RoomBean> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)RoomDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
                    int _cursorIndexOfRoomName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomName");
                    int _cursorIndexOfRoomDeviceCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomDeviceCount");
                    int _cursorIndexOfInsertTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"insertTime");
                    ArrayList<RoomBean> _result = new ArrayList<RoomBean>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        RoomBean _item = new RoomBean();
                        long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                        _item.setFamilyId(_tmpFamilyId);
                        String _tmpRoomName = _cursor.isNull(_cursorIndexOfRoomName) ? null : _cursor.getString(_cursorIndexOfRoomName);
                        _item.setRoomName(_tmpRoomName);
                        int _tmpRoomDeviceCount = _cursor.getInt(_cursorIndexOfRoomDeviceCount);
                        _item.setRoomDeviceCount(_tmpRoomDeviceCount);
                        long _tmpInsertTime = _cursor.getLong(_cursorIndexOfInsertTime);
                        _item.setInsertTime(_tmpInsertTime);
                        _result.add(_item);
                    }
                    ArrayList<RoomBean> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoomBean querySingleRoom(long familyId, String roomName) {
        String _sql = "SELECT * FROM RoomBean where familyId = ? and roomName = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM RoomBean where familyId = ? and roomName = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, familyId);
        _argIndex = 2;
        if (roomName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, roomName);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            RoomBean _result;
            int _cursorIndexOfFamilyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"familyId");
            int _cursorIndexOfRoomName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomName");
            int _cursorIndexOfRoomDeviceCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomDeviceCount");
            int _cursorIndexOfInsertTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"insertTime");
            if (_cursor.moveToFirst()) {
                _result = new RoomBean();
                long _tmpFamilyId = _cursor.getLong(_cursorIndexOfFamilyId);
                _result.setFamilyId(_tmpFamilyId);
                String _tmpRoomName = _cursor.isNull(_cursorIndexOfRoomName) ? null : _cursor.getString(_cursorIndexOfRoomName);
                _result.setRoomName(_tmpRoomName);
                int _tmpRoomDeviceCount = _cursor.getInt(_cursorIndexOfRoomDeviceCount);
                _result.setRoomDeviceCount(_tmpRoomDeviceCount);
                long _tmpInsertTime = _cursor.getLong(_cursorIndexOfInsertTime);
                _result.setInsertTime(_tmpInsertTime);
            } else {
                _result = null;
            }
            RoomBean roomBean = _result;
            return roomBean;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

