/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.sort;

import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import libcore.icu.Transliterator;

public class HanziToPinyin {
    private static final String TAG = "HanziToPinyin";
    private static HanziToPinyin sInstance;
    private Transliterator mPinyinTransliterator;
    private Transliterator mAsciiTransliterator;
    private static final char FIRST_RUSSIAN_UPPER = '\u0410';
    private static final char LAST_RUSSIAN_UPPER = '\u042f';
    private static final char LAST_RUSSIAN_LOWER = '\u044f';
    private static final char FIRST_ARABIC = '\u0628';
    private static final char LAST_ARABIC = '\u0649';
    private static final char FIRST_HEBREW = '\u05d0';
    private static final char LAST_HEBREW = '\u05ea';
    public static final int RUSSIAN = 14;
    public static final int ARABIC = 15;
    public static final int HEBREW = 16;
    private static Map<Character, Character> sMuiSupportMap;
    private static final ArrayList<Character> SPECIAL_CHARS_LIST_UPPER;
    private static final ArrayList<Character> SPECIAL_CHARS_LIST_LOWER;

    static {
        sMuiSupportMap = new HashMap<Character, Character>();
        sMuiSupportMap.put(Character.valueOf('\u0410'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0411'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0412'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0413'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0414'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0415'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0416'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0417'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0418'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u0419'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u041a'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u041b'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u041c'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u041d'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u041e'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u041f'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u0420'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0421'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0422'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0423'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0424'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0425'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0426'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0427'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0428'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0429'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u042a'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u042b'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u042c'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u042d'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u042e'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u042f'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u0430'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0431'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0432'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0433'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0434'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0435'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0436'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0437'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0438'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u0439'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u043a'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u043b'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u043c'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u043d'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u043e'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u043f'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u0440'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0441'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0442'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0443'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0444'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0445'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0446'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0447'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0448'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0449'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u044a'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u044b'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u044c'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u044d'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u044e'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u044f'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u0401'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0451'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0628'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0629'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u062a'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u062b'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u0621'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0627'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u0633'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u0634'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u0635'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u0636'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u062f'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u0630'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u0631'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u0632'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u062c'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u062d'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u062e'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u0646'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0647'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0648'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0649'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u0641'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0642'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0643'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0644'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0645'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u0637'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u0638'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u0639'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u063a'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u05d3'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u05d4'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u05d5'), Character.valueOf('2'));
        sMuiSupportMap.put(Character.valueOf('\u05d0'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u05d1'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u05d2'), Character.valueOf('3'));
        sMuiSupportMap.put(Character.valueOf('\u05de'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u05e0'), Character.valueOf('4'));
        sMuiSupportMap.put(Character.valueOf('\u05dc'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u05db'), Character.valueOf('5'));
        sMuiSupportMap.put(Character.valueOf('\u05d6'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u05d7'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u05d8'), Character.valueOf('6'));
        sMuiSupportMap.put(Character.valueOf('\u05e8'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u05e9'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u05ea'), Character.valueOf('7'));
        sMuiSupportMap.put(Character.valueOf('\u05e6'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u05e7'), Character.valueOf('8'));
        sMuiSupportMap.put(Character.valueOf('\u05e1'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u05e2'), Character.valueOf('9'));
        sMuiSupportMap.put(Character.valueOf('\u05e3'), Character.valueOf('9'));
        SPECIAL_CHARS_LIST_UPPER = new ArrayList();
        SPECIAL_CHARS_LIST_LOWER = new ArrayList();
        SPECIAL_CHARS_LIST_UPPER.add(Character.valueOf('\u0401'));
        SPECIAL_CHARS_LIST_LOWER.add(Character.valueOf('\u0451'));
    }

    private HanziToPinyin() {
        try {
            this.mPinyinTransliterator = new Transliterator("Han-Latin/Names; Latin-Ascii; Any-Upper");
            this.mAsciiTransliterator = new Transliterator("Latin-Ascii");
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Han-Latin/Names transliterator data is missing, HanziToPinyin is disabled");
        }
    }

    public boolean hasChineseTransliterator() {
        return this.mPinyinTransliterator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HanziToPinyin getInstance() {
        Class<HanziToPinyin> clazz = HanziToPinyin.class;
        synchronized (HanziToPinyin.class) {
            if (sInstance == null) {
                sInstance = new HanziToPinyin();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void tokenize(char character, Token token) {
        token.source = Character.toString(character);
        if (character < '\u0080') {
            token.type = 1;
            token.target = token.source;
            return;
        }
        if (character < '\u0250' || '\u1e00' <= character && character < '\u1eff') {
            token.type = 1;
            token.target = this.mAsciiTransliterator == null ? token.source : this.mAsciiTransliterator.transliterate(token.source);
            return;
        }
        token.type = 2;
        token.target = this.mPinyinTransliterator.transliterate(token.source);
        if (TextUtils.isEmpty((CharSequence)token.target) || TextUtils.equals((CharSequence)token.source, (CharSequence)token.target)) {
            token.type = 3;
            token.target = token.source;
        }
    }

    public String transliterate(String input) {
        if (!this.hasChineseTransliterator() || TextUtils.isEmpty((CharSequence)input)) {
            return "";
        }
        return this.mPinyinTransliterator.transliterate(input);
    }

    public ArrayList<Token> getTokens(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (!this.hasChineseTransliterator() || TextUtils.isEmpty((CharSequence)input)) {
            return tokens;
        }
        int inputLength = input.length();
        StringBuilder sb = new StringBuilder();
        int tokenType = 1;
        Token token = new Token();
        int i = 0;
        while (i < inputLength) {
            char character = input.charAt(i);
            if (Character.isSpaceChar(character)) {
                if (sb.length() > 0) {
                    this.addToken(sb, tokens, tokenType);
                }
            } else {
                this.tokenize(character, token);
                if (token.type == 2) {
                    if (sb.length() > 0) {
                        this.addToken(sb, tokens, tokenType);
                    }
                    tokens.add(token);
                    token = new Token();
                } else {
                    if (tokenType != token.type && sb.length() > 0) {
                        this.addToken(sb, tokens, tokenType);
                    }
                    sb.append(token.target);
                }
                tokenType = token.type;
            }
            ++i;
        }
        if (sb.length() > 0) {
            this.addToken(sb, tokens, tokenType);
        }
        return tokens;
    }

    private void addToken(StringBuilder sb, ArrayList<Token> tokens, int tokenType) {
        String str = sb.toString();
        tokens.add(new Token(tokenType, str, str));
        sb.setLength(0);
    }

    public String getTokensForDialerSearch(String input, StringBuilder offsets) {
        if (offsets == null || input == null || TextUtils.isEmpty((CharSequence)input)) {
            return null;
        }
        StringBuilder subStrSet = new StringBuilder();
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<String> shortSubStrOffset = new ArrayList<String>();
        int inputLength = input.length();
        StringBuilder subString = new StringBuilder();
        StringBuilder subStrOffset = new StringBuilder();
        int tokenType = 1;
        int caseTypePre = 0;
        int caseTypeCurr = 1;
        int mPos = 0;
        int i = 0;
        while (i < inputLength) {
            Character c;
            char character = input.charAt(i);
            if (character == '-' || character == ',') {
                ++mPos;
            } else if (character == ' ') {
                if (subString.length() > 0) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                this.addSubString(tokens, shortSubStrOffset, subStrSet, offsets);
                ++mPos;
                caseTypePre = 0;
            } else if (character < '\u0100') {
                if (tokenType != 1 && subString.length() > 0) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                int n = caseTypeCurr = character >= 'A' && character <= 'Z' ? 1 : 2;
                if (caseTypePre == 2 && caseTypeCurr == 1) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                caseTypePre = caseTypeCurr;
                tokenType = 1;
                c = Character.valueOf(Character.toUpperCase(character));
                if (c != null) {
                    subString.append(c);
                    subStrOffset.append((char)mPos);
                }
                ++mPos;
            } else if (this.isSpecialRussianCharacter(character) || character >= '\u0410' && character <= '\u044f') {
                if (tokenType != 14 && subString.length() > 0) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                int n = caseTypeCurr = this.isUpperCaseSpecialRussianChar(character) || character >= '\u0410' && character <= '\u042f' ? 1 : 2;
                if (caseTypePre == 2 && caseTypeCurr == 1) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                caseTypePre = caseTypeCurr;
                tokenType = 14;
                c = sMuiSupportMap.get(Character.valueOf(character));
                if (c != null) {
                    subString.append(c);
                    subStrOffset.append((char)mPos);
                }
                ++mPos;
            } else if (character >= '\u0628' && character <= '\u0649') {
                if (tokenType != 15 && subString.length() > 0) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                caseTypePre = caseTypeCurr;
                tokenType = 15;
                c = sMuiSupportMap.get(Character.valueOf(character));
                if (c != null) {
                    subString.append(c);
                    subStrOffset.append((char)mPos);
                }
                ++mPos;
            } else if (character >= '\u05d0' && character <= '\u05ea') {
                if (tokenType != 16 && subString.length() > 0) {
                    this.addToken(subString, tokens, tokenType);
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                }
                caseTypePre = caseTypeCurr;
                tokenType = 16;
                c = sMuiSupportMap.get(Character.valueOf(character));
                if (c != null) {
                    subString.append(c);
                    subStrOffset.append((char)mPos);
                }
                ++mPos;
            } else {
                Token t = new Token();
                this.tokenize(character, t);
                int tokenSize = t.target.length();
                if (t.type == 2) {
                    if (subString.length() > 0) {
                        this.addToken(subString, tokens, tokenType);
                        this.addOffsets(subStrOffset, shortSubStrOffset);
                    }
                    tokens.add(t);
                    int j = 0;
                    while (j < tokenSize) {
                        subStrOffset.append((char)mPos);
                        ++j;
                    }
                    this.addOffsets(subStrOffset, shortSubStrOffset);
                    tokenType = 2;
                    caseTypePre = 0;
                    ++mPos;
                } else {
                    ++mPos;
                }
            }
            if (mPos > 127) break;
            ++i;
        }
        if (subString.length() > 0) {
            this.addToken(subString, tokens, tokenType);
            this.addOffsets(subStrOffset, shortSubStrOffset);
        }
        this.addSubString(tokens, shortSubStrOffset, subStrSet, offsets);
        return subStrSet.toString();
    }

    private boolean isSpecialRussianCharacter(char specialchar) {
        return SPECIAL_CHARS_LIST_UPPER.contains(Character.valueOf(specialchar)) || SPECIAL_CHARS_LIST_LOWER.contains(Character.valueOf(specialchar));
    }

    private boolean isUpperCaseSpecialRussianChar(char specialchar) {
        return SPECIAL_CHARS_LIST_UPPER.contains(Character.valueOf(specialchar));
    }

    private void addOffsets(StringBuilder sb, ArrayList<String> shortSubStrOffset) {
        String str = sb.toString();
        shortSubStrOffset.add(str);
        sb.setLength(0);
    }

    private void addSubString(ArrayList<Token> tokens, ArrayList<String> shortSubStrOffset, StringBuilder subStrSet, StringBuilder offsets) {
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        int size = tokens.size();
        int len = 0;
        StringBuilder mShortSubStr = new StringBuilder();
        StringBuilder mShortSubStrOffsets = new StringBuilder();
        StringBuilder mShortSubStrSet = new StringBuilder();
        StringBuilder mShortSubStrOffsetsSet = new StringBuilder();
        int i = size - 1;
        while (i >= 0) {
            String mTempStr = tokens.get((int)i).target;
            len = mTempStr.length();
            String mTempOffset = shortSubStrOffset.get(i);
            if (mShortSubStr.length() > 0) {
                mShortSubStr.setLength(0);
                mShortSubStrOffsets.setLength(0);
            }
            mShortSubStr.insert(0, mTempStr);
            mShortSubStr.insert(0, (char)len);
            mShortSubStrOffsets.insert(0, mTempOffset);
            mShortSubStrOffsets.insert(0, (char)len);
            mShortSubStrSet.insert(0, mShortSubStr);
            mShortSubStrOffsetsSet.insert(0, mShortSubStrOffsets);
            --i;
        }
        subStrSet.append((CharSequence)mShortSubStrSet);
        offsets.append((CharSequence)mShortSubStrOffsetsSet);
        tokens.clear();
        shortSubStrOffset.clear();
    }

    private class DialerSearchToken
    extends Token {
        static final int FIRSTCASE = 0;
        static final int UPPERCASE = 1;
        static final int LOWERCASE = 2;

        private DialerSearchToken() {
        }
    }

    public static class Token {
        public static final String SEPARATOR = " ";
        public static final int LATIN = 1;
        public static final int PINYIN = 2;
        public static final int UNKNOWN = 3;
        public static final int RUSSIAN = 14;
        public static final int ARABIC = 15;
        public static final int HEBREW = 16;
        public int type;
        public String source;
        public String target;

        public Token() {
        }

        public Token(int type, String source, String target) {
            this.type = type;
            this.source = source;
            this.target = target;
        }
    }
}

