/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.anim;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import java.lang.ref.WeakReference;

public class OSSpringPressSealAnimation
implements View.OnTouchListener {
    private static final String TAG = "OSSpringPressSealAnimat";
    private final float mStartValue;
    private final float mEndValue;
    private float mCurrentStartValue;
    private float mCurrentEndValue;
    private final float mStartStiffness;
    private final float mEndStiffness;
    private final float mDampingRatio;
    private final FloatValueHolder mFloatValueHolder;
    private final float mVelocity;
    private WeakReference<View> mViewHolder;
    private float mTouchSlop;
    private OnSpringClickListner mClickListener;
    private View.OnTouchListener mOnTouchListener;
    private OnAnimationEndListener mOnAnimationEndListener;
    private OnAnimationUpdateListener mOnAnimationUpdateListener;
    boolean regret = false;
    float mDownX;
    float mDownY;
    private SpringAnimation startAnimation;
    private SpringAnimation endAnimation;

    private OSSpringPressSealAnimation(Builder builder) {
        this.mStartValue = builder.startValue;
        this.mEndValue = builder.finalValue;
        this.mEndStiffness = builder.endStiffness;
        this.mStartStiffness = builder.startStiffness;
        this.mDampingRatio = builder.dampingRatio;
        this.mFloatValueHolder = builder.floatValueHolder;
        this.mVelocity = builder.velocity;
        this.mViewHolder = builder.viewHolder;
        this.mClickListener = builder.clickListener;
        this.mOnTouchListener = builder.onTouchListener;
        this.mOnAnimationEndListener = builder.onAnimationEndListener;
        this.mOnAnimationUpdateListener = builder.onAnimationUpdateListener;
        if (this.mViewHolder != null) {
            this.mTouchSlop = builder.touchSlop > 0.0f ? (float)OSSpringPressSealAnimation.dp2px((int)builder.touchSlop) : (float)OSSpringPressSealAnimation.dp2px(20);
        }
        this.mCurrentStartValue = this.mStartValue;
        this.mCurrentEndValue = this.mEndValue;
        if (this.mViewHolder != null && this.mViewHolder.get() != null) {
            ((View)this.mViewHolder.get()).setOnTouchListener((View.OnTouchListener)this);
        }
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    private SpringAnimation createStartAnimation(float startValue, float endValue) {
        SpringForce springForce = new SpringForce().setStiffness(this.mStartStiffness).setDampingRatio(this.mDampingRatio);
        springForce.setFinalPosition(endValue);
        SpringAnimation springAnimation = new SpringAnimation(this.mFloatValueHolder);
        springAnimation.setSpring(springForce);
        springAnimation.setStartValue(startValue);
        springAnimation.setStartVelocity(this.mVelocity);
        springAnimation.setMinimumVisibleChange(0.002f);
        springAnimation.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

            public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
                if (OSSpringPressSealAnimation.this.mViewHolder == null || OSSpringPressSealAnimation.this.mViewHolder.get() == null) {
                    if (animation != null && animation.isRunning()) {
                        animation.cancel();
                    }
                    return;
                }
                View view = (View)OSSpringPressSealAnimation.this.mViewHolder.get();
                view.setScaleX(value);
                view.setScaleY(value);
                if (OSSpringPressSealAnimation.this.mOnAnimationUpdateListener != null) {
                    OSSpringPressSealAnimation.this.mOnAnimationUpdateListener.onAnimationUpdate(true, animation, value, velocity);
                }
            }
        });
        springAnimation.addEndListener(new DynamicAnimation.OnAnimationEndListener(){

            public void onAnimationEnd(DynamicAnimation animation, boolean canceled, float value, float velocity) {
                if (!canceled) {
                    OSSpringPressSealAnimation.this.mCurrentStartValue = OSSpringPressSealAnimation.this.mEndValue;
                } else {
                    OSSpringPressSealAnimation.this.mCurrentStartValue = value;
                }
                OSSpringPressSealAnimation.this.mCurrentEndValue = OSSpringPressSealAnimation.this.mStartValue;
                if (OSSpringPressSealAnimation.this.mOnAnimationEndListener != null) {
                    OSSpringPressSealAnimation.this.mOnAnimationEndListener.onAnimationEnd(true, animation, canceled, OSSpringPressSealAnimation.this.regret, value, velocity);
                }
            }
        });
        return springAnimation;
    }

    private SpringAnimation createEndAnimation(float startValue, float endValue) {
        SpringForce springForce = new SpringForce().setStiffness(this.mEndStiffness).setDampingRatio(this.mDampingRatio);
        springForce.setFinalPosition(endValue);
        SpringAnimation springAnimation = new SpringAnimation(this.mFloatValueHolder);
        springAnimation.setSpring(springForce);
        springAnimation.setStartValue(startValue);
        springAnimation.setStartVelocity(this.mVelocity);
        springAnimation.setMinimumVisibleChange(0.002f);
        springAnimation.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

            public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
                if (OSSpringPressSealAnimation.this.mViewHolder == null || OSSpringPressSealAnimation.this.mViewHolder.get() == null) {
                    if (animation != null && animation.isRunning()) {
                        animation.cancel();
                    }
                    return;
                }
                View view = (View)OSSpringPressSealAnimation.this.mViewHolder.get();
                view.setScaleX(value);
                view.setScaleY(value);
                if (OSSpringPressSealAnimation.this.mOnAnimationUpdateListener != null) {
                    OSSpringPressSealAnimation.this.mOnAnimationUpdateListener.onAnimationUpdate(false, animation, value, velocity);
                }
            }
        });
        springAnimation.addEndListener(new DynamicAnimation.OnAnimationEndListener(){

            public void onAnimationEnd(DynamicAnimation animation, boolean canceled, float value, float velocity) {
                if (!canceled) {
                    OSSpringPressSealAnimation.this.mCurrentStartValue = OSSpringPressSealAnimation.this.mStartValue;
                } else {
                    OSSpringPressSealAnimation.this.mCurrentStartValue = value;
                }
                OSSpringPressSealAnimation.this.mCurrentEndValue = OSSpringPressSealAnimation.this.mEndValue;
                if (OSSpringPressSealAnimation.this.mOnAnimationEndListener != null) {
                    OSSpringPressSealAnimation.this.mOnAnimationEndListener.onAnimationEnd(false, animation, canceled, OSSpringPressSealAnimation.this.regret, value, velocity);
                }
            }
        });
        return springAnimation;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mOnTouchListener != null) {
            this.mOnTouchListener.onTouch(v, event);
        }
        if (event.getAction() == 0) {
            this.mDownX = event.getX();
            this.mDownY = event.getY();
            if (this.endAnimation != null && this.endAnimation.isRunning()) {
                this.endAnimation.cancel();
            }
            this.startAnimation = this.createStartAnimation(this.mCurrentStartValue, this.mCurrentEndValue);
            this.startAnimation.start();
            if (this.mClickListener != null && v != null) {
                this.mClickListener.onClick(v, true);
            }
            this.regret = false;
            return true;
        }
        if (event.getAction() == 1 || event.getAction() == 3) {
            if (!this.regret) {
                if (event.getAction() == 3) {
                    this.regret = true;
                }
                if (this.startAnimation != null && this.startAnimation.isRunning()) {
                    this.startAnimation.cancel();
                }
                this.endAnimation = this.createEndAnimation(this.mCurrentStartValue, this.mCurrentEndValue);
                this.endAnimation.start();
            }
            if (event.getAction() == 1 && this.mClickListener != null && v != null) {
                this.mClickListener.onClick(v, false);
            }
            return true;
        }
        if (event.getAction() == 2 && (event.getX() < 0.0f || event.getY() < 0.0f || event.getX() > (float)v.getWidth() || event.getY() > (float)v.getHeight() || this.judgeDistance(event)) && !this.regret) {
            this.regret = true;
            if (this.startAnimation != null && this.startAnimation.isRunning()) {
                this.startAnimation.cancel();
            }
            this.endAnimation = this.createEndAnimation(this.mCurrentStartValue, this.mCurrentEndValue);
            this.endAnimation.start();
        }
        return false;
    }

    private boolean judgeDistance(MotionEvent event) {
        double sqrt = Math.sqrt(Math.pow(event.getX() - this.mDownX, 2.0) + Math.pow(event.getY() - this.mDownY, 2.0));
        return sqrt > (double)this.mTouchSlop;
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd(boolean var1, DynamicAnimation var2, boolean var3, boolean var4, float var5, float var6);
    }

    public static interface OnAnimationUpdateListener {
        public void onAnimationUpdate(boolean var1, DynamicAnimation var2, float var3, float var4);
    }

    public static class Builder {
        private float startValue = 1.0f;
        private float finalValue;
        private float startStiffness = 350.0f;
        private float endStiffness = 350.0f;
        private float dampingRatio = 1.2f;
        private FloatValueHolder floatValueHolder;
        private float velocity = 0.0f;
        private ViewParent viewParent;
        private OnAnimationUpdateListener onAnimationUpdateListener;
        private OnAnimationEndListener onAnimationEndListener;
        private View.OnTouchListener onTouchListener;
        private WeakReference viewHolder;
        private OnSpringClickListner clickListener;
        private float touchSlop;

        public Builder startValue(float startValue) {
            this.startValue = startValue;
            return this;
        }

        public Builder addOnAnimationUpdateListener(OnAnimationUpdateListener onAnimationUpdateListener) {
            this.onAnimationUpdateListener = onAnimationUpdateListener;
            return this;
        }

        public Builder addOnAnimationEndListener(OnAnimationEndListener onAnimationEndListener) {
            this.onAnimationEndListener = onAnimationEndListener;
            return this;
        }

        public Builder setOnTouchListener(View.OnTouchListener onTouchListener) {
            this.onTouchListener = onTouchListener;
            return this;
        }

        public Builder finalValue(float finalValue) {
            this.finalValue = finalValue;
            return this;
        }

        public Builder view(View view) {
            this.viewHolder = new WeakReference<View>(view);
            return this;
        }

        public Builder floatVlaueHolder(FloatValueHolder floatValueHolder) {
            this.floatValueHolder = floatValueHolder;
            return this;
        }

        public Builder startStiffness(float stiffness) {
            this.startStiffness = stiffness;
            return this;
        }

        public Builder endStiffness(float stiffness) {
            this.endStiffness = stiffness;
            return this;
        }

        public Builder velocity(float velocity) {
            this.velocity = velocity;
            return this;
        }

        public Builder dampingRatio(float dampingRatio) {
            this.dampingRatio = dampingRatio;
            return this;
        }

        public Builder setViewParent(ViewParent viewParent) {
            this.viewParent = viewParent;
            return this;
        }

        public Builder setOnClickListener(OnSpringClickListner clickListener) {
            this.clickListener = clickListener;
            return this;
        }

        public Builder setRegretDistance(float touchSlot) {
            this.touchSlop = touchSlot;
            return this;
        }

        public OSSpringPressSealAnimation build() {
            if (this.floatValueHolder == null) {
                throw new IllegalStateException("property == null");
            }
            return new OSSpringPressSealAnimation(this);
        }
    }

    public static interface OnSpringClickListner {
        public void onClick(View var1, boolean var2);
    }
}

